/**
 * <pre>
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details. 
 * 	You should have received a copy of the GNU General Public License along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * </pre>
 */
package com.meidusa.toolkit.common.bean.config;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.PureJavaReflectionProvider;
import com.meidusa.toolkit.common.bean.ReflectionProvider;
import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.util.ObjectUtil;


/**
 * Bean ĻϢ
 * 
 * @author <a href=mailto:piratebase@sina.com>Struct chen</a>
 * @version $Id: BeanObjectEntityConfig.java 3594 2006-11-23 07:39:25Z struct $
 */
@SuppressWarnings("unchecked")
public class BeanObjectEntityConfig<T> extends ConfigEntity implements Cloneable {
    private static Logger                     logger             = Logger.getLogger(BeanObjectEntityConfig.class);
    private static final long                 serialVersionUID   = 1L;
    private static ReflectionProvider reflectionProvider = PureJavaReflectionProvider.getInstance();

    private String                            name;
    private Class<? extends T>                            beanClass;
    private Map<String, Object>               params             = new HashMap<String, Object>();

    public Class<? extends T> getBeanClass() {
        return beanClass;
    }

    public void setBeanClass(Class<? extends T> beanObject) {
        this.beanClass = beanObject;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getParams() {
        return params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    /**
     * cloneɸǴ˷
     */

	protected BeanObjectEntityConfig<T> newObject() {
        Object object = null;
        try {
            object = this.getClass().newInstance();
        } catch (InstantiationException e) {
            logger.error("Instantiation class :" + this.getClass() + " Exception", e);
        } catch (IllegalAccessException e) {
            logger.error("IllegalAccess class :" + this.getClass() + " Exception", e);
        }
        return (BeanObjectEntityConfig<T>) object;
    }

    public Object createBeanObject(boolean initEarly,final Map context) throws ConfigurationException {
        try {
            Object object = reflectionProvider.newInstance(beanClass);
            ParameterMapping.mappingObject(object, getParams(),new BeanContext(){

				public Object createBean(Class clazz) throws Exception {
					return clazz.newInstance();
				}

				public Object getBean(String beanName) {
					return context.get(beanName);
				}
            	
            });
            if (initEarly) {
                if (object instanceof Initialisable) {
                    ((Initialisable) object).init();
                }
            }
            return object;
        } catch (InitialisationException e) {
            logger.error("instanceo object error:", e);
            throw new ConfigurationException(e);
        }
    }
    
    public T createBeanObject(boolean initEarly) throws ConfigurationException {
        try {
            T object = (T)reflectionProvider.newInstance(beanClass);
            ParameterMapping.mappingObject(object, getParams());
            if (initEarly) {
                if (object instanceof Initialisable) {
                    ((Initialisable) object).init();
                }
            }
            return object;
        } catch (InitialisationException e) {
            logger.error("instanceo object error:", e);
            throw new ConfigurationException(e);
        }
    }

    public Object clone() {
        BeanObjectEntityConfig<T> entityConfig = newObject();

        if (entityConfig == null) {
            return null;
        }

        entityConfig.beanClass = this.beanClass;
        entityConfig.name = this.name;
        Map<String, Object> params = new HashMap<String, Object>();
        params.putAll(this.params);
        return entityConfig;
    }

    public int hashCode() {
        int hashcode = 37;
        hashcode += (this.name == null ? 0 : name.hashCode());
        hashcode += (this.beanClass == null ? 0 : beanClass.hashCode());
        hashcode += (this.params == null ? 0 : params.hashCode());
        return hashcode;
    }

    public boolean equals(Object object) {
        if (object instanceof BeanObjectEntityConfig) {
            BeanObjectEntityConfig entity = (BeanObjectEntityConfig) object;
            boolean isEquals = StringUtils.equals(this.name, entity.name);
            isEquals = isEquals && (this.beanClass == entity.getBeanClass());
            isEquals = isEquals && (ObjectUtil.equals(this.params, entity.params));

            return isEquals;
        }
        return false;
    }

}
