/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.bean.config;

import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.PureJavaReflectionProvider;
import com.meidusa.toolkit.common.bean.ReflectionProvider;
import com.meidusa.toolkit.common.bean.config.ConfigEntity;
import com.meidusa.toolkit.common.bean.config.ConfigurationException;
import com.meidusa.toolkit.common.bean.config.ParameterMapping;
import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.util.ObjectUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanObjectEntityConfig<T>
extends ConfigEntity
implements Cloneable {
    private static Logger logger = Logger.getLogger(BeanObjectEntityConfig.class);
    private static final long serialVersionUID = 1L;
    private static ReflectionProvider reflectionProvider = PureJavaReflectionProvider.getInstance();
    private String name;
    private Class<? extends T> beanClass;
    private Map<String, Object> params = new HashMap<String, Object>();

    public Class<? extends T> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<? extends T> beanObject) {
        this.beanClass = beanObject;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    protected BeanObjectEntityConfig<T> newObject() {
        Object object = null;
        try {
            object = this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)("Instantiation class :" + this.getClass() + " Exception"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("IllegalAccess class :" + this.getClass() + " Exception"), (Throwable)e);
        }
        return object;
    }

    public Object createBeanObject(boolean initEarly, final Map context) throws ConfigurationException {
        try {
            Object object = reflectionProvider.newInstance(this.beanClass);
            ParameterMapping.mappingObject(object, this.getParams(), new BeanContext(){

                public Object createBean(Class clazz) throws Exception {
                    return clazz.newInstance();
                }

                public Object getBean(String beanName) {
                    return context.get(beanName);
                }
            });
            if (initEarly && object instanceof Initialisable) {
                ((Initialisable)object).init();
            }
            return object;
        }
        catch (InitialisationException e) {
            logger.error((Object)"instanceo object error:", (Throwable)e);
            throw new ConfigurationException(e);
        }
    }

    public T createBeanObject(boolean initEarly) throws ConfigurationException {
        try {
            Object object = reflectionProvider.newInstance(this.beanClass);
            ParameterMapping.mappingObject(object, this.getParams());
            if (initEarly && object instanceof Initialisable) {
                ((Initialisable)object).init();
            }
            return (T)object;
        }
        catch (InitialisationException e) {
            logger.error((Object)"instanceo object error:", (Throwable)e);
            throw new ConfigurationException(e);
        }
    }

    public Object clone() {
        BeanObjectEntityConfig<T> entityConfig = this.newObject();
        if (entityConfig == null) {
            return null;
        }
        entityConfig.beanClass = this.beanClass;
        entityConfig.name = this.name;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(this.params);
        return entityConfig;
    }

    @Override
    public int hashCode() {
        int hashcode = 37;
        hashcode += this.name == null ? 0 : this.name.hashCode();
        hashcode += this.beanClass == null ? 0 : this.beanClass.hashCode();
        return hashcode += this.params == null ? 0 : this.params.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof BeanObjectEntityConfig) {
            BeanObjectEntityConfig entity = (BeanObjectEntityConfig)object;
            boolean isEquals = StringUtils.equals((String)this.name, (String)entity.name);
            isEquals = isEquals && this.beanClass == entity.getBeanClass();
            isEquals = isEquals && ObjectUtil.equals(this.params, entity.params);
            return isEquals;
        }
        return false;
    }
}

