/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.InvalidSdkException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;

public class AndroidSdk {
    private static final String SOURCE_PROPERTIES_FILENAME = "source.properties";
    private static final String PLATFORM_VERSION_PROPERTY = "Platform.Version";
    private static final String API_LEVEL_PROPERTY = "AndroidVersion.ApiLevel";
    private static final String SDK_TOOLS_REVISION_PROPERTY = "Pkg.Revision";
    private static final String PLATFORMS_FOLDER_NAME = "platforms";
    private static final String PLATFORM_TOOLS_FOLDER_NAME = "platform-tools";
    private static final String PARAMETER_MESSAGE = "Please provide a proper Android SDK directory path as configuration parameter <sdk><path>...</path></sdk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.sdk.path=... or set environment variable ANDROID_HOME.";
    private final File sdkPath;
    private final Platform platform;
    private int sdkMajorVersion;
    private Set<Platform> availablePlatforms;

    public AndroidSdk(File sdkPath, String platformOrApiLevel) {
        this.sdkPath = sdkPath;
        this.findAvailablePlatforms();
        this.loadSDKToolsMajorVersion();
        if (platformOrApiLevel == null) {
            this.platform = null;
        } else {
            this.platform = this.findPlatformByNameOrApiLevel(platformOrApiLevel);
            if (this.platform == null) {
                throw new InvalidSdkException("Invalid SDK: Platform/API level " + platformOrApiLevel + " not available. This command should give you all you need:\n" + sdkPath.getAbsolutePath() + File.separator + "tools" + File.separator + "android update sdk --no-ui --obsolete --force");
            }
        }
    }

    private Platform findPlatformByNameOrApiLevel(String platformOrApiLevel) {
        for (Platform p : this.availablePlatforms) {
            if (!p.name.equals(platformOrApiLevel) && !p.apiLevel.equals(platformOrApiLevel)) continue;
            return p;
        }
        return null;
    }

    public Layout getLayout() {
        this.assertPathIsDirectory(this.sdkPath);
        File platformTools = new File(this.sdkPath, PLATFORM_TOOLS_FOLDER_NAME);
        if (platformTools.exists() && platformTools.isDirectory()) {
            return Layout.LAYOUT_2_3;
        }
        File platforms = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        if (platforms.exists() && platforms.isDirectory()) {
            return Layout.LAYOUT_1_5;
        }
        throw new InvalidSdkException("Android SDK could not be identified from path \"" + this.sdkPath + "\". " + PARAMETER_MESSAGE);
    }

    private void assertPathIsDirectory(File path) {
        if (path == null) {
            throw new InvalidSdkException(PARAMETER_MESSAGE);
        }
        if (!path.isDirectory()) {
            throw new InvalidSdkException("Path \"" + path + "\" is not a directory. " + PARAMETER_MESSAGE);
        }
    }

    public String getPathForTool(String tool) {
        String[] possiblePaths;
        String[] stringArray = possiblePaths = new String[]{this.sdkPath + "/" + PLATFORM_TOOLS_FOLDER_NAME + "/" + tool, this.sdkPath + "/" + PLATFORM_TOOLS_FOLDER_NAME + "/" + tool + ".exe", this.sdkPath + "/" + PLATFORM_TOOLS_FOLDER_NAME + "/" + tool + ".bat", this.sdkPath + "/" + PLATFORM_TOOLS_FOLDER_NAME + "/lib/" + tool, this.getPlatform() + "/tools/" + tool, this.getPlatform() + "/tools/" + tool + ".exe", this.getPlatform() + "/tools/" + tool + ".bat", this.getPlatform() + "/tools/lib/" + tool, this.sdkPath + "/tools/" + tool, this.sdkPath + "/tools/" + tool + ".exe", this.sdkPath + "/tools/" + tool + ".bat", this.sdkPath + "/tools/lib/" + tool};
        int n = possiblePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String possiblePath = stringArray[n2];
            File file = new File(possiblePath);
            if (file.exists() && !file.isDirectory()) {
                return file.getAbsolutePath();
            }
            ++n2;
        }
        throw new InvalidSdkException("Could not find tool '" + tool + "'. " + PARAMETER_MESSAGE);
    }

    public String getAdbPath() {
        return this.getPathForTool("adb");
    }

    public String getZipalignPath() {
        return this.getPathForTool("zipalign");
    }

    public String getPathForFrameworkAidl() {
        Layout layout = this.getLayout();
        switch (layout) {
            case LAYOUT_1_5: 
            case LAYOUT_2_3: {
                return this.getPlatform() + "/framework.aidl";
            }
        }
        throw new InvalidSdkException("Unsupported layout \"" + (Object)((Object)layout) + "\"! " + PARAMETER_MESSAGE);
    }

    public File getAndroidJar() throws MojoExecutionException {
        Layout layout = this.getLayout();
        switch (layout) {
            case LAYOUT_1_5: 
            case LAYOUT_2_3: {
                return new File(this.getPlatform() + "/android.jar");
            }
        }
        throw new MojoExecutionException("Invalid Layout \"" + (Object)((Object)this.getLayout()) + "\"! " + PARAMETER_MESSAGE);
    }

    public File getSDKLibJar() throws MojoExecutionException {
        File sdklib = new File(this.sdkPath + "/tools/lib/sdklib.jar");
        if (sdklib.exists()) {
            return sdklib;
        }
        throw new MojoExecutionException("Can't find the 'sdklib.jar' : " + sdklib.getAbsolutePath());
    }

    public File getSdkPath() throws MojoExecutionException {
        if (this.sdkPath.exists()) {
            return this.sdkPath;
        }
        throw new MojoExecutionException("Can't find the SDK directory : " + this.sdkPath.getAbsolutePath());
    }

    public File getPlatform() {
        Object platformDirectory;
        this.assertPathIsDirectory(this.sdkPath);
        File platformsDirectory = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        this.assertPathIsDirectory(platformsDirectory);
        if (this.platform == null) {
            Object[] platformDirectories = platformsDirectory.listFiles();
            Arrays.sort(platformDirectories);
            platformDirectory = platformDirectories[platformDirectories.length - 1];
        } else {
            platformDirectory = new File(this.platform.path);
        }
        this.assertPathIsDirectory((File)platformDirectory);
        return platformDirectory;
    }

    private void findAvailablePlatforms() {
        this.availablePlatforms = new HashSet<Platform>();
        ArrayList<File> platformDirectories = this.getPlatformDirectories();
        for (File pDir : platformDirectories) {
            File propFile = new File(pDir, SOURCE_PROPERTIES_FILENAME);
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propFile));
            }
            catch (IOException e) {
                throw new InvalidSdkException("Error reading " + propFile.getAbsoluteFile());
            }
            if (!properties.containsKey(PLATFORM_VERSION_PROPERTY) || !properties.containsKey(API_LEVEL_PROPERTY)) continue;
            String platform = properties.getProperty(PLATFORM_VERSION_PROPERTY);
            String apiLevel = properties.getProperty(API_LEVEL_PROPERTY);
            this.availablePlatforms.add(new Platform(platform, apiLevel, pDir.getAbsolutePath()));
        }
    }

    private void loadSDKToolsMajorVersion() {
        File propFile = new File(this.sdkPath, "tools/source.properties");
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propFile));
        }
        catch (IOException e) {
            throw new InvalidSdkException("Error reading " + propFile.getAbsoluteFile());
        }
        if (properties.containsKey(SDK_TOOLS_REVISION_PROPERTY)) {
            try {
                String majorVersion;
                String versionString = properties.getProperty(SDK_TOOLS_REVISION_PROPERTY);
                if (versionString.matches(".*[\\.| ].*")) {
                    String[] versions = versionString.split("[\\.| ]");
                    majorVersion = versions[0];
                } else {
                    majorVersion = versionString;
                }
                this.sdkMajorVersion = Integer.parseInt(majorVersion);
            }
            catch (NumberFormatException e) {
                throw new InvalidSdkException("Error - The property 'Pkg.Revision' in the SDK source.properties file  number is not an Integer: " + properties.getProperty(SDK_TOOLS_REVISION_PROPERTY));
            }
        }
    }

    private ArrayList<File> getPlatformDirectories() {
        File[] platformDirectories;
        ArrayList<File> sourcePropertyFiles = new ArrayList<File>();
        File platformsDirectory = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        this.assertPathIsDirectory(platformsDirectory);
        File[] fileArray = platformDirectories = platformsDirectory.listFiles();
        int n = platformDirectories.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && file.getName().startsWith("android-")) {
                sourcePropertyFiles.add(file);
            }
            ++n2;
        }
        return sourcePropertyFiles;
    }

    public int getSdkMajorVersion() {
        return this.sdkMajorVersion;
    }

    public static enum Layout {
        LAYOUT_1_5,
        LAYOUT_2_3;

    }

    private static final class Platform {
        final String name;
        final String apiLevel;
        final String path;

        public Platform(String name, String apiLevel, String path) {
            this.name = name;
            this.apiLevel = apiLevel;
            this.path = path;
        }
    }
}

