/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.InvalidNdkException;
import java.io.File;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class AndroidNdk {
    public static final String PROPER_NDK_HOME_DIRECTORY_MESSAGE = "Please provide a proper Android NDK directory path as configuration parameter <ndk><path>...</path></ndk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.ndk.path=... or set environment variable ANDROID_NDK_HOME.";
    private static final String[] ARM_TOOLCHAIN = new String[]{"arm-linux-androideabi-4.4.3"};
    private static final String[] X86_TOOLCHAIN = new String[]{"x86-4.4.3"};
    private static final String[] MIPS_TOOLCHAIN = new String[]{"mipsel-linux-android-4.4.3"};
    private final File ndkPath;

    public AndroidNdk(File ndkPath) {
        this.assertPathIsDirectory(ndkPath);
        this.ndkPath = ndkPath;
    }

    private void assertPathIsDirectory(File path) {
        if (path == null) {
            throw new InvalidNdkException(PROPER_NDK_HOME_DIRECTORY_MESSAGE);
        }
        if (!path.isDirectory()) {
            throw new InvalidNdkException("Path \"" + path + "\" is not a directory. " + PROPER_NDK_HOME_DIRECTORY_MESSAGE);
        }
    }

    private File findStripper(String toolchain) {
        if (SystemUtils.IS_OS_LINUX) {
            return new File(this.ndkPath, "toolchains/" + toolchain + "/prebuilt/linux-x86/bin/arm-linux-androideabi-strip");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return new File(this.ndkPath, "toolchains/" + toolchain + "/prebuilt/windows/bin/arm-linux-androideabi-strip.exe");
        }
        if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            return new File(this.ndkPath, "toolchains/" + toolchain + "/prebuilt/darwin-x86/bin/arm-linux-androideabi-strip");
        }
        return null;
    }

    public File getStripper(String toolchain) throws MojoExecutionException {
        File stripper = this.findStripper(toolchain);
        if (stripper == null) {
            throw new MojoExecutionException("Could not resolve stripper for current OS: " + SystemUtils.OS_NAME);
        }
        if (!stripper.exists()) {
            throw new MojoExecutionException("Strip binary " + stripper.getAbsolutePath() + " does not exist, please double check the toolchain and OS used");
        }
        return stripper;
    }

    private String resolveNdkToolchain(String[] toolchains) {
        String[] stringArray = toolchains;
        int n = toolchains.length;
        int n2 = 0;
        while (n2 < n) {
            String toolchain = stringArray[n2];
            File f = this.findStripper(toolchain);
            if (f != null && f.exists()) {
                return toolchain;
            }
            ++n2;
        }
        return null;
    }

    public String getToolchain(File file) throws MojoExecutionException {
        String resolvedNdkToolchain = null;
        String ndkArchitecture = file.getParentFile().getName();
        if ("armeabi".equals(ndkArchitecture) || "armeabi-v7a".equals(ndkArchitecture)) {
            resolvedNdkToolchain = this.resolveNdkToolchain(ARM_TOOLCHAIN);
        } else if ("x86".equals(ndkArchitecture)) {
            resolvedNdkToolchain = this.resolveNdkToolchain(X86_TOOLCHAIN);
        } else if ("mips".equals(ndkArchitecture)) {
            resolvedNdkToolchain = this.resolveNdkToolchain(MIPS_TOOLCHAIN);
        }
        if (resolvedNdkToolchain == null) {
            throw new MojoExecutionException("Can not resolve automatically a toolchain to use. Please specify one.");
        }
        return resolvedNdkToolchain;
    }

    public String getNdkBuildPath() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new File(this.ndkPath, "/ndk-build.cmd").getAbsolutePath();
        }
        return new File(this.ndkPath, "/ndk-build").getAbsolutePath();
    }

    public File getGdbServer(String toolchain) throws MojoExecutionException {
        File gdbServerFile = new File(this.ndkPath, "toolchains/" + toolchain + "/prebuilt/gdbserver");
        if (!gdbServerFile.exists()) {
            throw new MojoExecutionException("gdbserver binary " + gdbServerFile.getAbsolutePath() + " does not exist, please double check the toolchain and OS used");
        }
        return gdbServerFile;
    }
}

