/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.client.BlockInStream;
import tachyon.client.BlockOutStream;
import tachyon.client.EmptyBlockInStream;
import tachyon.client.FileInStream;
import tachyon.client.FileOutStream;
import tachyon.client.InStream;
import tachyon.client.OutStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.WriteType;
import tachyon.conf.UserConf;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.CommonUtils;
import tachyon.worker.DataServerMessage;

public class TachyonFile
implements Comparable<TachyonFile> {
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final UserConf USER_CONF = UserConf.get();
    final TachyonFS TFS;
    final int FID;
    Object mUFSConf = null;

    TachyonFile(TachyonFS tfs, int fid) {
        this.TFS = tfs;
        this.FID = fid;
    }

    @Override
    public int compareTo(TachyonFile o) {
        return this.getPath().compareTo(o.getPath());
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TachyonFile) {
            return this.compareTo((TachyonFile)obj) == 0;
        }
        return false;
    }

    public long getBlockId(int blockIndex) throws IOException {
        return this.TFS.getBlockId(this.FID, blockIndex);
    }

    public long getBlockSizeByte() {
        return this.TFS.getBlockSizeByte(this.FID);
    }

    String getUfsPath() throws IOException {
        return this.TFS.getUfsPath(this.FID);
    }

    public long getCreationTimeMs() {
        return this.TFS.getCreationTimeMs(this.FID);
    }

    public int getDiskReplication() {
        return 3;
    }

    public InStream getInStream(ReadType readType) throws IOException {
        if (readType == null) {
            throw new IOException("ReadType can not be null.");
        }
        if (!this.isComplete()) {
            throw new IOException("The file " + this + " is not complete.");
        }
        List<Long> blocks = this.TFS.getFileBlockIdList(this.FID);
        if (blocks.size() == 0) {
            return new EmptyBlockInStream(this, readType);
        }
        if (blocks.size() == 1) {
            return BlockInStream.get(this, readType, 0, this.mUFSConf);
        }
        return new FileInStream(this, readType, this.mUFSConf);
    }

    public String getLocalFilename(int blockIndex) throws IOException {
        ClientBlockInfo blockInfo = this.TFS.getClientBlockInfo(this.FID, blockIndex);
        return this.TFS.getLocalFilename(blockInfo.getBlockId());
    }

    public List<String> getLocationHosts() throws IOException {
        List<NetAddress> locations = this.TFS.getClientBlockInfo(this.FID, 0).getLocations();
        ArrayList<String> ret = null;
        if (locations != null) {
            ret = new ArrayList<String>(locations.size());
            for (int k = 0; k < locations.size(); ++k) {
                ret.add(locations.get((int)k).mHost);
            }
        }
        return ret;
    }

    public int getNumberOfBlocks() throws IOException {
        return this.TFS.getNumberOfBlocks(this.FID);
    }

    public OutStream getOutStream(WriteType writeType) throws IOException {
        if (writeType == null) {
            throw new IOException("WriteType can not be null.");
        }
        return new FileOutStream(this, writeType, this.mUFSConf);
    }

    public String getPath() {
        return this.TFS.getPath(this.FID);
    }

    public Object getUFSConf() {
        return this.mUFSConf;
    }

    public int hashCode() {
        return this.getPath().hashCode() ^ 0x12D591;
    }

    public boolean isComplete() throws IOException {
        return this.TFS.isComplete(this.FID);
    }

    public boolean isDirectory() {
        return this.TFS.isDirectory(this.FID);
    }

    public boolean isFile() {
        return !this.TFS.isDirectory(this.FID);
    }

    public boolean isInLocalMemory() {
        throw new RuntimeException("Unsupported");
    }

    public boolean isInMemory() throws IOException {
        return this.TFS.isInMemory(this.FID);
    }

    public long length() throws IOException {
        return this.TFS.getFileLength(this.FID);
    }

    public boolean needPin() {
        return this.TFS.isNeedPin(this.FID);
    }

    public TachyonByteBuffer readByteBuffer() throws IOException {
        if (this.TFS.getNumberOfBlocks(this.FID) > 1) {
            throw new IOException("The file has more than one block. This API does not support this.");
        }
        return this.readByteBuffer(0);
    }

    TachyonByteBuffer readByteBuffer(int blockIndex) throws IOException {
        if (!this.isComplete()) {
            return null;
        }
        ClientBlockInfo blockInfo = this.TFS.getClientBlockInfo(this.FID, blockIndex);
        TachyonByteBuffer ret = this.readLocalByteBuffer(blockIndex);
        if (ret == null) {
            ret = this.readRemoteByteBuffer(blockInfo);
        }
        return ret;
    }

    TachyonByteBuffer readLocalByteBuffer(int blockIndex) throws IOException {
        ClientBlockInfo info = this.TFS.getClientBlockInfo(this.FID, blockIndex);
        return this.TFS.readLocalByteBuffer(info.blockId, 0L, info.getLength());
    }

    TachyonByteBuffer readRemoteByteBuffer(ClientBlockInfo blockInfo) {
        ByteBuffer buf = null;
        this.LOG.info((Object)"Try to find and read from remote workers.");
        try {
            List<NetAddress> blockLocations = blockInfo.getLocations();
            this.LOG.info((Object)("readByteBufferFromRemote() " + blockLocations));
            for (int k = 0; k < blockLocations.size(); ++k) {
                String host = blockLocations.get((int)k).mHost;
                int port = blockLocations.get((int)k).mPort;
                if (port == -1) continue;
                if (host.equals(InetAddress.getLocalHost().getHostName()) || host.equals(InetAddress.getLocalHost().getHostAddress())) {
                    String localFileName = CommonUtils.concat(this.TFS.getRootFolder(), this.FID);
                    this.LOG.warn((Object)("Master thinks the local machine has data " + localFileName + "! But not!"));
                    continue;
                }
                this.LOG.info((Object)(host + ":" + (port + 1) + " current host is " + InetAddress.getLocalHost().getHostName() + " " + InetAddress.getLocalHost().getHostAddress()));
                try {
                    buf = this.retrieveByteBufferFromRemoteMachine(new InetSocketAddress(host, port + 1), blockInfo);
                    if (buf == null) continue;
                    break;
                }
                catch (IOException e) {
                    this.LOG.error((Object)e.getMessage());
                    buf = null;
                }
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)("Failed to get read data from remote " + e.getMessage()));
        }
        return buf == null ? null : new TachyonByteBuffer(this.TFS, buf, blockInfo.blockId, -1);
    }

    public boolean recache() throws IOException {
        int numberOfBlocks = this.TFS.getNumberOfBlocks(this.FID);
        if (numberOfBlocks == 0) {
            return true;
        }
        boolean succeed = true;
        for (int k = 0; k < numberOfBlocks; ++k) {
            succeed &= this.recache(k);
        }
        return succeed;
    }

    boolean recache(int blockIndex) throws IOException {
        boolean succeed = true;
        String path = this.TFS.getUfsPath(this.FID);
        UnderFileSystem underFsClient = UnderFileSystem.get(path);
        try {
            int limit;
            InputStream inputStream = underFsClient.open(path);
            long length = this.TFS.getBlockSizeByte(this.FID);
            long offset = (long)blockIndex * length;
            inputStream.skip(offset);
            byte[] buffer = new byte[this.USER_CONF.FILE_BUFFER_BYTES * 4];
            BlockOutStream bos = new BlockOutStream(this, WriteType.TRY_CACHE, blockIndex);
            while (length > 0L && (limit = inputStream.read(buffer)) >= 0) {
                if (limit == 0) continue;
                try {
                    if (length >= (long)limit) {
                        bos.write(buffer, 0, limit);
                        length -= (long)limit;
                        continue;
                    }
                    bos.write(buffer, 0, (int)length);
                    length = 0L;
                }
                catch (IOException e) {
                    this.LOG.warn((Object)e);
                    succeed = false;
                    break;
                }
            }
            if (succeed) {
                bos.close();
            } else {
                bos.cancel();
            }
        }
        catch (IOException e) {
            this.LOG.info((Object)e);
            return false;
        }
        return succeed;
    }

    public boolean rename(String path) throws IOException {
        return this.TFS.rename(this.FID, path);
    }

    private ByteBuffer retrieveByteBufferFromRemoteMachine(InetSocketAddress address, ClientBlockInfo blockInfo) throws IOException {
        int numRead;
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.connect(address);
        this.LOG.info((Object)("Connected to remote machine " + address + " sent"));
        long blockId = blockInfo.blockId;
        DataServerMessage sendMsg = DataServerMessage.createBlockRequestMessage(blockId);
        while (!sendMsg.finishSending()) {
            sendMsg.send(socketChannel);
        }
        this.LOG.info((Object)("Data " + blockId + " to remote machine " + address + " sent"));
        DataServerMessage recvMsg = DataServerMessage.createBlockResponseMessage(false, blockId);
        while (!recvMsg.isMessageReady() && (numRead = recvMsg.recv(socketChannel)) != -1) {
        }
        this.LOG.info((Object)("Data " + blockId + " from remote machine " + address + " received"));
        socketChannel.close();
        if (!recvMsg.isMessageReady()) {
            this.LOG.info((Object)("Data " + blockId + " from remote machine is not ready."));
            return null;
        }
        if (recvMsg.getBlockId() < 0L) {
            this.LOG.info((Object)("Data " + recvMsg.getBlockId() + " is not in remote machine."));
            return null;
        }
        return recvMsg.getReadOnlyData();
    }

    public void setUFSConf(Object conf) {
        this.mUFSConf = conf;
    }

    public String toString() {
        return this.getPath();
    }
}

