/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class MetaAnnotationUtils {
    public static <T extends Annotation> AnnotationDescriptor<T> findAnnotationDescriptor(Class<?> clazz, Class<T> annotationType) {
        return MetaAnnotationUtils.findAnnotationDescriptor(clazz, new HashSet<Annotation>(), annotationType);
    }

    private static <T extends Annotation> AnnotationDescriptor<T> findAnnotationDescriptor(Class<?> clazz, Set<Annotation> visited, Class<T> annotationType) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        if (AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) {
            return new AnnotationDescriptor<T>(clazz, clazz.getAnnotation(annotationType));
        }
        for (Annotation composedAnnotation : clazz.getDeclaredAnnotations()) {
            AnnotationDescriptor<T> descriptor;
            if (AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)composedAnnotation) || !visited.add(composedAnnotation) || (descriptor = MetaAnnotationUtils.findAnnotationDescriptor(composedAnnotation.annotationType(), visited, annotationType)) == null) continue;
            return new AnnotationDescriptor<T>(clazz, descriptor.getDeclaringClass(), composedAnnotation, descriptor.getAnnotation());
        }
        return MetaAnnotationUtils.findAnnotationDescriptor(clazz.getSuperclass(), visited, annotationType);
    }

    public static UntypedAnnotationDescriptor findAnnotationDescriptorForTypes(Class<?> clazz, Class<? extends Annotation> ... annotationTypes) {
        return MetaAnnotationUtils.findAnnotationDescriptorForTypes(clazz, new HashSet<Annotation>(), annotationTypes);
    }

    private static UntypedAnnotationDescriptor findAnnotationDescriptorForTypes(Class<?> clazz, Set<Annotation> visited, Class<? extends Annotation> ... annotationTypes) {
        MetaAnnotationUtils.assertNonEmptyAnnotationTypeArray(annotationTypes, "The list of annotation types must not be empty");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) continue;
            return new UntypedAnnotationDescriptor(clazz, clazz.getAnnotation(annotationType));
        }
        for (Annotation composedAnnotation : clazz.getDeclaredAnnotations()) {
            UntypedAnnotationDescriptor descriptor;
            if (AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)composedAnnotation) || !visited.add(composedAnnotation) || (descriptor = MetaAnnotationUtils.findAnnotationDescriptorForTypes(composedAnnotation.annotationType(), visited, annotationTypes)) == null) continue;
            return new UntypedAnnotationDescriptor(clazz, descriptor.getDeclaringClass(), composedAnnotation, (Annotation)descriptor.getAnnotation());
        }
        return MetaAnnotationUtils.findAnnotationDescriptorForTypes(clazz.getSuperclass(), visited, annotationTypes);
    }

    private static void assertNonEmptyAnnotationTypeArray(Class<?>[] annotationTypes, String message) {
        if (ObjectUtils.isEmpty((Object[])annotationTypes)) {
            throw new IllegalArgumentException(message);
        }
        for (Class<?> clazz : annotationTypes) {
            if (Annotation.class.isAssignableFrom(clazz)) continue;
            throw new IllegalArgumentException("Array elements must be of type Annotation");
        }
    }

    public static class UntypedAnnotationDescriptor
    extends AnnotationDescriptor<Annotation> {
        public UntypedAnnotationDescriptor(Class<?> rootDeclaringClass, Annotation annotation) {
            this(rootDeclaringClass, rootDeclaringClass, (Annotation)null, annotation);
        }

        public UntypedAnnotationDescriptor(Class<?> rootDeclaringClass, Class<?> declaringClass, Annotation composedAnnotation, Annotation annotation) {
            super(rootDeclaringClass, declaringClass, composedAnnotation, annotation);
        }
    }

    public static class AnnotationDescriptor<T extends Annotation> {
        private final Class<?> rootDeclaringClass;
        private final Class<?> declaringClass;
        private final Annotation composedAnnotation;
        private final T annotation;
        private final AnnotationAttributes annotationAttributes;

        public AnnotationDescriptor(Class<?> rootDeclaringClass, T annotation) {
            this(rootDeclaringClass, rootDeclaringClass, null, annotation);
        }

        public AnnotationDescriptor(Class<?> rootDeclaringClass, Class<?> declaringClass, Annotation composedAnnotation, T annotation) {
            Assert.notNull(rootDeclaringClass, (String)"rootDeclaringClass must not be null");
            Assert.notNull(annotation, (String)"annotation must not be null");
            this.rootDeclaringClass = rootDeclaringClass;
            this.declaringClass = declaringClass;
            this.composedAnnotation = composedAnnotation;
            this.annotation = annotation;
            this.annotationAttributes = AnnotatedElementUtils.getAnnotationAttributes(rootDeclaringClass, (String)annotation.annotationType().getName());
        }

        public Class<?> getRootDeclaringClass() {
            return this.rootDeclaringClass;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public Class<? extends Annotation> getAnnotationType() {
            return this.annotation.annotationType();
        }

        public AnnotationAttributes getAnnotationAttributes() {
            return this.annotationAttributes;
        }

        public Annotation getComposedAnnotation() {
            return this.composedAnnotation;
        }

        public Class<? extends Annotation> getComposedAnnotationType() {
            return this.composedAnnotation != null ? this.composedAnnotation.annotationType() : null;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("rootDeclaringClass", this.rootDeclaringClass).append("declaringClass", this.declaringClass).append("composedAnnotation", (Object)this.composedAnnotation).append("annotation", this.annotation).toString();
        }
    }
}

