/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.repository.core.support.TransactionalRepositoryProxyPostProcessor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionalRepositoryFactoryBeanSupport<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements BeanFactoryAware {
    private String transactionManagerName = "transactionManager";
    private RepositoryProxyPostProcessor txPostProcessor;

    public void setTransactionManager(String transactionManager) {
        this.transactionManagerName = transactionManager == null ? "transactionManager" : transactionManager;
    }

    @Override
    protected final RepositoryFactorySupport createRepositoryFactory() {
        RepositoryFactorySupport factory = this.doCreateRepositoryFactory();
        factory.addRepositoryProxyPostProcessor(this.txPostProcessor);
        return factory;
    }

    protected abstract RepositoryFactorySupport doCreateRepositoryFactory();

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.isInstanceOf(ListableBeanFactory.class, (Object)beanFactory);
        this.txPostProcessor = new TransactionalRepositoryProxyPostProcessor((ListableBeanFactory)beanFactory, this.transactionManagerName);
    }
}

