/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import com.rabbitmq.client.Channel;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.listener.ListenerExecutionFailedException;
import org.springframework.amqp.rabbit.listener.MessageRejectedWhileStoppingException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public abstract class AbstractMessageListenerContainer
extends RabbitAccessor
implements BeanNameAware,
DisposableBean,
SmartLifecycle {
    private volatile String beanName;
    private volatile boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private volatile boolean active = false;
    private volatile boolean running = false;
    private final Object lifecycleMonitor = new Object();
    private volatile String[] queueNames;
    private ErrorHandler errorHandler;
    private boolean exposeListenerChannel = true;
    private volatile Object messageListener;
    private volatile AcknowledgeMode acknowledgeMode = AcknowledgeMode.AUTO;
    private boolean initialized;

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public AcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setQueueNames(String ... queueName) {
        this.queueNames = queueName;
    }

    public void setQueues(Queue ... queues) {
        String[] queueNames = new String[queues.length];
        for (int i = 0; i < queues.length; ++i) {
            Assert.notNull((Object)queues[i], (String)"Queue must not be null.");
            queueNames[i] = queues[i].getName();
        }
        this.queueNames = queueNames;
    }

    public String[] getQueueNames() {
        return this.queueNames;
    }

    protected String[] getRequiredQueueNames() {
        Assert.notNull((Object)this.queueNames, (String)"Queue names must not be null.");
        Assert.state((this.queueNames.length > 0 ? 1 : 0) != 0, (String)"Queue names must not be empty.");
        return this.queueNames;
    }

    public boolean isExposeListenerChannel() {
        return this.exposeListenerChannel;
    }

    public void setExposeListenerChannel(boolean exposeListenerChannel) {
        this.exposeListenerChannel = exposeListenerChannel;
    }

    public void setMessageListener(Object messageListener) {
        this.checkMessageListener(messageListener);
        this.messageListener = messageListener;
    }

    protected void checkMessageListener(Object messageListener) {
        if (!(messageListener instanceof MessageListener) && !(messageListener instanceof ChannelAwareMessageListener)) {
            throw new IllegalArgumentException("Message listener needs to be of type [" + MessageListener.class.getName() + "] or [" + ChannelAwareMessageListener.class.getName() + "]");
        }
    }

    public Object getMessageListener() {
        return this.messageListener;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected final String getBeanName() {
        return this.beanName;
    }

    public final void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.state((this.exposeListenerChannel || !this.getAcknowledgeMode().isManual() ? 1 : 0) != 0, (String)"You cannot acknowledge messages manually if the channel is not exposed to the listener (please check your configuration and set exposeListenerChannel=true or acknowledgeMode!=MANUAL)");
        Assert.state((!this.getAcknowledgeMode().isAutoAck() || !this.isChannelTransacted() ? 1 : 0) != 0, (String)"The acknowledgeMode is NONE (autoack in Rabbit terms) which is not consistent with having a transactional channel. Either use a different AcknowledgeMode or make sure channelTransacted=false");
        this.validateConfiguration();
        this.initialize();
    }

    protected void validateConfiguration() {
    }

    public void destroy() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        try {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.lifecycleMonitor.notifyAll();
            }
            this.doInitialize();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.logger.debug((Object)"Shutting down Rabbit listener container");
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.active = false;
            this.lifecycleMonitor.notifyAll();
        }
        try {
            this.doShutdown();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            Object object2 = this.lifecycleMonitor;
            synchronized (object2) {
                this.running = false;
                this.lifecycleMonitor.notifyAll();
            }
        }
    }

    protected abstract void doInitialize() throws Exception;

    protected abstract void doShutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isActive() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.initialized) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (!this.initialized) {
                    this.afterPropertiesSet();
                    this.initialized = true;
                }
            }
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Starting Rabbit listener container.");
            }
            this.doStart();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.active = true;
            this.running = true;
            this.lifecycleMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.running = false;
                this.lifecycleMonitor.notifyAll();
            }
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    protected void invokeErrorHandler(Throwable ex) {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(ex);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Execution of Rabbit message listener failed, and no ErrorHandler has been set.", ex);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Execution of Rabbit message listener failed, and no ErrorHandler has been set: " + ex.getClass() + ": " + ex.getMessage()));
        }
    }

    protected void executeListener(Channel channel, Message message) throws Throwable {
        if (!this.isRunning()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Rejecting received message because the listener container has been stopped: " + message));
            }
            throw new MessageRejectedWhileStoppingException();
        }
        try {
            this.invokeListener(channel, message);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
            throw ex;
        }
    }

    protected void invokeListener(Channel channel, Message message) throws Exception {
        Object listener = this.getMessageListener();
        if (listener instanceof ChannelAwareMessageListener) {
            this.doInvokeListener((ChannelAwareMessageListener)listener, channel, message);
        } else if (listener instanceof MessageListener) {
            this.doInvokeListener((MessageListener)listener, message);
        } else {
            if (listener != null) {
                throw new IllegalArgumentException("Only MessageListener and SessionAwareMessageListener supported: " + listener);
            }
            throw new IllegalStateException("No message listener specified - see property 'messageListener'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeListener(ChannelAwareMessageListener listener, Channel channel, Message message) throws Exception {
        RabbitResourceHolder resourceHolder = null;
        try {
            Channel channelToUse = channel;
            if (!this.isExposeListenerChannel()) {
                resourceHolder = this.getTransactionalResourceHolder();
                channelToUse = resourceHolder.getChannel();
            }
            try {
                listener.onMessage(message, channelToUse);
            }
            catch (Exception e) {
                throw this.wrapToListenerExecutionFailedExceptionIfNeeded(e);
            }
        }
        catch (Throwable throwable) {
            ConnectionFactoryUtils.releaseResources(resourceHolder);
            throw throwable;
        }
        ConnectionFactoryUtils.releaseResources(resourceHolder);
    }

    protected void doInvokeListener(MessageListener listener, Message message) throws Exception {
        try {
            listener.onMessage(message);
        }
        catch (Exception e) {
            throw this.wrapToListenerExecutionFailedExceptionIfNeeded(e);
        }
    }

    protected boolean isChannelLocallyTransacted(Channel channel) {
        return this.isChannelTransacted();
    }

    protected void handleListenerException(Throwable ex) {
        if (this.isActive()) {
            this.invokeErrorHandler(ex);
        } else {
            this.logger.debug((Object)"Listener exception after container shutdown", ex);
        }
    }

    protected Exception wrapToListenerExecutionFailedExceptionIfNeeded(Exception e) {
        if (!(e instanceof ListenerExecutionFailedException)) {
            return new ListenerExecutionFailedException("Listener threw exception", e);
        }
        return e;
    }

    public static class SharedConnectionNotInitializedException
    extends RuntimeException {
        protected SharedConnectionNotInitializedException(String msg) {
            super(msg);
        }
    }
}

