/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.math.MathContext;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import spire.algebra.IsReal;
import spire.algebra.Trig;
import spire.math.Complex;
import spire.math.Complex$mcD$sp;
import spire.math.Complex$mcF$sp;
import spire.math.ComplexAlgebra;
import spire.math.ComplexEq;
import spire.math.ComplexInstances;
import spire.math.ComplexInstances$class;
import spire.math.Fractional;
import spire.math.Fractional$;
import spire.std.package$bigDecimal$;
import spire.std.package$double$;
import spire.std.package$float$;

public final class Complex$
implements ComplexInstances,
Serializable {
    public static final Complex$ MODULE$;

    static {
        new Complex$();
    }

    @Override
    public <A> ComplexAlgebra<A> ComplexAlgebra(Fractional<A> evidence$1, Trig<A> evidence$2, IsReal<A> evidence$3) {
        return ComplexInstances$class.ComplexAlgebra(this, evidence$1, evidence$2, evidence$3);
    }

    @Override
    public ComplexAlgebra<Object> ComplexAlgebra$mDc$sp(Fractional<Object> evidence$1, Trig<Object> evidence$2, IsReal<Object> evidence$3) {
        return ComplexInstances$class.ComplexAlgebra$mDc$sp(this, evidence$1, evidence$2, evidence$3);
    }

    @Override
    public ComplexAlgebra<Object> ComplexAlgebra$mFc$sp(Fractional<Object> evidence$1, Trig<Object> evidence$2, IsReal<Object> evidence$3) {
        return ComplexInstances$class.ComplexAlgebra$mFc$sp(this, evidence$1, evidence$2, evidence$3);
    }

    @Override
    public <A> ComplexEq<A> ComplexEq() {
        return ComplexInstances$class.ComplexEq(this);
    }

    public <T> Complex<T> i(Fractional<T> f, Trig<T> t, IsReal<T> r) {
        return new Complex(f.zero(), f.one(), f, t, f);
    }

    public <T> Complex<T> one(Fractional<T> f, Trig<T> t, IsReal<T> r) {
        return new Complex(f.one(), f.zero(), f, t, f);
    }

    public <T> Complex<T> zero(Fractional<T> f, Trig<T> t, IsReal<T> r) {
        return new Complex(f.zero(), f.zero(), f, t, f);
    }

    public <T> Complex<T> fromInt(int n, Fractional<T> f, Trig<T> t, IsReal<T> r) {
        return new Complex(f.fromInt(n), f.zero(), f, t, f);
    }

    public Complex<Object> intToComplex(int n) {
        return new Complex$mcD$sp(n, 0.0, Fractional$.MODULE$.DoubleIsFractional(), package$double$.MODULE$.DoubleAlgebra(), package$double$.MODULE$.DoubleAlgebra());
    }

    public Complex<Object> longToComplex(long n) {
        return new Complex$mcD$sp(n, 0.0, Fractional$.MODULE$.DoubleIsFractional(), package$double$.MODULE$.DoubleAlgebra(), package$double$.MODULE$.DoubleAlgebra());
    }

    public Complex<Object> floatToComplex(float n) {
        return new Complex$mcF$sp(n, 0.0f, Fractional$.MODULE$.FloatIsFractional(), package$float$.MODULE$.FloatAlgebra(), package$float$.MODULE$.FloatAlgebra());
    }

    public Complex<Object> doubleToComplex(double n) {
        return new Complex$mcD$sp(n, 0.0, Fractional$.MODULE$.DoubleIsFractional(), package$double$.MODULE$.DoubleAlgebra(), package$double$.MODULE$.DoubleAlgebra());
    }

    public Complex<BigDecimal> bigIntToComplex(BigInt n) {
        return this.bigDecimalToComplex(package$.MODULE$.BigDecimal().apply(n));
    }

    public Complex<BigDecimal> bigDecimalToComplex(BigDecimal n) {
        MathContext mc = n.mc();
        return new Complex<BigDecimal>(n, package$.MODULE$.BigDecimal().apply(0), Fractional$.MODULE$.BigDecimalIsFractional(), package$bigDecimal$.MODULE$.BigDecimalIsTrig(mc), package$bigDecimal$.MODULE$.BigDecimalAlgebra());
    }

    public <T> Complex<T> polar(T magnitude, T angle, Fractional<T> f, Trig<T> t, IsReal<T> r) {
        return new Complex<T>(f.times(magnitude, t.cos(angle)), f.times(magnitude, t.sin(angle)), f, t, f);
    }

    public <T> Complex<T> apply(T real, Fractional<T> f, Trig<T> t, IsReal<T> r) {
        return new Complex<T>(real, f.zero(), f, t, f);
    }

    public <T> Complex<T> rootOfUnity(int n, int x, Fractional<T> f, Trig<T> t, IsReal<T> r) {
        if (x == 0) {
            return this.one(f, t, f);
        }
        if (n % 2 == 0) {
            if (x == n / 2) {
                return this.one(f, t, f).unary_$minus();
            }
            if (n % 4 == 0) {
                if (x == n / 4) {
                    return this.i(f, t, f);
                }
                if (x == n * 3 / 4) {
                    return this.i(f, t, f).unary_$minus();
                }
            }
        }
        return this.polar(f.one(), f.div(f.times(f.times(t.pi(), f.fromInt(2)), f.fromInt(x)), f.fromInt(n)), f, t, f);
    }

    public <T> Complex<T>[] rootsOfUnity(int n, Fractional<T> f, Trig<T> t, IsReal<T> r) {
        Complex<T> sum2;
        Complex[] roots = new Complex[n];
        roots[0] = sum2 = this.one(f, t, f);
        int west = n % 2 == 0 ? n / 2 : -1;
        int north = n % 4 == 0 ? n / 4 : -1;
        int south = n % 4 == 0 ? 3 * n / 4 : -1;
        int last = n - 1;
        for (int x = 1; x < last; ++x) {
            Complex<Object> complex2 = north == x ? this.i(f, t, f) : (west == x ? this.one(f, t, f).unary_$minus() : (south == x ? this.i(f, t, f).unary_$minus() : this.polar(f.one(), f.div(f.times(f.times(t.pi(), f.fromInt(2)), f.fromInt(x)), f.fromInt(n)), f, t, f)));
            roots[x] = complex2;
            sum2 = sum2.$plus(complex2);
        }
        roots[last] = this.zero(f, t, f).$minus(sum2);
        return roots;
    }

    public <T> Complex<T> apply(T real, T imag, Fractional<T> f, Trig<T> t, IsReal<T> r) {
        return new Complex<T>(real, imag, f, t, r);
    }

    public <T> Option<Tuple2<T, T>> unapply(Complex<T> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.real(), x$0.imag()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public Complex<Object> i$mDc$sp(Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcD$sp(f.zero$mcD$sp(), f.one$mcD$sp(), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> i$mFc$sp(Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcF$sp(f.zero$mcF$sp(), f.one$mcF$sp(), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> one$mDc$sp(Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcD$sp(f.one$mcD$sp(), f.zero$mcD$sp(), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> one$mFc$sp(Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcF$sp(f.one$mcF$sp(), f.zero$mcF$sp(), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> zero$mDc$sp(Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcD$sp(f.zero$mcD$sp(), f.zero$mcD$sp(), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> zero$mFc$sp(Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcF$sp(f.zero$mcF$sp(), f.zero$mcF$sp(), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> fromInt$mDc$sp(int n, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcD$sp(f.fromInt$mcD$sp(n), f.zero$mcD$sp(), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> fromInt$mFc$sp(int n, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcF$sp(f.fromInt$mcF$sp(n), f.zero$mcF$sp(), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> polar$mDc$sp(double magnitude, double angle, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcD$sp(f.times$mcD$sp(magnitude, t.cos$mcD$sp(angle)), f.times$mcD$sp(magnitude, t.sin$mcD$sp(angle)), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> polar$mFc$sp(float magnitude, float angle, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcF$sp(f.times$mcF$sp(magnitude, t.cos$mcF$sp(angle)), f.times$mcF$sp(magnitude, t.sin$mcF$sp(angle)), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> apply$mDc$sp(double real, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcD$sp(real, f.zero$mcD$sp(), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> apply$mFc$sp(float real, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcF$sp(real, f.zero$mcF$sp(), f, t, (IsReal<Object>)f);
    }

    public Complex<Object> rootOfUnity$mDc$sp(int n, int x, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        if (x == 0) {
            return this.one$mDc$sp(f, t, f);
        }
        if (n % 2 == 0) {
            if (x == n / 2) {
                return this.one$mDc$sp(f, t, f).unary_$minus$mcD$sp();
            }
            if (n % 4 == 0) {
                if (x == n / 4) {
                    return this.i$mDc$sp(f, t, f);
                }
                if (x == n * 3 / 4) {
                    return this.i$mDc$sp(f, t, f).unary_$minus$mcD$sp();
                }
            }
        }
        return this.polar$mDc$sp(f.one$mcD$sp(), f.div$mcD$sp(f.times$mcD$sp(f.times$mcD$sp(t.pi$mcD$sp(), f.fromInt$mcD$sp(2)), f.fromInt$mcD$sp(x)), f.fromInt$mcD$sp(n)), f, t, f);
    }

    public Complex<Object> rootOfUnity$mFc$sp(int n, int x, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        if (x == 0) {
            return this.one$mFc$sp(f, t, f);
        }
        if (n % 2 == 0) {
            if (x == n / 2) {
                return this.one$mFc$sp(f, t, f).unary_$minus$mcF$sp();
            }
            if (n % 4 == 0) {
                if (x == n / 4) {
                    return this.i$mFc$sp(f, t, f);
                }
                if (x == n * 3 / 4) {
                    return this.i$mFc$sp(f, t, f).unary_$minus$mcF$sp();
                }
            }
        }
        return this.polar$mFc$sp(f.one$mcF$sp(), f.div$mcF$sp(f.times$mcF$sp(f.times$mcF$sp(t.pi$mcF$sp(), f.fromInt$mcF$sp(2)), f.fromInt$mcF$sp(x)), f.fromInt$mcF$sp(n)), f, t, f);
    }

    public Complex<Object>[] rootsOfUnity$mDc$sp(int n, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        Complex<Object> sum2;
        Complex[] roots = new Complex[n];
        roots[0] = sum2 = this.one$mDc$sp(f, t, f);
        int west = n % 2 == 0 ? n / 2 : -1;
        int north = n % 4 == 0 ? n / 4 : -1;
        int south = n % 4 == 0 ? 3 * n / 4 : -1;
        int last = n - 1;
        for (int x = 1; x < last; ++x) {
            Complex<Object> complex2 = north == x ? this.i$mDc$sp(f, t, f) : (west == x ? this.one$mDc$sp(f, t, f).unary_$minus$mcD$sp() : (south == x ? this.i$mDc$sp(f, t, f).unary_$minus$mcD$sp() : this.polar$mDc$sp(f.one$mcD$sp(), f.div$mcD$sp(f.times$mcD$sp(f.times$mcD$sp(t.pi$mcD$sp(), f.fromInt$mcD$sp(2)), f.fromInt$mcD$sp(x)), f.fromInt$mcD$sp(n)), f, t, f)));
            roots[x] = complex2;
            sum2 = sum2.$plus$mcD$sp(complex2);
        }
        roots[last] = this.zero$mDc$sp(f, t, f).$minus$mcD$sp(sum2);
        return roots;
    }

    public Complex<Object>[] rootsOfUnity$mFc$sp(int n, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        Complex<Object> sum2;
        Complex[] roots = new Complex[n];
        roots[0] = sum2 = this.one$mFc$sp(f, t, f);
        int west = n % 2 == 0 ? n / 2 : -1;
        int north = n % 4 == 0 ? n / 4 : -1;
        int south = n % 4 == 0 ? 3 * n / 4 : -1;
        int last = n - 1;
        for (int x = 1; x < last; ++x) {
            Complex<Object> complex2 = north == x ? this.i$mFc$sp(f, t, f) : (west == x ? this.one$mFc$sp(f, t, f).unary_$minus$mcF$sp() : (south == x ? this.i$mFc$sp(f, t, f).unary_$minus$mcF$sp() : this.polar$mFc$sp(f.one$mcF$sp(), f.div$mcF$sp(f.times$mcF$sp(f.times$mcF$sp(t.pi$mcF$sp(), f.fromInt$mcF$sp(2)), f.fromInt$mcF$sp(x)), f.fromInt$mcF$sp(n)), f, t, f)));
            roots[x] = complex2;
            sum2 = sum2.$plus$mcF$sp(complex2);
        }
        roots[last] = this.zero$mFc$sp(f, t, f).$minus$mcF$sp(sum2);
        return roots;
    }

    public Complex<Object> apply$mDc$sp(double real, double imag, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcD$sp(real, imag, f, t, r);
    }

    public Complex<Object> apply$mFc$sp(float real, float imag, Fractional<Object> f, Trig<Object> t, IsReal<Object> r) {
        return new Complex$mcF$sp(real, imag, f, t, r);
    }

    public Option<Tuple2<Object, Object>> unapply$mDc$sp(Complex<Object> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2.mcDD.sp(x$0.real$mcD$sp(), x$0.imag$mcD$sp()));
    }

    public Option<Tuple2<Object, Object>> unapply$mFc$sp(Complex<Object> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToFloat((float)x$0.real$mcF$sp()), (Object)BoxesRunTime.boxToFloat((float)x$0.imag$mcF$sp())));
    }

    private Complex$() {
        MODULE$ = this;
        ComplexInstances$class.$init$(this);
    }
}

