/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.scalatest.tools.maven.AbstractScalaTestMojo;
import org.scalatest.tools.maven.MojoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReporterMojo
extends AbstractScalaTestMojo
implements MavenReport {
    private File reportingOutputDirectory;
    private String fileReporterOptions;

    public void execute() throws MojoExecutionException, MojoFailureException {
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            this.runScalaTest(this.configuration());
        }
        catch (MojoFailureException e) {
            throw new MavenReportException("Failure executing ScalaTest", (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            throw new MavenReportException("Failure executing ScalaTest", (Exception)e);
        }
        try {
            sink.head();
            sink.title();
            sink.text(this.getLocalizedString(locale, "reporter.mojo.outputTitle"));
            sink.title_();
            sink.head_();
            sink.body();
            sink.sectionTitle1();
            sink.text(this.getLocalizedString(locale, "reporter.mojo.outputTitle"));
            sink.sectionTitle1_();
            sink.verbatim(false);
            sink.text(this.getScalaTestOutputFromFile());
            sink.verbatim_();
            sink.body_();
            sink.flush();
            sink.close();
        }
        catch (IOException ioe) {
            throw new MavenReportException("Failure generating ScalaTest report", (Exception)ioe);
        }
    }

    private String[] configuration() {
        return MojoUtils.concat(this.sharedConfiguration(), this.fileReporterConfig());
    }

    private List<String> fileReporterConfig() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (this.fileReporterOptions != null) {
            return MojoUtils.reporterArg("-f", this.fileReporterOptions + " tempScalaTestOutput.txt", MojoUtils.fileRelativeTo(tmpDir));
        }
        return MojoUtils.reporterArg("-f", "tempScalaTestOutput.txt", MojoUtils.fileRelativeTo(tmpDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getScalaTestOutputFromFile() throws IOException {
        StringWriter fileContents = new StringWriter(1024);
        PrintWriter writer = new PrintWriter((Writer)fileContents, true);
        File outputFile = new File(System.getProperty("java.io.tmpdir"), "tempScalaTestOutput.txt");
        BufferedReader reader = new BufferedReader(new FileReader(outputFile));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
            String string = fileContents.toString();
            return string;
        }
        finally {
            try {
                reader.close();
                outputFile.delete();
            }
            catch (IOException ignored) {}
        }
    }

    public String getOutputName() {
        return "scalatest-output";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getName(Locale locale) {
        return this.getLocalizedString(locale, "reporter.mojo.name");
    }

    public String getDescription(Locale locale) {
        return this.getLocalizedString(locale, "reporter.mojo.description");
    }

    public void setReportOutputDirectory(File outputDirectory) {
        this.reportingOutputDirectory = outputDirectory;
    }

    public File getReportOutputDirectory() {
        return this.reportingOutputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private String getLocalizedString(Locale locale, String resourceKey) {
        return ResourceBundle.getBundle("mojoResources", locale, ((Object)((Object)this)).getClass().getClassLoader()).getString(resourceKey);
    }
}

