/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt.bro.ptr;

import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public final class MachineSizedUIntPtr
extends Struct<MachineSizedUIntPtr> {
    @StructMember(value=0)
    @MachineSizedUInt
    public native long get();

    @StructMember(value=0)
    public native void set(@MachineSizedUInt long var1);

    public IntBuffer asIntBuffer(int n) {
        if (this._sizeOf() != 4) {
            throw new IllegalStateException("Not a 32-bit platform");
        }
        return VM.newDirectByteBuffer(this.getHandle(), n << 2).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public LongBuffer asLongBuffer(int n) {
        if (this._sizeOf() != 8) {
            throw new IllegalStateException("Not a 64-bit platform");
        }
        return VM.newDirectByteBuffer(this.getHandle(), n << 3).order(ByteOrder.nativeOrder()).asLongBuffer();
    }

    public int[] toIntArray(int n) {
        int[] result = new int[n];
        this.get(result);
        return result;
    }

    public void get(int[] dst) {
        this.get(dst, 0, dst.length);
    }

    public void get(int[] dst, int offset, int count) {
        if (this._sizeOf() == 4) {
            this.asIntBuffer(count).get(dst, offset, count);
        } else {
            Arrays.checkOffsetAndCount(dst.length, offset, count);
            LongBuffer buf = this.asLongBuffer(count);
            for (int i = 0; i < count; ++i) {
                dst[i + offset] = (int)buf.get();
            }
        }
    }

    public void set(int[] src) {
        this.set(src, 0, src.length);
    }

    public void set(int[] src, int offset, int count) {
        if (this._sizeOf() == 4) {
            this.asIntBuffer(count).put(src, offset, count);
        } else {
            Arrays.checkOffsetAndCount(src.length, offset, count);
            LongBuffer buf = this.asLongBuffer(count);
            for (int i = 0; i < count; ++i) {
                buf.put((long)src[i + offset] & 0xFFFFFFFFL);
            }
        }
    }

    public long[] toLongArray(int n) {
        long[] result = new long[n];
        this.get(result);
        return result;
    }

    public void get(long[] dst) {
        this.get(dst, 0, dst.length);
    }

    public void get(long[] dst, int offset, int count) {
        if (this._sizeOf() == 8) {
            this.asLongBuffer(count).get(dst, offset, count);
        } else {
            Arrays.checkOffsetAndCount(dst.length, offset, count);
            IntBuffer buf = this.asIntBuffer(count);
            for (int i = 0; i < count; ++i) {
                dst[i + offset] = (long)buf.get() & 0xFFFFFFFFL;
            }
        }
    }

    public void set(long[] src) {
        this.set(src, 0, src.length);
    }

    public void set(long[] src, int offset, int count) {
        if (this._sizeOf() == 8) {
            this.asLongBuffer(count).put(src, offset, count);
        } else {
            Arrays.checkOffsetAndCount(src.length, offset, count);
            IntBuffer buf = this.asIntBuffer(count);
            for (int i = 0; i < count; ++i) {
                buf.put((int)src[i + offset]);
            }
        }
    }

    public static class MachineSizedUIntPtrPtr
    extends Ptr<MachineSizedUIntPtr, MachineSizedUIntPtrPtr> {
    }
}

