/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt.bro.ptr;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public final class BytePtr
extends Struct<BytePtr> {
    public BytePtr() {
    }

    public BytePtr(byte value) {
        this.set(value);
    }

    @StructMember(value=0)
    public native byte get();

    @StructMember(value=0)
    public native void set(byte var1);

    public String toStringAsciiZ() {
        int length = 0;
        byte b = 0;
        long address = this.getHandle();
        while ((b = VM.getByte(address++)) != 0) {
            ++length;
        }
        StringBuilder sb = new StringBuilder(length);
        address = this.getHandle();
        while ((b = VM.getByte(address++)) != 0) {
            if (b < 128) {
                sb.append((char)b);
                continue;
            }
            sb.append('?');
        }
        return sb.toString();
    }

    public String toStringZ() {
        return this.toStringZ(Charset.defaultCharset());
    }

    public String toStringZ(Charset charset) {
        int length = 0;
        long address = this.getHandle();
        while (VM.getByte(address++) != 0) {
            ++length;
        }
        return charset.decode(this.asByteBuffer(length)).toString();
    }

    public ByteBuffer asByteBuffer(int n) {
        return VM.newDirectByteBuffer(this.getHandle(), n);
    }

    public byte[] toByteArray(int n) {
        byte[] result = new byte[n];
        this.get(result);
        return result;
    }

    public void get(byte[] dst) {
        this.get(dst, 0, dst.length);
    }

    public void get(byte[] dst, int offset, int count) {
        this.asByteBuffer(count).get(dst, offset, count);
    }

    public void set(byte[] src) {
        this.set(src, 0, src.length);
    }

    public void set(byte[] src, int offset, int count) {
        this.asByteBuffer(count).put(src, offset, count);
    }

    public static BytePtr toBytePtrAsciiZ(String s) {
        return BytePtr.toBytePtrAsciiZ(s, false);
    }

    public static BytePtr toBytePtrAsciiZ(String s, boolean useNativeHeap) {
        long handle;
        int length = s.length();
        long address = handle = useNativeHeap ? VM.malloc(length + 1) : VM.allocateMemoryAtomic(length + 1);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                VM.setByte(address, (byte)c);
            } else {
                VM.setByte(address, (byte)63);
            }
            ++address;
        }
        return Struct.toStruct(BytePtr.class, handle);
    }

    public static BytePtr toBytePtrZ(String s) {
        return BytePtr.toBytePtrZ(s, Charset.defaultCharset(), false);
    }

    public static BytePtr toBytePtrZ(String s, Charset charset) {
        return BytePtr.toBytePtrZ(s, charset, false);
    }

    public static BytePtr toBytePtrZ(String s, Charset charset, boolean useNativeHeap) {
        byte[] bytes = s.getBytes(charset);
        int length = bytes.length;
        long handle = useNativeHeap ? VM.malloc(length + 1) : VM.allocateMemoryAtomic(length + 1);
        VM.memcpy(handle, VM.getArrayValuesAddress(bytes), length);
        return Struct.toStruct(BytePtr.class, handle);
    }

    public static class BytePtrPtr
    extends Ptr<BytePtr, BytePtrPtr> {
    }
}

