/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt.bro;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.robovm.rt.VM;
import org.robovm.rt.bro.annotation.MarshalsArray;
import org.robovm.rt.bro.annotation.MarshalsPointer;

public class BufferMarshalers {

    public static class BufferMarshaler {
        private static final int EFFECTIVE_DIRECT_ADDRESS_OFFSET;
        private static final int _ELEMENT_SIZE_SHIFT_OFFSET;

        @MarshalsPointer(supportedCallTypes={0L})
        public static long toNative(Buffer buffer, long flags) {
            if (buffer == null) {
                return 0L;
            }
            if (!buffer.isDirect() && !buffer.hasArray()) {
                throw new IllegalArgumentException("Only direct and array-backed java.nio.Buffers can be marshaled to pointers.");
            }
            if (buffer.isDirect()) {
                return VM.getLong(VM.getObjectAddress(buffer) + (long)EFFECTIVE_DIRECT_ADDRESS_OFFSET);
            }
            Object array = buffer.array();
            int offset = buffer.arrayOffset();
            int shift = VM.getInt(VM.getObjectAddress(buffer) + (long)_ELEMENT_SIZE_SHIFT_OFFSET);
            return VM.getArrayValuesAddress(array) + (long)(offset << shift);
        }

        private static void copyBuffer(Buffer buffer, long handle, long flags, int d1) {
            if (d1 != buffer.capacity()) {
                Class cls = null;
                if (buffer instanceof ByteBuffer) {
                    cls = ByteBuffer.class;
                } else if (buffer instanceof ShortBuffer) {
                    cls = ShortBuffer.class;
                } else if (buffer instanceof CharBuffer) {
                    cls = CharBuffer.class;
                } else if (buffer instanceof IntBuffer) {
                    cls = IntBuffer.class;
                } else if (buffer instanceof LongBuffer) {
                    cls = LongBuffer.class;
                } else if (buffer instanceof FloatBuffer) {
                    cls = FloatBuffer.class;
                } else if (buffer instanceof DoubleBuffer) {
                    cls = DoubleBuffer.class;
                }
                throw new IllegalArgumentException("Expected " + cls.getName() + " of capacity " + d1 + ". Got " + cls.getName() + " of capacity " + buffer.capacity());
            }
            long src = 0L;
            Object array = null;
            int offset = 0;
            int shift = VM.getInt(VM.getObjectAddress(buffer) + (long)_ELEMENT_SIZE_SHIFT_OFFSET);
            if (buffer.isDirect()) {
                src = VM.getLong(VM.getObjectAddress(buffer) + (long)EFFECTIVE_DIRECT_ADDRESS_OFFSET);
            } else {
                if (buffer.hasArray()) {
                    array = buffer.array();
                    offset = buffer.arrayOffset();
                } else {
                    int pos = buffer.position();
                    int limit = buffer.limit();
                    buffer.position(0);
                    buffer.limit(buffer.capacity());
                    if (buffer instanceof ByteBuffer) {
                        array = new byte[d1];
                        ((ByteBuffer)buffer).get((byte[])array);
                    } else if (buffer instanceof ShortBuffer) {
                        array = new short[d1];
                        ((ShortBuffer)buffer).get((short[])array);
                    } else if (buffer instanceof CharBuffer) {
                        array = new char[d1];
                        ((CharBuffer)buffer).get((char[])array);
                    } else if (buffer instanceof IntBuffer) {
                        array = new int[d1];
                        ((IntBuffer)buffer).get((int[])array);
                    } else if (buffer instanceof LongBuffer) {
                        array = new long[d1];
                        ((LongBuffer)buffer).get((long[])array);
                    } else if (buffer instanceof FloatBuffer) {
                        array = new float[d1];
                        ((FloatBuffer)buffer).get((float[])array);
                    } else if (buffer instanceof DoubleBuffer) {
                        array = new double[d1];
                        ((DoubleBuffer)buffer).get((double[])array);
                    }
                    buffer.position(pos);
                    buffer.limit(limit);
                }
                src = VM.getArrayValuesAddress(array);
            }
            VM.memcpy(handle, src + (long)(offset << shift), d1 << shift);
        }

        @MarshalsArray
        public static ByteBuffer toByteBuffer(Class<?> cls, long handle, long flags, int d1) {
            return VM.newDirectByteBuffer(handle, d1);
        }

        @MarshalsArray
        public static void toNative(ByteBuffer buffer, long handle, long flags, int d1) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1);
        }

        @MarshalsArray
        public static ByteBuffer toByteBuffer(Class<?> cls, long handle, long flags, int d1, int d2) {
            return BufferMarshaler.toByteBuffer(cls, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static void toNative(ByteBuffer buffer, long handle, long flags, int d1, int d2) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static ByteBuffer toByteBuffer(Class<?> cls, long handle, long flags, int d1, int d2, int d3) {
            return BufferMarshaler.toByteBuffer(cls, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static void toNative(ByteBuffer buffer, long handle, long flags, int d1, int d2, int d3) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static ShortBuffer toShortBuffer(Class<?> cls, long handle, long flags, int d1) {
            return VM.newDirectByteBuffer(handle, d1 << 1).order(ByteOrder.nativeOrder()).asShortBuffer();
        }

        @MarshalsArray
        public static void toNative(ShortBuffer buffer, long handle, long flags, int d1) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1);
        }

        @MarshalsArray
        public static ShortBuffer toShortBuffer(Class<?> cls, long handle, long flags, int d1, int d2) {
            return BufferMarshaler.toShortBuffer(cls, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static void toNative(ShortBuffer buffer, long handle, long flags, int d1, int d2) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static ShortBuffer toShortBuffer(Class<?> cls, long handle, long flags, int d1, int d2, int d3) {
            return BufferMarshaler.toShortBuffer(cls, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static void toNative(ShortBuffer buffer, long handle, long flags, int d1, int d2, int d3) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static CharBuffer toCharBuffer(Class<?> cls, long handle, long flags, int d1) {
            return VM.newDirectByteBuffer(handle, d1 << 1).order(ByteOrder.nativeOrder()).asCharBuffer();
        }

        @MarshalsArray
        public static void toNative(CharBuffer buffer, long handle, long flags, int d1) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1);
        }

        @MarshalsArray
        public static CharBuffer toCharBuffer(Class<?> cls, long handle, long flags, int d1, int d2) {
            return BufferMarshaler.toCharBuffer(cls, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static void toNative(CharBuffer buffer, long handle, long flags, int d1, int d2) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static CharBuffer toCharBuffer(Class<?> cls, long handle, long flags, int d1, int d2, int d3) {
            return BufferMarshaler.toCharBuffer(cls, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static void toNative(CharBuffer buffer, long handle, long flags, int d1, int d2, int d3) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static IntBuffer toIntBuffer(Class<?> cls, long handle, long flags, int d1) {
            return VM.newDirectByteBuffer(handle, d1 << 2).order(ByteOrder.nativeOrder()).asIntBuffer();
        }

        @MarshalsArray
        public static void toNative(IntBuffer buffer, long handle, long flags, int d1) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1);
        }

        @MarshalsArray
        public static IntBuffer toIntBuffer(Class<?> cls, long handle, long flags, int d1, int d2) {
            return BufferMarshaler.toIntBuffer(cls, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static void toNative(IntBuffer buffer, long handle, long flags, int d1, int d2) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static IntBuffer toIntBuffer(Class<?> cls, long handle, long flags, int d1, int d2, int d3) {
            return BufferMarshaler.toIntBuffer(cls, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static void toNative(IntBuffer buffer, long handle, long flags, int d1, int d2, int d3) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static LongBuffer toLongBuffer(Class<?> cls, long handle, long flags, int d1) {
            return VM.newDirectByteBuffer(handle, d1 << 3).order(ByteOrder.nativeOrder()).asLongBuffer();
        }

        @MarshalsArray
        public static void toNative(LongBuffer buffer, long handle, long flags, int d1) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1);
        }

        @MarshalsArray
        public static LongBuffer toLongBuffer(Class<?> cls, long handle, long flags, int d1, int d2) {
            return BufferMarshaler.toLongBuffer(cls, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static void toNative(LongBuffer buffer, long handle, long flags, int d1, int d2) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static LongBuffer toLongBuffer(Class<?> cls, long handle, long flags, int d1, int d2, int d3) {
            return BufferMarshaler.toLongBuffer(cls, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static void toNative(LongBuffer buffer, long handle, long flags, int d1, int d2, int d3) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static FloatBuffer toFloatBuffer(Class<?> cls, long handle, long flags, int d1) {
            return VM.newDirectByteBuffer(handle, d1 << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }

        @MarshalsArray
        public static void toNative(FloatBuffer buffer, long handle, long flags, int d1) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1);
        }

        @MarshalsArray
        public static FloatBuffer toFloatBuffer(Class<?> cls, long handle, long flags, int d1, int d2) {
            return BufferMarshaler.toFloatBuffer(cls, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static void toNative(FloatBuffer buffer, long handle, long flags, int d1, int d2) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static FloatBuffer toFloatBuffer(Class<?> cls, long handle, long flags, int d1, int d2, int d3) {
            return BufferMarshaler.toFloatBuffer(cls, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static void toNative(FloatBuffer buffer, long handle, long flags, int d1, int d2, int d3) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static DoubleBuffer toDoubleBuffer(Class<?> cls, long handle, long flags, int d1) {
            return VM.newDirectByteBuffer(handle, d1 << 3).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        }

        @MarshalsArray
        public static void toNative(DoubleBuffer buffer, long handle, long flags, int d1) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1);
        }

        @MarshalsArray
        public static DoubleBuffer toDoubleBuffer(Class<?> cls, long handle, long flags, int d1, int d2) {
            return BufferMarshaler.toDoubleBuffer(cls, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static void toNative(DoubleBuffer buffer, long handle, long flags, int d1, int d2) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static DoubleBuffer toDoubleBuffer(Class<?> cls, long handle, long flags, int d1, int d2, int d3) {
            return BufferMarshaler.toDoubleBuffer(cls, handle, flags, d1 * d2 * d3);
        }

        @MarshalsArray
        public static void toNative(DoubleBuffer buffer, long handle, long flags, int d1, int d2, int d3) {
            BufferMarshaler.copyBuffer(buffer, handle, flags, d1 * d2 * d3);
        }

        static {
            try {
                Field f1 = Buffer.class.getDeclaredField("effectiveDirectAddress");
                if (f1.getType() != Long.TYPE) {
                    throw new Error("java.nio.Buffer.effectiveDirectAddress should be a long");
                }
                EFFECTIVE_DIRECT_ADDRESS_OFFSET = VM.getInstanceFieldOffset(VM.getFieldAddress(f1));
                Field f2 = Buffer.class.getDeclaredField("_elementSizeShift");
                _ELEMENT_SIZE_SHIFT_OFFSET = VM.getInstanceFieldOffset(VM.getFieldAddress(f2));
            }
            catch (NoSuchFieldException e) {
                throw new Error(e);
            }
        }
    }
}

