/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.harmony.xml.dom.AttrImpl;
import org.apache.harmony.xml.dom.DOMImplementationImpl;
import org.apache.harmony.xml.dom.DocumentImpl;
import org.apache.harmony.xml.dom.DocumentTypeImpl;
import org.apache.harmony.xml.dom.ElementImpl;
import org.apache.harmony.xml.dom.NodeListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
implements Node {
    private static final NodeList EMPTY_LIST = new NodeListImpl();
    static final TypeInfo NULL_TYPE_INFO = new TypeInfo(){

        @Override
        public String getTypeName() {
            return null;
        }

        @Override
        public String getTypeNamespace() {
            return null;
        }

        @Override
        public boolean isDerivedFrom(String typeNamespaceArg, String typeNameArg, int derivationMethod) {
            return false;
        }
    };
    DocumentImpl document;

    NodeImpl(DocumentImpl document) {
        this.document = document;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(3, null);
    }

    @Override
    public final Node cloneNode(boolean deep) {
        return this.document.cloneOrImportNode((short)1, this, deep);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        return EMPTY_LIST;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public abstract short getNodeType();

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public final Document getOwnerDocument() {
        return this.document == this ? null : this.document;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(3, null);
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return DOMImplementationImpl.getInstance().hasFeature(feature, version);
    }

    @Override
    public void normalize() {
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(3, null);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(3, null);
    }

    @Override
    public final void setNodeValue(String nodeValue) throws DOMException {
        switch (this.getNodeType()) {
            case 3: 
            case 4: 
            case 8: {
                ((CharacterData)((Object)this)).setData(nodeValue);
                return;
            }
            case 7: {
                ((ProcessingInstruction)((Object)this)).setData(nodeValue);
                return;
            }
            case 2: {
                ((Attr)((Object)this)).setValue(nodeValue);
                return;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
        }
        throw new DOMException(9, "Unsupported node type " + this.getNodeType());
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    static String validatePrefix(String prefix, boolean namespaceAware, String namespaceURI) {
        if (!namespaceAware) {
            throw new DOMException(14, prefix);
        }
        if (prefix != null && (namespaceURI == null || !DocumentImpl.isXMLIdentifier(prefix) || "xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI) || "xmlns".equals(prefix) && !"http://www.w3.org/2000/xmlns/".equals(namespaceURI))) {
            throw new DOMException(14, prefix);
        }
        return prefix;
    }

    static void setNameNS(NodeImpl node, String namespaceURI, String qualifiedName) {
        if (qualifiedName == null) {
            throw new DOMException(14, qualifiedName);
        }
        String prefix = null;
        int p = qualifiedName.lastIndexOf(":");
        if (p != -1) {
            prefix = NodeImpl.validatePrefix(qualifiedName.substring(0, p), true, namespaceURI);
            qualifiedName = qualifiedName.substring(p + 1);
        }
        if (!DocumentImpl.isXMLIdentifier(qualifiedName)) {
            throw new DOMException(5, qualifiedName);
        }
        switch (node.getNodeType()) {
            case 2: {
                if ("xmlns".equals(qualifiedName) && !"http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                    throw new DOMException(14, qualifiedName);
                }
                AttrImpl attr = (AttrImpl)node;
                attr.namespaceAware = true;
                attr.namespaceURI = namespaceURI;
                attr.prefix = prefix;
                attr.localName = qualifiedName;
                break;
            }
            case 1: {
                ElementImpl element = (ElementImpl)node;
                element.namespaceAware = true;
                element.namespaceURI = namespaceURI;
                element.prefix = prefix;
                element.localName = qualifiedName;
                break;
            }
            default: {
                throw new DOMException(9, "Cannot rename nodes of type " + node.getNodeType());
            }
        }
    }

    static void setName(NodeImpl node, String name) {
        int prefixSeparator = name.lastIndexOf(":");
        if (prefixSeparator != -1) {
            String prefix = name.substring(0, prefixSeparator);
            String localName = name.substring(prefixSeparator + 1);
            if (!DocumentImpl.isXMLIdentifier(prefix) || !DocumentImpl.isXMLIdentifier(localName)) {
                throw new DOMException(5, name);
            }
        } else if (!DocumentImpl.isXMLIdentifier(name)) {
            throw new DOMException(5, name);
        }
        switch (node.getNodeType()) {
            case 2: {
                AttrImpl attr = (AttrImpl)node;
                attr.namespaceAware = false;
                attr.localName = name;
                break;
            }
            case 1: {
                ElementImpl element = (ElementImpl)node;
                element.namespaceAware = false;
                element.localName = name;
                break;
            }
            default: {
                throw new DOMException(9, "Cannot rename nodes of type " + node.getNodeType());
            }
        }
    }

    @Override
    public final String getBaseURI() {
        switch (this.getNodeType()) {
            case 9: {
                return this.sanitizeUri(((Document)((Object)this)).getDocumentURI());
            }
            case 1: {
                Element element = (Element)((Object)this);
                String uri = element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
                try {
                    if (uri == null || uri.isEmpty()) {
                        return this.getParentBaseUri();
                    }
                    if (new URI(uri).isAbsolute()) {
                        return uri;
                    }
                    String parentUri = this.getParentBaseUri();
                    if (parentUri == null) {
                        return null;
                    }
                    return new URI(parentUri).resolve(uri).toString();
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            case 7: {
                return this.getParentBaseUri();
            }
            case 6: 
            case 12: {
                return null;
            }
            case 5: {
                return null;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                return null;
            }
        }
        throw new DOMException(9, "Unsupported node type " + this.getNodeType());
    }

    private String getParentBaseUri() {
        Node parentNode = this.getParentNode();
        return parentNode != null ? parentNode.getBaseURI() : null;
    }

    private String sanitizeUri(String uri) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        try {
            return new URI(uri).toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    void getTextContent(StringBuilder buf) throws DOMException {
        String content = this.getNodeValue();
        if (content != null) {
            buf.append(content);
        }
    }

    @Override
    public final void setTextContent(String textContent) throws DOMException {
        switch (this.getNodeType()) {
            case 9: 
            case 10: {
                return;
            }
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                Node child;
                while ((child = this.getFirstChild()) != null) {
                    this.removeChild(child);
                }
                if (textContent != null && textContent.length() != 0) {
                    this.appendChild(this.document.createTextNode(textContent));
                }
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: {
                this.setNodeValue(textContent);
                return;
            }
        }
        throw new DOMException(9, "Unsupported node type " + this.getNodeType());
    }

    @Override
    public boolean isSameNode(Node other) {
        return this == other;
    }

    private NodeImpl getNamespacingElement() {
        switch (this.getNodeType()) {
            case 1: {
                return this;
            }
            case 9: {
                return (NodeImpl)((Object)((Document)((Object)this)).getDocumentElement());
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                return (NodeImpl)((Object)((Attr)((Object)this)).getOwnerElement());
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return this.getContainingElement();
            }
        }
        throw new DOMException(9, "Unsupported node type " + this.getNodeType());
    }

    private NodeImpl getContainingElement() {
        for (Node p = this.getParentNode(); p != null; p = p.getParentNode()) {
            if (p.getNodeType() != 1) continue;
            return (NodeImpl)p;
        }
        return null;
    }

    @Override
    public final String lookupPrefix(String namespaceURI) {
        NodeImpl target;
        if (namespaceURI == null) {
            return null;
        }
        for (NodeImpl node = target = this.getNamespacingElement(); node != null; node = node.getContainingElement()) {
            if (namespaceURI.equals(node.getNamespaceURI()) && target.isPrefixMappedToUri(node.getPrefix(), namespaceURI)) {
                return node.getPrefix();
            }
            if (!node.hasAttributes()) continue;
            NamedNodeMap attributes = node.getAttributes();
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = attributes.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !"xmlns".equals(attr.getPrefix()) || !namespaceURI.equals(attr.getNodeValue()) || !target.isPrefixMappedToUri(attr.getLocalName(), namespaceURI)) continue;
                return attr.getLocalName();
            }
        }
        return null;
    }

    boolean isPrefixMappedToUri(String prefix, String uri) {
        if (prefix == null) {
            return false;
        }
        String actual = this.lookupNamespaceURI(prefix);
        return uri.equals(actual);
    }

    @Override
    public final boolean isDefaultNamespace(String namespaceURI) {
        String actual = this.lookupNamespaceURI(null);
        return namespaceURI == null ? actual == null : namespaceURI.equals(actual);
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        NodeImpl target;
        for (NodeImpl node = target = this.getNamespacingElement(); node != null; node = node.getContainingElement()) {
            String nodePrefix = node.getPrefix();
            if (node.getNamespaceURI() != null && (prefix == null ? nodePrefix == null : prefix.equals(nodePrefix))) {
                return node.getNamespaceURI();
            }
            if (!node.hasAttributes()) continue;
            NamedNodeMap attributes = node.getAttributes();
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = attributes.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !(prefix == null ? "xmlns".equals(attr.getNodeName()) : "xmlns".equals(attr.getPrefix()) && prefix.equals(attr.getLocalName()))) continue;
                String value = attr.getNodeValue();
                return value.length() > 0 ? value : null;
            }
        }
        return null;
    }

    private static List<Object> createEqualityKey(Node node) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(node.getNodeType());
        values.add(node.getNodeName());
        values.add(node.getLocalName());
        values.add(node.getNamespaceURI());
        values.add(node.getPrefix());
        values.add(node.getNodeValue());
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            values.add(child);
        }
        switch (node.getNodeType()) {
            case 10: {
                DocumentTypeImpl doctype = (DocumentTypeImpl)node;
                values.add(doctype.getPublicId());
                values.add(doctype.getSystemId());
                values.add(doctype.getInternalSubset());
                values.add(doctype.getEntities());
                values.add(doctype.getNotations());
                break;
            }
            case 1: {
                Element element = (Element)node;
                values.add(element.getAttributes());
            }
        }
        return values;
    }

    @Override
    public final boolean isEqualNode(Node arg) {
        if (arg == this) {
            return true;
        }
        List<Object> listA = NodeImpl.createEqualityKey(this);
        List<Object> listB = NodeImpl.createEqualityKey(arg);
        if (listA.size() != listB.size()) {
            return false;
        }
        for (int i = 0; i < listA.size(); ++i) {
            Object b;
            Object a = listA.get(i);
            if (a == (b = listB.get(i))) continue;
            if (a == null || b == null) {
                return false;
            }
            if (a instanceof String || a instanceof Short) {
                if (a.equals(b)) continue;
                return false;
            }
            if (a instanceof NamedNodeMap) {
                if (b instanceof NamedNodeMap && this.namedNodeMapsEqual((NamedNodeMap)a, (NamedNodeMap)b)) continue;
                return false;
            }
            if (a instanceof Node) {
                if (b instanceof Node && ((Node)a).isEqualNode((Node)b)) continue;
                return false;
            }
            throw new AssertionError();
        }
        return true;
    }

    private boolean namedNodeMapsEqual(NamedNodeMap a, NamedNodeMap b) {
        if (a.getLength() != b.getLength()) {
            return false;
        }
        for (int i = 0; i < a.getLength(); ++i) {
            Node bNode;
            Node aNode = a.item(i);
            Node node = bNode = aNode.getLocalName() == null ? b.getNamedItem(aNode.getNodeName()) : b.getNamedItemNS(aNode.getNamespaceURI(), aNode.getLocalName());
            if (bNode != null && aNode.isEqualNode(bNode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Object getFeature(String feature, String version) {
        return this.isSupported(feature, version) ? this : null;
    }

    @Override
    public final Object setUserData(String key, Object data, UserDataHandler handler) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        Map<String, UserData> map = this.document.getUserDataMap(this);
        UserData previous = data == null ? map.remove(key) : map.put(key, new UserData(data, handler));
        return previous != null ? previous.value : null;
    }

    @Override
    public final Object getUserData(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        Map<String, UserData> map = this.document.getUserDataMapForRead(this);
        UserData userData = map.get(key);
        return userData != null ? userData.value : null;
    }

    static class UserData {
        final Object value;
        final UserDataHandler handler;

        UserData(Object value, UserDataHandler handler) {
            this.value = value;
            this.handler = handler;
        }
    }
}

