/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml.dom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.harmony.xml.dom.AttrImpl;
import org.apache.harmony.xml.dom.CDATASectionImpl;
import org.apache.harmony.xml.dom.CommentImpl;
import org.apache.harmony.xml.dom.DOMConfigurationImpl;
import org.apache.harmony.xml.dom.DOMImplementationImpl;
import org.apache.harmony.xml.dom.DocumentFragmentImpl;
import org.apache.harmony.xml.dom.ElementImpl;
import org.apache.harmony.xml.dom.EntityReferenceImpl;
import org.apache.harmony.xml.dom.InnerNodeImpl;
import org.apache.harmony.xml.dom.LeafNodeImpl;
import org.apache.harmony.xml.dom.NodeImpl;
import org.apache.harmony.xml.dom.NodeListImpl;
import org.apache.harmony.xml.dom.ProcessingInstructionImpl;
import org.apache.harmony.xml.dom.TextImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class DocumentImpl
extends InnerNodeImpl
implements Document {
    private DOMImplementation domImplementation;
    private DOMConfigurationImpl domConfiguration;
    private String documentUri;
    private String inputEncoding;
    private String xmlEncoding;
    private String xmlVersion = "1.0";
    private boolean xmlStandalone = false;
    private boolean strictErrorChecking = true;
    private WeakHashMap<NodeImpl, Map<String, NodeImpl.UserData>> nodeToUserData;

    public DocumentImpl(DOMImplementationImpl impl, String namespaceURI, String qualifiedName, DocumentType doctype, String inputEncoding) {
        super(null);
        this.document = this;
        this.domImplementation = impl;
        this.inputEncoding = inputEncoding;
        if (doctype != null) {
            this.appendChild(doctype);
        }
        if (qualifiedName != null) {
            this.appendChild(this.createElementNS(namespaceURI, qualifiedName));
        }
    }

    private static boolean isXMLIdentifierStart(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    private static boolean isXMLIdentifierPart(char c) {
        return DocumentImpl.isXMLIdentifierStart(c) || c >= '0' && c <= '9' || c == '-' || c == '.';
    }

    static boolean isXMLIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (!DocumentImpl.isXMLIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (DocumentImpl.isXMLIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private NodeImpl shallowCopy(short operation, Node node) {
        switch (node.getNodeType()) {
            case 2: {
                AttrImpl attrCopy;
                AttrImpl attr = (AttrImpl)node;
                if (attr.namespaceAware) {
                    attrCopy = this.createAttributeNS(attr.getNamespaceURI(), attr.getLocalName());
                    attrCopy.setPrefix(attr.getPrefix());
                } else {
                    attrCopy = this.createAttribute(attr.getName());
                }
                attrCopy.setNodeValue(attr.getValue());
                return attrCopy;
            }
            case 4: {
                return this.createCDATASection(((CharacterData)node).getData());
            }
            case 8: {
                return this.createComment(((Comment)node).getData());
            }
            case 11: {
                return this.createDocumentFragment();
            }
            case 9: 
            case 10: {
                throw new DOMException(9, "Cannot copy node of type " + node.getNodeType());
            }
            case 1: {
                ElementImpl elementCopy;
                ElementImpl element = (ElementImpl)node;
                if (element.namespaceAware) {
                    elementCopy = this.createElementNS(element.getNamespaceURI(), element.getLocalName());
                    elementCopy.setPrefix(element.getPrefix());
                } else {
                    elementCopy = this.createElement(element.getTagName());
                }
                NamedNodeMap attributes = element.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    AttrImpl elementAttr = (AttrImpl)attributes.item(i);
                    AttrImpl elementAttrCopy = (AttrImpl)this.shallowCopy(operation, elementAttr);
                    DocumentImpl.notifyUserDataHandlers(operation, elementAttr, elementAttrCopy);
                    if (elementAttr.namespaceAware) {
                        elementCopy.setAttributeNodeNS(elementAttrCopy);
                        continue;
                    }
                    elementCopy.setAttributeNode(elementAttrCopy);
                }
                return elementCopy;
            }
            case 6: 
            case 12: {
                throw new UnsupportedOperationException();
            }
            case 5: {
                return this.createEntityReference(node.getNodeName());
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                return this.createProcessingInstruction(pi.getTarget(), pi.getData());
            }
            case 3: {
                return this.createTextNode(((Text)node).getData());
            }
        }
        throw new DOMException(9, "Unsupported node type " + node.getNodeType());
    }

    Node cloneOrImportNode(short operation, Node node, boolean deep) {
        NodeImpl copy = this.shallowCopy(operation, node);
        if (deep) {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                copy.appendChild(this.cloneOrImportNode(operation, list.item(i), deep));
            }
        }
        DocumentImpl.notifyUserDataHandlers(operation, node, copy);
        return copy;
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) {
        return this.cloneOrImportNode((short)2, importedNode, deep);
    }

    @Override
    public Node adoptNode(Node node) {
        Node parent;
        if (!(node instanceof NodeImpl)) {
            return null;
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        switch (nodeImpl.getNodeType()) {
            case 2: {
                AttrImpl attr = (AttrImpl)node;
                if (attr.ownerElement == null) break;
                attr.ownerElement.removeAttributeNode(attr);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                throw new DOMException(9, "Cannot adopt nodes of type " + nodeImpl.getNodeType());
            }
            default: {
                throw new DOMException(9, "Unsupported node type " + node.getNodeType());
            }
        }
        if ((parent = nodeImpl.getParentNode()) != null) {
            parent.removeChild(nodeImpl);
        }
        this.changeDocumentToThis(nodeImpl);
        DocumentImpl.notifyUserDataHandlers((short)5, node, null);
        return nodeImpl;
    }

    private void changeDocumentToThis(NodeImpl node) {
        Map<String, NodeImpl.UserData> userData = node.document.getUserDataMapForRead(node);
        if (!userData.isEmpty()) {
            this.getUserDataMap(node).putAll(userData);
        }
        node.document = this;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.changeDocumentToThis((NodeImpl)list.item(i));
        }
        if (node.getNodeType() == 1) {
            NamedNodeMap attributes = node.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.changeDocumentToThis((AttrImpl)attributes.item(i));
            }
        }
    }

    @Override
    public Node renameNode(Node node, String namespaceURI, String qualifiedName) {
        if (node.getOwnerDocument() != this) {
            throw new DOMException(4, null);
        }
        DocumentImpl.setNameNS((NodeImpl)node, namespaceURI, qualifiedName);
        DocumentImpl.notifyUserDataHandlers((short)4, node, null);
        return node;
    }

    @Override
    public AttrImpl createAttribute(String name) {
        return new AttrImpl(this, name);
    }

    @Override
    public AttrImpl createAttributeNS(String namespaceURI, String qualifiedName) {
        return new AttrImpl(this, namespaceURI, qualifiedName);
    }

    @Override
    public CDATASectionImpl createCDATASection(String data) {
        return new CDATASectionImpl(this, data);
    }

    @Override
    public CommentImpl createComment(String data) {
        return new CommentImpl(this, data);
    }

    @Override
    public DocumentFragmentImpl createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    @Override
    public ElementImpl createElement(String tagName) {
        return new ElementImpl(this, tagName);
    }

    @Override
    public ElementImpl createElementNS(String namespaceURI, String qualifiedName) {
        return new ElementImpl(this, namespaceURI, qualifiedName);
    }

    @Override
    public EntityReferenceImpl createEntityReference(String name) {
        return new EntityReferenceImpl(this, name);
    }

    @Override
    public ProcessingInstructionImpl createProcessingInstruction(String target, String data) {
        return new ProcessingInstructionImpl(this, target, data);
    }

    @Override
    public TextImpl createTextNode(String data) {
        return new TextImpl(this, data);
    }

    @Override
    public DocumentType getDoctype() {
        for (LeafNodeImpl child : this.children) {
            if (!(child instanceof DocumentType)) continue;
            return (DocumentType)((Object)child);
        }
        return null;
    }

    @Override
    public Element getDocumentElement() {
        for (LeafNodeImpl child : this.children) {
            if (!(child instanceof Element)) continue;
            return (Element)((Object)child);
        }
        return null;
    }

    @Override
    public Element getElementById(String elementId) {
        ElementImpl root = (ElementImpl)this.getDocumentElement();
        return root == null ? null : root.getElementById(elementId);
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        NodeListImpl result = new NodeListImpl();
        this.getElementsByTagName(result, name);
        return result;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        NodeListImpl result = new NodeListImpl();
        this.getElementsByTagNameNS(result, namespaceURI, localName);
        return result;
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.domImplementation;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public Node insertChildAt(Node toInsert, int index) {
        if (toInsert instanceof Element && this.getDocumentElement() != null) {
            throw new DOMException(3, "Only one root element allowed");
        }
        if (toInsert instanceof DocumentType && this.getDoctype() != null) {
            throw new DOMException(3, "Only one DOCTYPE element allowed");
        }
        return super.insertChildAt(toInsert, index);
    }

    @Override
    public String getTextContent() {
        return null;
    }

    @Override
    public String getInputEncoding() {
        return this.inputEncoding;
    }

    @Override
    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    @Override
    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) {
        this.xmlStandalone = xmlStandalone;
    }

    @Override
    public String getXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    @Override
    public String getDocumentURI() {
        return this.documentUri;
    }

    @Override
    public void setDocumentURI(String documentUri) {
        this.documentUri = documentUri;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        if (this.domConfiguration == null) {
            this.domConfiguration = new DOMConfigurationImpl();
        }
        return this.domConfiguration;
    }

    @Override
    public void normalizeDocument() {
        Element root = this.getDocumentElement();
        if (root == null) {
            return;
        }
        ((DOMConfigurationImpl)this.getDomConfig()).normalize(root);
    }

    Map<String, NodeImpl.UserData> getUserDataMap(NodeImpl node) {
        Map<String, NodeImpl.UserData> userDataMap;
        if (this.nodeToUserData == null) {
            this.nodeToUserData = new WeakHashMap();
        }
        if ((userDataMap = this.nodeToUserData.get(node)) == null) {
            userDataMap = new HashMap<String, NodeImpl.UserData>();
            this.nodeToUserData.put(node, userDataMap);
        }
        return userDataMap;
    }

    Map<String, NodeImpl.UserData> getUserDataMapForRead(NodeImpl node) {
        if (this.nodeToUserData == null) {
            return Collections.emptyMap();
        }
        Map<String, NodeImpl.UserData> userDataMap = this.nodeToUserData.get(node);
        return userDataMap == null ? Collections.emptyMap() : userDataMap;
    }

    private static void notifyUserDataHandlers(short operation, Node source, NodeImpl destination) {
        if (!(source instanceof NodeImpl)) {
            return;
        }
        NodeImpl srcImpl = (NodeImpl)source;
        if (srcImpl.document == null) {
            return;
        }
        for (Map.Entry<String, NodeImpl.UserData> entry : srcImpl.document.getUserDataMapForRead(srcImpl).entrySet()) {
            NodeImpl.UserData userData = entry.getValue();
            if (userData.handler == null) continue;
            userData.handler.handle(operation, entry.getKey(), userData.value, source, destination);
        }
    }
}

