/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml.dom;

import org.apache.harmony.xml.dom.DocumentImpl;
import org.apache.harmony.xml.dom.LeafNodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class CharacterDataImpl
extends LeafNodeImpl
implements CharacterData {
    protected StringBuffer buffer;

    CharacterDataImpl(DocumentImpl document, String data) {
        super(document);
        this.setData(data);
    }

    @Override
    public void appendData(String arg) throws DOMException {
        this.buffer.append(arg);
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        this.buffer.delete(offset, offset + count);
    }

    @Override
    public String getData() throws DOMException {
        return this.buffer.toString();
    }

    public void appendDataTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.buffer);
    }

    @Override
    public int getLength() {
        return this.buffer.length();
    }

    @Override
    public String getNodeValue() {
        return this.getData();
    }

    @Override
    public void insertData(int offset, String arg) throws DOMException {
        try {
            this.buffer.insert(offset, arg);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new DOMException(1, null);
        }
    }

    @Override
    public void replaceData(int offset, int count, String arg) throws DOMException {
        try {
            this.buffer.replace(offset, offset + count, arg);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new DOMException(1, null);
        }
    }

    @Override
    public void setData(String data) throws DOMException {
        this.buffer = new StringBuffer(data);
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        try {
            return this.buffer.substring(offset, offset + count);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new DOMException(1, null);
        }
    }
}

