/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Choice;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x501.Name;
import org.apache.harmony.security.x509.GeneralNames;

public final class DistributionPointName {
    private final GeneralNames fullName;
    private final Name nameRelativeToCRLIssuer;
    public static final ASN1Choice ASN1 = new ASN1Choice(new ASN1Type[]{new ASN1Implicit(0, GeneralNames.ASN1), new ASN1Implicit(1, Name.ASN1_RDN)}){

        @Override
        public int getIndex(Object object) {
            DistributionPointName dpn = (DistributionPointName)object;
            return dpn.fullName == null ? 1 : 0;
        }

        @Override
        protected Object getDecodedObject(BerInputStream in) throws IOException {
            DistributionPointName result = null;
            result = in.choiceIndex == 0 ? new DistributionPointName((GeneralNames)in.content) : new DistributionPointName((Name)in.content);
            return result;
        }

        @Override
        public Object getObjectToEncode(Object object) {
            DistributionPointName dpn = (DistributionPointName)object;
            if (dpn.fullName == null) {
                return dpn.nameRelativeToCRLIssuer;
            }
            return dpn.fullName;
        }
    };

    public DistributionPointName(GeneralNames fullName) {
        this.fullName = fullName;
        this.nameRelativeToCRLIssuer = null;
    }

    public DistributionPointName(Name nameRelativeToCRLIssuer) {
        this.fullName = null;
        this.nameRelativeToCRLIssuer = nameRelativeToCRLIssuer;
    }

    public void dumpValue(StringBuilder sb, String prefix) {
        sb.append(prefix);
        sb.append("Distribution Point Name: [\n");
        if (this.fullName != null) {
            this.fullName.dumpValue(sb, prefix + "  ");
        } else {
            sb.append(prefix);
            sb.append("  ");
            sb.append(this.nameRelativeToCRLIssuer.getName("RFC2253"));
        }
        sb.append(prefix);
        sb.append("]\n");
    }
}

