/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.harmony.security.asn1.ASN1Any;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;

public abstract class ASN1Choice
extends ASN1Type {
    public final ASN1Type[] type;
    private final int[][] identifiers;

    public ASN1Choice(ASN1Type[] type) {
        super(0);
        if (type.length == 0) {
            throw new IllegalArgumentException("ASN.1 choice type MUST have at least one alternative: " + this.getClass().getName());
        }
        TreeMap<BigInteger, BigInteger> map = new TreeMap<BigInteger, BigInteger>();
        for (int index = 0; index < type.length; ++index) {
            ASN1Type t = type[index];
            if (t instanceof ASN1Any) {
                throw new IllegalArgumentException("ASN.1 choice type MUST have alternatives with distinct tags: " + this.getClass().getName());
            }
            if (t instanceof ASN1Choice) {
                int[][] choiceToAdd = ((ASN1Choice)t).identifiers;
                for (int j = 0; j < choiceToAdd[0].length; ++j) {
                    this.addIdentifier(map, choiceToAdd[0][j], index);
                }
                continue;
            }
            if (t.checkTag(t.id)) {
                this.addIdentifier(map, t.id, index);
            }
            if (!t.checkTag(t.constrId)) continue;
            this.addIdentifier(map, t.constrId, index);
        }
        int size = map.size();
        this.identifiers = new int[2][size];
        Iterator it = map.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = it.next();
            BigInteger identifier = (BigInteger)entry.getKey();
            this.identifiers[0][i] = identifier.intValue();
            this.identifiers[1][i] = ((BigInteger)entry.getValue()).intValue();
        }
        this.type = type;
    }

    private void addIdentifier(TreeMap<BigInteger, BigInteger> map, int identifier, int index) {
        if (map.put(BigInteger.valueOf(identifier), BigInteger.valueOf(index)) != null) {
            throw new IllegalArgumentException("ASN.1 choice type MUST have alternatives with distinct tags: " + this.getClass().getName());
        }
    }

    @Override
    public final boolean checkTag(int identifier) {
        return Arrays.binarySearch(this.identifiers[0], identifier) >= 0;
    }

    @Override
    public Object decode(BerInputStream in) throws IOException {
        int index = Arrays.binarySearch(this.identifiers[0], in.tag);
        if (index < 0) {
            throw new ASN1Exception("Failed to decode ASN.1 choice type.  No alternatives were found for " + this.getClass().getName());
        }
        index = this.identifiers[1][index];
        in.content = this.type[index].decode(in);
        in.choiceIndex = index;
        if (in.isVerify) {
            return null;
        }
        return this.getDecodedObject(in);
    }

    @Override
    public void encodeASN(BerOutputStream out) {
        this.encodeContent(out);
    }

    @Override
    public final void encodeContent(BerOutputStream out) {
        out.encodeChoice(this);
    }

    public abstract int getIndex(Object var1);

    public abstract Object getObjectToEncode(Object var1);

    @Override
    public final void setEncodingContent(BerOutputStream out) {
        out.getChoiceLength(this);
    }
}

