/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import libcore.io.BufferIterator;

public final class ZoneInfo
extends TimeZone {
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private static final long MILLISECONDS_PER_400_YEARS = 12622780800000L;
    private static final long UNIX_OFFSET = 62167219200000L;
    private static final int[] NORMAL = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private int mRawOffset;
    private final int mEarliestRawOffset;
    private final boolean mUseDst;
    private final int mDstSavings;
    private final int[] mTransitions;
    private final int[] mOffsets;
    private final byte[] mTypes;
    private final byte[] mIsDsts;

    public static TimeZone makeTimeZone(String id, BufferIterator it) {
        if (it.readInt() != 1415211366) {
            return null;
        }
        it.skip(28);
        int tzh_timecnt = it.readInt();
        int tzh_typecnt = it.readInt();
        it.skip(4);
        int[] transitions = new int[tzh_timecnt];
        it.readIntArray(transitions, 0, transitions.length);
        byte[] type = new byte[tzh_timecnt];
        it.readByteArray(type, 0, type.length);
        int[] gmtOffsets = new int[tzh_typecnt];
        byte[] isDsts = new byte[tzh_typecnt];
        for (int i = 0; i < tzh_typecnt; ++i) {
            gmtOffsets[i] = it.readInt();
            isDsts[i] = it.readByte();
            it.skip(1);
        }
        return new ZoneInfo(id, transitions, type, gmtOffsets, isDsts);
    }

    private ZoneInfo(String name, int[] transitions, byte[] types, int[] gmtOffsets, byte[] isDsts) {
        long latestScheduleTime;
        this.mTransitions = transitions;
        this.mTypes = types;
        this.mIsDsts = isDsts;
        this.setID(name);
        int lastStd = 0;
        boolean haveStd = false;
        int lastDst = 0;
        boolean haveDst = false;
        for (int i = this.mTransitions.length - 1; !(haveStd && haveDst || i < 0); --i) {
            int type = this.mTypes[i] & 0xFF;
            if (!haveStd && this.mIsDsts[type] == 0) {
                haveStd = true;
                lastStd = i;
            }
            if (haveDst || this.mIsDsts[type] == 0) continue;
            haveDst = true;
            lastDst = i;
        }
        this.mRawOffset = lastStd >= this.mTypes.length ? gmtOffsets[0] : gmtOffsets[this.mTypes[lastStd] & 0xFF];
        this.mDstSavings = lastDst >= this.mTypes.length ? 0 : Math.abs(gmtOffsets[this.mTypes[lastStd] & 0xFF] - gmtOffsets[this.mTypes[lastDst] & 0xFF]) * 1000;
        int firstStd = -1;
        for (int i = 0; i < this.mTransitions.length; ++i) {
            if (this.mIsDsts[this.mTypes[i] & 0xFF] != 0) continue;
            firstStd = i;
            break;
        }
        int earliestRawOffset = firstStd != -1 ? gmtOffsets[this.mTypes[firstStd] & 0xFF] : this.mRawOffset;
        this.mOffsets = gmtOffsets;
        int i = 0;
        while (i < this.mOffsets.length) {
            int n = i++;
            this.mOffsets[n] = this.mOffsets[n] - this.mRawOffset;
        }
        boolean usesDst = false;
        long currentUnixTime = System.currentTimeMillis() / 1000L;
        if (this.mTransitions.length > 0 && currentUnixTime < (latestScheduleTime = (long)this.mTransitions[this.mTransitions.length - 1] & 0xFFFFFFFFFFFFFFFFL)) {
            usesDst = true;
        }
        this.mUseDst = usesDst;
        this.mRawOffset *= 1000;
        this.mEarliestRawOffset = earliestRawOffset * 1000;
    }

    @Override
    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        long calc = (long)(year / 400) * 12622780800000L;
        calc += (long)(year %= 400) * 31536000000L;
        calc += (long)((year + 3) / 4) * 86400000L;
        if (year > 0) {
            calc -= (long)((year - 1) / 100) * 86400000L;
        }
        boolean isLeap = year == 0 || year % 4 == 0 && year % 100 != 0;
        int[] mlen = isLeap ? LEAP : NORMAL;
        calc += (long)mlen[month] * 86400000L;
        calc += (long)(day - 1) * 86400000L;
        calc += (long)millis;
        calc -= (long)this.mRawOffset;
        return this.getOffset(calc -= 62167219200000L);
    }

    @Override
    public int getOffset(long when) {
        int unix = (int)(when / 1000L);
        int transition = Arrays.binarySearch(this.mTransitions, unix);
        if (transition < 0 && (transition = ~transition - 1) < 0) {
            return this.mEarliestRawOffset;
        }
        return this.mRawOffset + this.mOffsets[this.mTypes[transition] & 0xFF] * 1000;
    }

    @Override
    public boolean inDaylightTime(Date time) {
        long when = time.getTime();
        int unix = (int)(when / 1000L);
        int transition = Arrays.binarySearch(this.mTransitions, unix);
        if (transition < 0 && (transition = ~transition - 1) < 0) {
            return false;
        }
        return this.mIsDsts[this.mTypes[transition] & 0xFF] == 1;
    }

    @Override
    public int getRawOffset() {
        return this.mRawOffset;
    }

    @Override
    public void setRawOffset(int off) {
        this.mRawOffset = off;
    }

    @Override
    public int getDSTSavings() {
        return this.mUseDst ? this.mDstSavings : 0;
    }

    @Override
    public boolean useDaylightTime() {
        return this.mUseDst;
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (!(timeZone instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo other = (ZoneInfo)timeZone;
        if (this.mUseDst != other.mUseDst) {
            return false;
        }
        if (!this.mUseDst) {
            return this.mRawOffset == other.mRawOffset;
        }
        return this.mRawOffset == other.mRawOffset && Arrays.equals(this.mOffsets, other.mOffsets) && Arrays.equals(this.mIsDsts, other.mIsDsts) && Arrays.equals(this.mTypes, other.mTypes) && Arrays.equals(this.mTransitions, other.mTransitions);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo other = (ZoneInfo)obj;
        return this.getID().equals(other.getID()) && this.hasSameRules(other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getID().hashCode();
        result = 31 * result + Arrays.hashCode(this.mOffsets);
        result = 31 * result + Arrays.hashCode(this.mIsDsts);
        result = 31 * result + this.mRawOffset;
        result = 31 * result + Arrays.hashCode(this.mTransitions);
        result = 31 * result + Arrays.hashCode(this.mTypes);
        result = 31 * result + (this.mUseDst ? 1231 : 1237);
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "[id=\"" + this.getID() + "\"" + ",mRawOffset=" + this.mRawOffset + ",mEarliestRawOffset=" + this.mEarliestRawOffset + ",mUseDst=" + this.mUseDst + ",mDstSavings=" + this.mDstSavings + ",transitions=" + this.mTransitions.length + "]";
    }
}

