/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Iterable<T> dereferenceIterable(final Iterable<? extends Reference<T>> iterable, final boolean trim) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<? extends Reference<T>> delegate;
                    private boolean removeIsOkay;
                    private T next;
                    {
                        this.delegate = iterable.iterator();
                    }

                    private void computeNext() {
                        this.removeIsOkay = false;
                        while (this.next == null && this.delegate.hasNext()) {
                            this.next = this.delegate.next().get();
                            if (!trim || this.next != null) continue;
                            this.delegate.remove();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        this.computeNext();
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new IllegalStateException();
                        }
                        Object result = this.next;
                        this.removeIsOkay = true;
                        this.next = null;
                        return result;
                    }

                    @Override
                    public void remove() {
                        if (!this.removeIsOkay) {
                            throw new IllegalStateException();
                        }
                        this.delegate.remove();
                    }
                };
            }
        };
    }

    public static <T> void removeDuplicates(List<T> list, Comparator<? super T> comparator) {
        Collections.sort(list, comparator);
        int j = 1;
        for (int i = 1; i < list.size(); ++i) {
            if (comparator.compare(list.get(j - 1), list.get(i)) == 0) continue;
            T object = list.get(i);
            list.set(j++, object);
        }
        if (j < list.size()) {
            list.subList(j, list.size()).clear();
        }
    }
}

