/*
 * Decompiled with CFR 0.152.
 */
package libcore.net;

import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketException;
import java.util.Arrays;
import libcore.io.IoBridge;

public class RawSocket
implements Closeable {
    public static final short ETH_P_IP = 2048;
    public static final short ETH_P_ARP = 2054;
    private final FileDescriptor fd;
    private final String mInterfaceName;
    private final short mProtocolType;
    private final CloseGuard guard = CloseGuard.get();

    private static native void create(FileDescriptor var0, short var1, String var2) throws SocketException;

    private static native int sendPacket(FileDescriptor var0, String var1, short var2, byte[] var3, byte[] var4, int var5, int var6);

    private static native int recvPacket(FileDescriptor var0, byte[] var1, int var2, int var3, int var4, int var5);

    public RawSocket(String interfaceName, short protocolType) throws SocketException {
        this.mInterfaceName = interfaceName;
        this.mProtocolType = protocolType;
        this.fd = new FileDescriptor();
        RawSocket.create(this.fd, this.mProtocolType, this.mInterfaceName);
        this.guard.open("close");
    }

    public int read(byte[] packet, int offset, int byteCount, int destPort, int timeoutMillis) {
        if (packet == null) {
            throw new NullPointerException("packet == null");
        }
        Arrays.checkOffsetAndCount(packet.length, offset, byteCount);
        if (destPort > 65535) {
            throw new IllegalArgumentException("Port out of range: " + destPort);
        }
        return RawSocket.recvPacket(this.fd, packet, offset, byteCount, destPort, timeoutMillis);
    }

    public int write(byte[] destMac, byte[] packet, int offset, int byteCount) {
        if (destMac == null) {
            throw new NullPointerException("destMac == null");
        }
        if (packet == null) {
            throw new NullPointerException("packet == null");
        }
        Arrays.checkOffsetAndCount(packet.length, offset, byteCount);
        if (destMac.length != 6) {
            throw new IllegalArgumentException("MAC length must be 6: " + destMac.length);
        }
        return RawSocket.sendPacket(this.fd, this.mInterfaceName, this.mProtocolType, destMac, packet, offset, byteCount);
    }

    @Override
    public void close() throws IOException {
        this.guard.close();
        IoBridge.closeSocket(this.fd);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

