/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import libcore.util.BasicLruCache;
import libcore.util.ZoneInfoDB;

public final class TimeZoneNames {
    private static final String[] availableTimeZoneIds = TimeZone.getAvailableIDs();
    public static final int OLSON_NAME = 0;
    public static final int LONG_NAME = 1;
    public static final int SHORT_NAME = 2;
    public static final int LONG_NAME_DST = 3;
    public static final int SHORT_NAME_DST = 4;
    public static final int NAME_COUNT = 5;
    private static final ZoneStringsCache cachedZoneStrings = new ZoneStringsCache();
    private static final Comparator<String[]> ZONE_STRINGS_COMPARATOR;

    private TimeZoneNames() {
    }

    public static String getDisplayName(String[][] zoneStrings, String id, boolean daylight, int style) {
        String[] needle = new String[]{id};
        int index = Arrays.binarySearch(zoneStrings, needle, ZONE_STRINGS_COMPARATOR);
        if (index >= 0) {
            String[] row = zoneStrings[index];
            if (daylight) {
                return style == 1 ? row[3] : row[4];
            }
            return style == 1 ? row[1] : row[2];
        }
        return null;
    }

    public static String[][] getZoneStrings(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return (String[][])cachedZoneStrings.get(locale);
    }

    public static String[] forLocale(Locale locale) {
        String countryCode = locale.getCountry();
        ArrayList<String> ids = new ArrayList<String>();
        for (String line : ZoneInfoDB.getInstance().getZoneTab().split("\n")) {
            if (!line.startsWith(countryCode)) continue;
            int olsonIdStart = line.indexOf(9, 4) + 1;
            int olsonIdEnd = line.indexOf(9, olsonIdStart);
            if (olsonIdEnd == -1) {
                olsonIdEnd = line.length();
            }
            ids.add(line.substring(olsonIdStart, olsonIdEnd));
        }
        return ids.toArray(new String[ids.size()]);
    }

    private static native void fillZoneStrings(String var0, String[][] var1);

    static {
        cachedZoneStrings.get(Locale.ROOT);
        cachedZoneStrings.get(Locale.US);
        cachedZoneStrings.get(Locale.getDefault());
        ZONE_STRINGS_COMPARATOR = new Comparator<String[]>(){

            @Override
            public int compare(String[] lhs, String[] rhs) {
                return lhs[0].compareTo(rhs[0]);
            }
        };
    }

    public static class ZoneStringsCache
    extends BasicLruCache<Locale, String[][]> {
        private final HashMap<String, String> internTable = new HashMap();

        public ZoneStringsCache() {
            super(availableTimeZoneIds.length);
        }

        @Override
        protected String[][] create(Locale locale) {
            long start = System.currentTimeMillis();
            String[][] result = new String[availableTimeZoneIds.length][5];
            for (int i = 0; i < availableTimeZoneIds.length; ++i) {
                result[i][0] = availableTimeZoneIds[i];
            }
            long nativeStart = System.currentTimeMillis();
            TimeZoneNames.fillZoneStrings(locale.toString(), result);
            long nativeEnd = System.currentTimeMillis();
            this.internStrings(result);
            long end = System.currentTimeMillis();
            long nativeDuration = nativeEnd - nativeStart;
            long duration = end - start;
            System.logI("Loaded time zone names for \"" + locale + "\" in " + duration + "ms" + " (" + nativeDuration + "ms in ICU)");
            return result;
        }

        private synchronized void internStrings(String[][] result) {
            for (int i = 0; i < result.length; ++i) {
                for (int j = 1; j < 5; ++j) {
                    String original = result[i][j];
                    String nonDuplicate = this.internTable.get(original);
                    if (nonDuplicate == null) {
                        this.internTable.put(original, original);
                        continue;
                    }
                    result[i][j] = nonDuplicate;
                }
            }
        }
    }
}

