/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;

public final class NativeBreakIterator
implements Cloneable {
    private static final int BI_CHAR_INSTANCE = 1;
    private static final int BI_WORD_INSTANCE = 2;
    private static final int BI_LINE_INSTANCE = 3;
    private static final int BI_SENT_INSTANCE = 4;
    private final long address;
    private final int type;
    private String string;
    private CharacterIterator charIterator;

    private NativeBreakIterator(long address, int type) {
        this.address = address;
        this.type = type;
        this.charIterator = new StringCharacterIterator("");
    }

    public Object clone() {
        long cloneAddr = NativeBreakIterator.cloneImpl(this.address);
        NativeBreakIterator clone = new NativeBreakIterator(cloneAddr, this.type);
        clone.string = this.string;
        clone.charIterator = this.charIterator;
        return clone;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NativeBreakIterator)) {
            return false;
        }
        NativeBreakIterator rhs = (NativeBreakIterator)object;
        return this.type == rhs.type && this.charIterator.equals(rhs.charIterator);
    }

    public int hashCode() {
        return 42;
    }

    protected void finalize() throws Throwable {
        try {
            NativeBreakIterator.closeImpl(this.address);
        }
        finally {
            super.finalize();
        }
    }

    public int current() {
        return NativeBreakIterator.currentImpl(this.address, this.string);
    }

    public int first() {
        return NativeBreakIterator.firstImpl(this.address, this.string);
    }

    public int following(int offset) {
        return NativeBreakIterator.followingImpl(this.address, this.string, offset);
    }

    public CharacterIterator getText() {
        int newLocation = NativeBreakIterator.currentImpl(this.address, this.string);
        this.charIterator.setIndex(newLocation);
        return this.charIterator;
    }

    public int last() {
        return NativeBreakIterator.lastImpl(this.address, this.string);
    }

    public int next(int n) {
        return NativeBreakIterator.nextImpl(this.address, this.string, n);
    }

    public int next() {
        return NativeBreakIterator.nextImpl(this.address, this.string, 1);
    }

    public int previous() {
        return NativeBreakIterator.previousImpl(this.address, this.string);
    }

    public void setText(CharacterIterator newText) {
        StringBuilder sb = new StringBuilder();
        char c = newText.first();
        while (c != '\uffff') {
            sb.append(c);
            c = newText.next();
        }
        this.setText(sb.toString(), newText);
    }

    public void setText(String newText) {
        this.setText(newText, new StringCharacterIterator(newText));
    }

    private void setText(String s, CharacterIterator it) {
        this.string = s;
        this.charIterator = it;
        NativeBreakIterator.setTextImpl(this.address, this.string);
    }

    public boolean hasText() {
        return this.string != null;
    }

    public boolean isBoundary(int offset) {
        return NativeBreakIterator.isBoundaryImpl(this.address, this.string, offset);
    }

    public int preceding(int offset) {
        return NativeBreakIterator.precedingImpl(this.address, this.string, offset);
    }

    public static NativeBreakIterator getCharacterInstance(Locale where) {
        return new NativeBreakIterator(NativeBreakIterator.getCharacterInstanceImpl(where.toString()), 1);
    }

    public static NativeBreakIterator getLineInstance(Locale where) {
        return new NativeBreakIterator(NativeBreakIterator.getLineInstanceImpl(where.toString()), 3);
    }

    public static NativeBreakIterator getSentenceInstance(Locale where) {
        return new NativeBreakIterator(NativeBreakIterator.getSentenceInstanceImpl(where.toString()), 4);
    }

    public static NativeBreakIterator getWordInstance(Locale where) {
        return new NativeBreakIterator(NativeBreakIterator.getWordInstanceImpl(where.toString()), 2);
    }

    private static native long getCharacterInstanceImpl(String var0);

    private static native long getWordInstanceImpl(String var0);

    private static native long getLineInstanceImpl(String var0);

    private static native long getSentenceInstanceImpl(String var0);

    private static synchronized native long cloneImpl(long var0);

    private static synchronized native void closeImpl(long var0);

    private static synchronized native void setTextImpl(long var0, String var2);

    private static synchronized native int precedingImpl(long var0, String var2, int var3);

    private static synchronized native boolean isBoundaryImpl(long var0, String var2, int var3);

    private static synchronized native int nextImpl(long var0, String var2, int var3);

    private static synchronized native int previousImpl(long var0, String var2);

    private static synchronized native int currentImpl(long var0, String var2);

    private static synchronized native int firstImpl(long var0, String var2);

    private static synchronized native int followingImpl(long var0, String var2, int var3);

    private static synchronized native int lastImpl(long var0, String var2);
}

