/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.util.EmptyArray;

public class Splitter {
    private static final String METACHARACTERS = "\\?*+[](){}^$.|";

    private Splitter() {
    }

    public static String[] fastSplit(String re, String input, int limit) {
        int end;
        int len = re.length();
        if (len == 0) {
            return null;
        }
        char ch = re.charAt(0);
        if (len != 1 || METACHARACTERS.indexOf(ch) != -1) {
            if (len == 2 && ch == '\\') {
                ch = re.charAt(1);
                if (METACHARACTERS.indexOf(ch) == -1) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (input.isEmpty()) {
            return new String[]{""};
        }
        int separatorCount = 0;
        int begin = 0;
        while (separatorCount + 1 != limit && (end = input.indexOf(ch, begin)) != -1) {
            ++separatorCount;
            begin = end + 1;
        }
        int lastPartEnd = input.length();
        if (limit == 0 && begin == lastPartEnd) {
            if (separatorCount == lastPartEnd) {
                return EmptyArray.STRING;
            }
            while (input.charAt(--begin - 1) == ch) {
            }
            separatorCount -= input.length() - begin;
            lastPartEnd = begin;
        }
        String[] result = new String[separatorCount + 1];
        begin = 0;
        for (int i = 0; i != separatorCount; ++i) {
            end = input.indexOf(ch, begin);
            result[i] = input.substring(begin, end);
            begin = end + 1;
        }
        result[separatorCount] = input.substring(begin, lastPartEnd);
        return result;
    }

    public static String[] split(Pattern pattern, String re, String input, int limit) {
        String[] fastResult = Splitter.fastSplit(re, input, limit);
        if (fastResult != null) {
            return fastResult;
        }
        if (input.isEmpty()) {
            return new String[]{""};
        }
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = new Matcher(pattern, input);
        int begin = 0;
        while (list.size() + 1 != limit && matcher.find()) {
            list.add(input.substring(begin, matcher.start()));
            begin = matcher.end();
        }
        return Splitter.finishSplit(list, input, begin, limit);
    }

    private static String[] finishSplit(List<String> list, String input, int begin, int limit) {
        if (begin < input.length()) {
            list.add(input.substring(begin));
        } else if (limit != 0) {
            list.add("");
        } else {
            for (int i = list.size() - 1; i >= 0 && list.get(i).isEmpty(); --i) {
                list.remove(i);
            }
        }
        return list.toArray(new String[list.size()]);
    }
}

