/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.prefs.XMLParser;
import libcore.io.Base64;
import libcore.util.EmptyArray;

public abstract class AbstractPreferences
extends Preferences {
    private static final List<EventObject> events = new LinkedList<EventObject>();
    private static final EventDispatcher dispatcher = new EventDispatcher("Preference Event Dispatcher");
    boolean userNode;
    protected final Object lock;
    protected boolean newNode;
    private Map<String, AbstractPreferences> cachedNode;
    private List<EventListener> nodeChangeListeners;
    private List<EventListener> preferenceChangeListeners;
    private String nodeName;
    private AbstractPreferences parentPref;
    private boolean isRemoved;
    private AbstractPreferences root;

    protected AbstractPreferences(AbstractPreferences parent, String name) {
        if (parent == null ^ name.length() == 0 || name.indexOf("/") >= 0) {
            throw new IllegalArgumentException();
        }
        this.root = parent == null ? this : parent.root;
        this.nodeChangeListeners = new LinkedList<EventListener>();
        this.preferenceChangeListeners = new LinkedList<EventListener>();
        this.isRemoved = false;
        this.cachedNode = new HashMap<String, AbstractPreferences>();
        this.nodeName = name;
        this.parentPref = parent;
        this.lock = new Object();
        this.userNode = this.root.userNode;
    }

    protected final AbstractPreferences[] cachedChildren() {
        return this.cachedNode.values().toArray(new AbstractPreferences[this.cachedNode.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractPreferences getChild(String name) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            String[] childrenNames;
            this.checkState();
            AbstractPreferences result = null;
            for (String childrenName : childrenNames = this.childrenNames()) {
                if (!childrenName.equals(name)) continue;
                result = this.childSpi(name);
                break;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRemoved() {
        Object object = this.lock;
        synchronized (object) {
            return this.isRemoved;
        }
    }

    protected abstract void flushSpi() throws BackingStoreException;

    protected abstract String[] childrenNamesSpi() throws BackingStoreException;

    protected abstract AbstractPreferences childSpi(String var1);

    protected abstract void putSpi(String var1, String var2);

    protected abstract String getSpi(String var1);

    protected abstract String[] keysSpi() throws BackingStoreException;

    protected abstract void removeNodeSpi() throws BackingStoreException;

    protected abstract void removeSpi(String var1);

    protected abstract void syncSpi() throws BackingStoreException;

    @Override
    public String absolutePath() {
        if (this.parentPref == null) {
            return "/";
        }
        if (this.parentPref == this.root) {
            return "/" + this.nodeName;
        }
        return this.parentPref.absolutePath() + "/" + this.nodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] childrenNames() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            this.checkState();
            TreeSet<String> result = new TreeSet<String>(this.cachedNode.keySet());
            String[] names = this.childrenNamesSpi();
            for (int i = 0; i < names.length; ++i) {
                result.add(names[i]);
            }
            return result.toArray(new String[result.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            for (String key : this.keys()) {
                this.remove(key);
            }
        }
    }

    @Override
    public void exportNode(OutputStream ostream) throws IOException, BackingStoreException {
        if (ostream == null) {
            throw new NullPointerException("ostream == null");
        }
        this.checkState();
        XMLParser.exportPrefs(this, ostream, false);
    }

    @Override
    public void exportSubtree(OutputStream ostream) throws IOException, BackingStoreException {
        if (ostream == null) {
            throw new NullPointerException("ostream == null");
        }
        this.checkState();
        XMLParser.exportPrefs(this, ostream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            this.flushSpi();
        }
        AbstractPreferences[] cc = this.cachedChildren();
        for (int i = 0; i < cc.length; ++i) {
            cc[i].flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key, String deflt) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String result = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkState();
            try {
                result = this.getSpi(key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result == null ? deflt : result;
    }

    @Override
    public boolean getBoolean(String key, boolean deflt) {
        String result = this.get(key, null);
        if (result == null) {
            return deflt;
        }
        if ("true".equalsIgnoreCase(result)) {
            return true;
        }
        if ("false".equalsIgnoreCase(result)) {
            return false;
        }
        return deflt;
    }

    @Override
    public byte[] getByteArray(String key, byte[] deflt) {
        String svalue = this.get(key, null);
        if (svalue == null) {
            return deflt;
        }
        if (svalue.length() == 0) {
            return EmptyArray.BYTE;
        }
        try {
            byte[] bavalue = svalue.getBytes(StandardCharsets.US_ASCII);
            if (bavalue.length % 4 != 0) {
                return deflt;
            }
            return Base64.decode(bavalue);
        }
        catch (Exception e) {
            return deflt;
        }
    }

    @Override
    public double getDouble(String key, double deflt) {
        String result = this.get(key, null);
        if (result == null) {
            return deflt;
        }
        try {
            return Double.parseDouble(result);
        }
        catch (NumberFormatException e) {
            return deflt;
        }
    }

    @Override
    public float getFloat(String key, float deflt) {
        String result = this.get(key, null);
        if (result == null) {
            return deflt;
        }
        try {
            return Float.parseFloat(result);
        }
        catch (NumberFormatException e) {
            return deflt;
        }
    }

    @Override
    public int getInt(String key, int deflt) {
        String result = this.get(key, null);
        if (result == null) {
            return deflt;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return deflt;
        }
    }

    @Override
    public long getLong(String key, long deflt) {
        String result = this.get(key, null);
        if (result == null) {
            return deflt;
        }
        try {
            return Long.parseLong(result);
        }
        catch (NumberFormatException e) {
            return deflt;
        }
    }

    @Override
    public boolean isUserNode() {
        return this.root == Preferences.userRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] keys() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            this.checkState();
            return this.keysSpi();
        }
    }

    @Override
    public String name() {
        return this.nodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Preferences node(String name) {
        AbstractPreferences startNode = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkState();
            this.validateName(name);
            if (name.isEmpty()) {
                return this;
            }
            if ("/".equals(name)) {
                return this.root;
            }
            if (name.startsWith("/")) {
                startNode = this.root;
                name = name.substring(1);
            } else {
                startNode = this;
            }
        }
        try {
            return startNode.nodeImpl(name, true);
        }
        catch (BackingStoreException e) {
            return null;
        }
    }

    private void validateName(String name) {
        if (name.endsWith("/") && name.length() > 1) {
            throw new IllegalArgumentException("Name cannot end with '/'");
        }
        if (name.indexOf("//") >= 0) {
            throw new IllegalArgumentException("Name cannot contain consecutive '/' characters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractPreferences nodeImpl(String path, boolean createNew) throws BackingStoreException {
        String[] names = path.split("/");
        AbstractPreferences currentNode = this;
        for (String name : names) {
            AbstractPreferences temp;
            Object object = currentNode.lock;
            synchronized (object) {
                temp = currentNode.cachedNode.get(name);
                if (temp == null) {
                    temp = this.getNodeFromBackend(createNew, currentNode, name);
                }
            }
            currentNode = temp;
            if (currentNode == null) break;
        }
        return currentNode;
    }

    private AbstractPreferences getNodeFromBackend(boolean createNew, AbstractPreferences currentNode, String name) throws BackingStoreException {
        AbstractPreferences temp;
        if (name.length() > 80) {
            throw new IllegalArgumentException("Name '" + name + "' too long");
        }
        if (createNew) {
            temp = currentNode.childSpi(name);
            currentNode.cachedNode.put(name, temp);
            if (temp.newNode && currentNode.nodeChangeListeners.size() > 0) {
                currentNode.notifyChildAdded(temp);
            }
        } else {
            temp = currentNode.getChild(name);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nodeExists(String name) throws BackingStoreException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        AbstractPreferences startNode = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                if (name.isEmpty()) {
                    return false;
                }
                throw new IllegalStateException("This node has been removed");
            }
            this.validateName(name);
            if (name.isEmpty() || "/".equals(name)) {
                return true;
            }
            if (name.startsWith("/")) {
                startNode = this.root;
                name = name.substring(1);
            } else {
                startNode = this;
            }
        }
        try {
            AbstractPreferences result = startNode.nodeImpl(name, false);
            return result != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public Preferences parent() {
        this.checkState();
        return this.parentPref;
    }

    private void checkState() {
        if (this.isRemoved()) {
            throw new IllegalStateException("This node has been removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (key.length() > 80 || value.length() > 8192) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkState();
            this.putSpi(key, value);
        }
        this.notifyPreferenceChange(key, value);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        this.put(key, Base64.encode(value));
    }

    @Override
    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    @Override
    public void putFloat(String key, float value) {
        this.put(key, Float.toString(value));
    }

    @Override
    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    @Override
    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.checkState();
            this.removeSpi(key);
        }
        this.notifyPreferenceChange(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode() throws BackingStoreException {
        if (this.root == this) {
            throw new UnsupportedOperationException("Cannot remove root node");
        }
        Object object = this.parentPref.lock;
        synchronized (object) {
            this.removeNodeImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNodeImpl() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            AbstractPreferences[] children;
            String[] childrenNames;
            this.checkState();
            for (String childrenName : childrenNames = this.childrenNamesSpi()) {
                if (this.cachedNode.get(childrenName) != null) continue;
                AbstractPreferences child = this.childSpi(childrenName);
                this.cachedNode.put(childrenName, child);
            }
            Collection<AbstractPreferences> values = this.cachedNode.values();
            for (AbstractPreferences child : children = values.toArray(new AbstractPreferences[values.size()])) {
                child.removeNodeImpl();
            }
            this.removeNodeSpi();
            this.isRemoved = true;
            this.parentPref.cachedNode.remove(this.nodeName);
        }
        if (this.parentPref.nodeChangeListeners.size() > 0) {
            this.parentPref.notifyChildRemoved(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodeChangeListener(NodeChangeListener ncl) {
        if (ncl == null) {
            throw new NullPointerException("ncl == null");
        }
        this.checkState();
        List<EventListener> list = this.nodeChangeListeners;
        synchronized (list) {
            this.nodeChangeListeners.add(ncl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        if (pcl == null) {
            throw new NullPointerException("pcl == null");
        }
        this.checkState();
        List<EventListener> list = this.preferenceChangeListeners;
        synchronized (list) {
            this.preferenceChangeListeners.add(pcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeChangeListener(NodeChangeListener ncl) {
        this.checkState();
        List<EventListener> list = this.nodeChangeListeners;
        synchronized (list) {
            int pos = this.nodeChangeListeners.indexOf(ncl);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            this.nodeChangeListeners.remove(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
        this.checkState();
        List<EventListener> list = this.preferenceChangeListeners;
        synchronized (list) {
            int pos = this.preferenceChangeListeners.indexOf(pcl);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            this.preferenceChangeListeners.remove(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws BackingStoreException {
        AbstractPreferences[] abstractPreferencesArray = this.lock;
        synchronized (this.lock) {
            this.checkState();
            this.syncSpi();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (AbstractPreferences child : this.cachedChildren()) {
                child.sync();
            }
            return;
        }
    }

    @Override
    public String toString() {
        return (this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChildAdded(Preferences child) {
        NodeAddEvent nce = new NodeAddEvent(this, child);
        List<EventObject> list = events;
        synchronized (list) {
            events.add(nce);
            events.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChildRemoved(Preferences child) {
        NodeRemoveEvent nce = new NodeRemoveEvent(this, child);
        List<EventObject> list = events;
        synchronized (list) {
            events.add(nce);
            events.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPreferenceChange(String key, String newValue) {
        PreferenceChangeEvent pce = new PreferenceChangeEvent(this, key, newValue);
        List<EventObject> list = events;
        synchronized (list) {
            events.add(pce);
            events.notifyAll();
        }
    }

    static {
        dispatcher.setDaemon(true);
        dispatcher.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Preferences uroot = Preferences.userRoot();
                Preferences sroot = Preferences.systemRoot();
                try {
                    uroot.flush();
                }
                catch (BackingStoreException e) {
                    // empty catch block
                }
                try {
                    sroot.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
        });
    }

    private static class NodeRemoveEvent
    extends NodeChangeEvent {
        private static final long serialVersionUID = 1L;

        public NodeRemoveEvent(Preferences p, Preferences c) {
            super(p, c);
        }
    }

    private static class NodeAddEvent
    extends NodeChangeEvent {
        private static final long serialVersionUID = 1L;

        public NodeAddEvent(Preferences p, Preferences c) {
            super(p, c);
        }
    }

    private static class EventDispatcher
    extends Thread {
        EventDispatcher(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (true) {
                EventObject event;
                try {
                    event = this.getEventObject();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                AbstractPreferences pref = (AbstractPreferences)event.getSource();
                if (event instanceof NodeAddEvent) {
                    this.dispatchNodeAdd((NodeChangeEvent)event, pref.nodeChangeListeners);
                    continue;
                }
                if (event instanceof NodeRemoveEvent) {
                    this.dispatchNodeRemove((NodeChangeEvent)event, pref.nodeChangeListeners);
                    continue;
                }
                if (!(event instanceof PreferenceChangeEvent)) continue;
                this.dispatchPrefChange((PreferenceChangeEvent)event, pref.preferenceChangeListeners);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EventObject getEventObject() throws InterruptedException {
            List list = events;
            synchronized (list) {
                if (events.isEmpty()) {
                    events.wait();
                }
                EventObject event = (EventObject)events.get(0);
                events.remove(0);
                return event;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchPrefChange(PreferenceChangeEvent event, List<EventListener> preferenceChangeListeners) {
            List<EventListener> list = preferenceChangeListeners;
            synchronized (list) {
                for (EventListener preferenceChangeListener : preferenceChangeListeners) {
                    ((PreferenceChangeListener)preferenceChangeListener).preferenceChange(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchNodeRemove(NodeChangeEvent event, List<EventListener> nodeChangeListeners) {
            List<EventListener> list = nodeChangeListeners;
            synchronized (list) {
                for (EventListener nodeChangeListener : nodeChangeListeners) {
                    ((NodeChangeListener)nodeChangeListener).childRemoved(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchNodeAdd(NodeChangeEvent event, List<EventListener> nodeChangeListeners) {
            List<EventListener> list = nodeChangeListeners;
            synchronized (list) {
                for (EventListener nodeChangeListener : nodeChangeListeners) {
                    NodeChangeListener ncl = (NodeChangeListener)nodeChangeListener;
                    ncl.childAdded(event);
                }
            }
        }
    }
}

