/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class SocketHandler
extends StreamHandler {
    private static final String DEFAULT_LEVEL = "ALL";
    private static final String DEFAULT_FORMATTER = "java.util.logging.XMLFormatter";
    private Socket socket;

    public SocketHandler() throws IOException {
        super(DEFAULT_LEVEL, null, DEFAULT_FORMATTER, null);
        this.initSocket(LogManager.getLogManager().getProperty("java.util.logging.SocketHandler.host"), LogManager.getLogManager().getProperty("java.util.logging.SocketHandler.port"));
    }

    public SocketHandler(String host, int port) throws IOException {
        super(DEFAULT_LEVEL, null, DEFAULT_FORMATTER, null);
        this.initSocket(host, String.valueOf(port));
    }

    private void initSocket(String host, String port) throws IOException {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("host == null || host.isEmpty()");
        }
        int p = 0;
        try {
            p = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal port argument");
        }
        if (p <= 0) {
            throw new IllegalArgumentException("Illegal port argument");
        }
        try {
            this.socket = new Socket(host, p);
        }
        catch (IOException e) {
            this.getErrorManager().error("Failed to establish the network connection", e, 4);
            throw e;
        }
        super.internalSetOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
    }

    @Override
    public void close() {
        try {
            super.close();
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception e) {
            this.getErrorManager().error("Exception occurred when closing the socket handler", e, 3);
        }
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        super.flush();
    }
}

