/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.icu.TimeZoneNames;
import libcore.io.IoUtils;
import libcore.util.ZoneInfoDB;
import org.apache.harmony.luni.internal.util.TimezoneGetter;

public abstract class TimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3581463369166924961L;
    private static final Pattern CUSTOM_ZONE_ID_PATTERN = Pattern.compile("^GMT[-+](\\d{1,2})(:?(\\d\\d))?$");
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final TimeZone GMT = new SimpleTimeZone(0, "GMT");
    private static final TimeZone UTC = new SimpleTimeZone(0, "UTC");
    private static TimeZone defaultTimeZone;
    private String ID;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static synchronized String[] getAvailableIDs() {
        return ZoneInfoDB.getInstance().getAvailableIDs();
    }

    public static synchronized String[] getAvailableIDs(int offsetMillis) {
        return ZoneInfoDB.getInstance().getAvailableIDs(offsetMillis);
    }

    public static synchronized TimeZone getDefault() {
        if (defaultTimeZone == null) {
            String zoneName;
            TimezoneGetter tzGetter = TimezoneGetter.getInstance();
            String string = zoneName = tzGetter != null ? tzGetter.getId() : null;
            if (zoneName != null) {
                zoneName = zoneName.trim();
            }
            if (zoneName == null || zoneName.isEmpty()) {
                zoneName = ZoneInfoDB.getInstance().getDefaultID();
            }
            if (zoneName == null || zoneName.isEmpty()) {
                try {
                    zoneName = IoUtils.readFileAsString("/etc/timezone");
                }
                catch (IOException ex) {
                    zoneName = "GMT";
                }
            }
            defaultTimeZone = TimeZone.getTimeZone(zoneName);
        }
        return (TimeZone)defaultTimeZone.clone();
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean daylightTime, int style) {
        return this.getDisplayName(daylightTime, style, Locale.getDefault());
    }

    public String getDisplayName(boolean daylightTime, int style, Locale locale) {
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException("Bad style: " + style);
        }
        String[][] zoneStrings = TimeZoneNames.getZoneStrings(locale);
        String result = TimeZoneNames.getDisplayName(zoneStrings, this.getID(), daylightTime, style);
        if (result != null) {
            return result;
        }
        int offset = this.getRawOffset();
        if (daylightTime) {
            offset += this.getDSTSavings();
        }
        char sign = '+';
        if ((offset /= 60000) < 0) {
            sign = '-';
            offset = -offset;
        }
        StringBuilder builder = new StringBuilder(9);
        builder.append("GMT");
        builder.append(sign);
        this.appendNumber(builder, 2, offset / 60);
        builder.append(':');
        this.appendNumber(builder, 2, offset % 60);
        return builder.toString();
    }

    private void appendNumber(StringBuilder builder, int count, int value) {
        String string = Integer.toString(value);
        for (int i = 0; i < count - string.length(); ++i) {
            builder.append('0');
        }
        builder.append(string);
    }

    public String getID() {
        return this.ID;
    }

    public int getDSTSavings() {
        return this.useDaylightTime() ? 3600000 : 0;
    }

    public int getOffset(long time) {
        if (this.inDaylightTime(new Date(time))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public static synchronized TimeZone getTimeZone(String id) {
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        if (id.length() == 3) {
            if (id.equals("GMT")) {
                return (TimeZone)GMT.clone();
            }
            if (id.equals("UTC")) {
                return (TimeZone)UTC.clone();
            }
        }
        TimeZone zone = null;
        try {
            zone = ZoneInfoDB.getInstance().makeTimeZone(id);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (zone == null && id.length() > 3 && id.startsWith("GMT")) {
            zone = TimeZone.getCustomTimeZone(id);
        }
        return zone != null ? zone : (TimeZone)GMT.clone();
    }

    private static TimeZone getCustomTimeZone(String id) {
        int hour;
        Matcher m = CUSTOM_ZONE_ID_PATTERN.matcher(id);
        if (!m.matches()) {
            return null;
        }
        int minute = 0;
        try {
            hour = Integer.parseInt(m.group(1));
            if (m.group(3) != null) {
                minute = Integer.parseInt(m.group(3));
            }
        }
        catch (NumberFormatException impossible) {
            throw new AssertionError((Object)impossible);
        }
        if (hour < 0 || hour > 23 || minute < 0 || minute > 59) {
            return null;
        }
        char sign = id.charAt(3);
        int raw = hour * 3600000 + minute * 60000;
        if (sign == '-') {
            raw = -raw;
        }
        String cleanId = String.format("GMT%c%02d:%02d", Character.valueOf(sign), hour, minute);
        return new SimpleTimeZone(raw, cleanId);
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (timeZone == null) {
            return false;
        }
        return this.getRawOffset() == timeZone.getRawOffset();
    }

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized void setDefault(TimeZone timeZone) {
        defaultTimeZone = timeZone != null ? (TimeZone)timeZone.clone() : null;
    }

    public void setID(String id) {
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        this.ID = id;
    }

    public abstract void setRawOffset(int var1);

    public abstract boolean useDaylightTime();
}

