/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class HashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5024744406713321676L;
    transient HashMap<E, HashSet<E>> backingMap;

    public HashSet() {
        this(new HashMap());
    }

    public HashSet(int capacity) {
        this(new HashMap(capacity));
    }

    public HashSet(int capacity, float loadFactor) {
        this(new HashMap(capacity, loadFactor));
    }

    public HashSet(Collection<? extends E> collection) {
        this(new HashMap(collection.size() < 6 ? 11 : collection.size() * 2));
        for (E e : collection) {
            this.add(e);
        }
    }

    HashSet(HashMap<E, HashSet<E>> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    public boolean add(E object) {
        return this.backingMap.put(object, this) == null;
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    public Object clone() {
        try {
            HashSet clone = (HashSet)super.clone();
            clone.backingMap = (HashMap)this.backingMap.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.backingMap.remove(object) != null;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.backingMap.table.length);
        stream.writeFloat(0.75f);
        stream.writeInt(this.size());
        for (E e : this) {
            stream.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int elementCount;
        stream.defaultReadObject();
        int length = stream.readInt();
        float loadFactor = stream.readFloat();
        this.backingMap = this.createBackingMap(length, loadFactor);
        int i = elementCount = stream.readInt();
        while (--i >= 0) {
            Object key = stream.readObject();
            this.backingMap.put(key, this);
        }
    }

    HashMap<E, HashSet<E>> createBackingMap(int capacity, float loadFactor) {
        return new HashMap(capacity, loadFactor);
    }
}

