/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Arrays;

public class BitSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7997698588986878753L;
    private static final long ALL_ONES = -1L;
    private long[] bits;
    private transient int longCount;

    private void shrinkSize() {
        int i;
        for (i = this.longCount - 1; i >= 0 && this.bits[i] == 0L; --i) {
        }
        this.longCount = i + 1;
    }

    public BitSet() {
        this(new long[1]);
    }

    public BitSet(int bitCount) {
        if (bitCount < 0) {
            throw new NegativeArraySizeException(Integer.toString(bitCount));
        }
        this.bits = BitSet.arrayForBits(bitCount);
        this.longCount = 0;
    }

    private BitSet(long[] bits) {
        this.bits = bits;
        this.longCount = bits.length;
        this.shrinkSize();
    }

    private static long[] arrayForBits(int bitCount) {
        return new long[(bitCount + 63) / 64];
    }

    public Object clone() {
        try {
            BitSet clone = (BitSet)super.clone();
            clone.bits = (long[])this.bits.clone();
            clone.shrinkSize();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BitSet)) {
            return false;
        }
        BitSet lhs = (BitSet)o;
        if (this.longCount != lhs.longCount) {
            return false;
        }
        for (int i = 0; i < this.longCount; ++i) {
            if (this.bits[i] == lhs.bits[i]) continue;
            return false;
        }
        return true;
    }

    private void ensureCapacity(int desiredLongCount) {
        if (desiredLongCount <= this.bits.length) {
            return;
        }
        int newLength = Math.max(desiredLongCount, this.bits.length * 2);
        long[] newBits = new long[newLength];
        System.arraycopy((Object)this.bits, 0, (Object)newBits, 0, this.longCount);
        this.bits = newBits;
    }

    public int hashCode() {
        long x = 1234L;
        for (int i = 0; i < this.longCount; ++i) {
            x ^= this.bits[i] * (long)(i + 1);
        }
        return (int)(x >> 32 ^ x);
    }

    public boolean get(int index) {
        int arrayIndex;
        if (index < 0) {
            this.checkIndex(index);
        }
        if ((arrayIndex = index / 64) >= this.longCount) {
            return false;
        }
        return (this.bits[arrayIndex] & 1L << index) != 0L;
    }

    public void set(int index) {
        int arrayIndex;
        if (index < 0) {
            this.checkIndex(index);
        }
        if ((arrayIndex = index / 64) >= this.bits.length) {
            this.ensureCapacity(arrayIndex + 1);
        }
        int n = arrayIndex;
        this.bits[n] = this.bits[n] | 1L << index;
        this.longCount = Math.max(this.longCount, arrayIndex + 1);
    }

    public void clear(int index) {
        int arrayIndex;
        if (index < 0) {
            this.checkIndex(index);
        }
        if ((arrayIndex = index / 64) >= this.longCount) {
            return;
        }
        int n = arrayIndex;
        this.bits[n] = this.bits[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
        this.shrinkSize();
    }

    public void flip(int index) {
        int arrayIndex;
        if (index < 0) {
            this.checkIndex(index);
        }
        if ((arrayIndex = index / 64) >= this.bits.length) {
            this.ensureCapacity(arrayIndex + 1);
        }
        int n = arrayIndex;
        this.bits[n] = this.bits[n] ^ 1L << index;
        this.longCount = Math.max(this.longCount, arrayIndex + 1);
        this.shrinkSize();
    }

    private void checkIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0: " + index);
        }
    }

    private void checkRange(int fromIndex, int toIndex) {
        if ((fromIndex | toIndex) < 0 || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("fromIndex=" + fromIndex + " toIndex=" + toIndex);
        }
    }

    public BitSet get(int fromIndex, int toIndex) {
        this.checkRange(fromIndex, toIndex);
        int last = 64 * this.longCount;
        if (fromIndex >= last || fromIndex == toIndex) {
            return new BitSet(0);
        }
        if (toIndex > last) {
            toIndex = last;
        }
        int firstArrayIndex = fromIndex / 64;
        int lastArrayIndex = (toIndex - 1) / 64;
        long lowMask = -1L << fromIndex;
        long highMask = -1L >>> -toIndex;
        if (firstArrayIndex == lastArrayIndex) {
            long result = (this.bits[firstArrayIndex] & (lowMask & highMask)) >>> fromIndex;
            if (result == 0L) {
                return new BitSet(0);
            }
            return new BitSet(new long[]{result});
        }
        long[] newBits = new long[lastArrayIndex - firstArrayIndex + 1];
        newBits[0] = this.bits[firstArrayIndex] & lowMask;
        newBits[newBits.length - 1] = this.bits[lastArrayIndex] & highMask;
        for (int i = 1; i < lastArrayIndex - firstArrayIndex; ++i) {
            newBits[i] = this.bits[firstArrayIndex + i];
        }
        int numBitsToShift = fromIndex % 64;
        int actualLen = newBits.length;
        if (numBitsToShift != 0) {
            for (int i = 0; i < newBits.length; ++i) {
                newBits[i] = newBits[i] >>> numBitsToShift;
                if (i != newBits.length - 1) {
                    int n = i;
                    newBits[n] = newBits[n] | newBits[i + 1] << -numBitsToShift;
                }
                if (newBits[i] == 0L) continue;
                actualLen = i + 1;
            }
        }
        return new BitSet(newBits);
    }

    public void set(int index, boolean state) {
        if (state) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public void set(int fromIndex, int toIndex, boolean state) {
        if (state) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public void clear() {
        Arrays.fill(this.bits, 0, this.longCount, 0L);
        this.longCount = 0;
    }

    public void set(int fromIndex, int toIndex) {
        this.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int firstArrayIndex = fromIndex / 64;
        int lastArrayIndex = (toIndex - 1) / 64;
        if (lastArrayIndex >= this.bits.length) {
            this.ensureCapacity(lastArrayIndex + 1);
        }
        long lowMask = -1L << fromIndex;
        long highMask = -1L >>> -toIndex;
        if (firstArrayIndex == lastArrayIndex) {
            int n = firstArrayIndex;
            this.bits[n] = this.bits[n] | lowMask & highMask;
        } else {
            int i = firstArrayIndex;
            int n = i++;
            this.bits[n] = this.bits[n] | lowMask;
            while (i < lastArrayIndex) {
                int n2 = i++;
                this.bits[n2] = this.bits[n2] | 0xFFFFFFFFFFFFFFFFL;
            }
            int n3 = i++;
            this.bits[n3] = this.bits[n3] | highMask;
        }
        this.longCount = Math.max(this.longCount, lastArrayIndex + 1);
    }

    public void clear(int fromIndex, int toIndex) {
        this.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex || this.longCount == 0) {
            return;
        }
        int last = 64 * this.longCount;
        if (fromIndex >= last) {
            return;
        }
        if (toIndex > last) {
            toIndex = last;
        }
        int firstArrayIndex = fromIndex / 64;
        int lastArrayIndex = (toIndex - 1) / 64;
        long lowMask = -1L << fromIndex;
        long highMask = -1L >>> -toIndex;
        if (firstArrayIndex == lastArrayIndex) {
            int n = firstArrayIndex;
            this.bits[n] = this.bits[n] & (lowMask & highMask ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            int i = firstArrayIndex;
            int n = i++;
            this.bits[n] = this.bits[n] & (lowMask ^ 0xFFFFFFFFFFFFFFFFL);
            while (i < lastArrayIndex) {
                this.bits[i++] = 0L;
            }
            int n2 = i++;
            this.bits[n2] = this.bits[n2] & (highMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.shrinkSize();
    }

    public void flip(int fromIndex, int toIndex) {
        this.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int firstArrayIndex = fromIndex / 64;
        int lastArrayIndex = (toIndex - 1) / 64;
        if (lastArrayIndex >= this.bits.length) {
            this.ensureCapacity(lastArrayIndex + 1);
        }
        long lowMask = -1L << fromIndex;
        long highMask = -1L >>> -toIndex;
        if (firstArrayIndex == lastArrayIndex) {
            int n = firstArrayIndex;
            this.bits[n] = this.bits[n] ^ lowMask & highMask;
        } else {
            int i = firstArrayIndex;
            int n = i++;
            this.bits[n] = this.bits[n] ^ lowMask;
            while (i < lastArrayIndex) {
                int n2 = i++;
                this.bits[n2] = this.bits[n2] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            int n3 = i++;
            this.bits[n3] = this.bits[n3] ^ highMask;
        }
        this.longCount = Math.max(this.longCount, lastArrayIndex + 1);
        this.shrinkSize();
    }

    public boolean intersects(BitSet bs) {
        long[] bsBits = bs.bits;
        int length = Math.min(this.longCount, bs.longCount);
        for (int i = 0; i < length; ++i) {
            if ((this.bits[i] & bsBits[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public void and(BitSet bs) {
        int minSize = Math.min(this.longCount, bs.longCount);
        for (int i = 0; i < minSize; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & bs.bits[i];
        }
        Arrays.fill(this.bits, minSize, this.longCount, 0L);
        this.shrinkSize();
    }

    public void andNot(BitSet bs) {
        int minSize = Math.min(this.longCount, bs.longCount);
        for (int i = 0; i < minSize; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & (bs.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.shrinkSize();
    }

    public void or(BitSet bs) {
        int minSize = Math.min(this.longCount, bs.longCount);
        int maxSize = Math.max(this.longCount, bs.longCount);
        this.ensureCapacity(maxSize);
        for (int i = 0; i < minSize; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | bs.bits[i];
        }
        if (bs.longCount > minSize) {
            System.arraycopy((Object)bs.bits, minSize, (Object)this.bits, minSize, maxSize - minSize);
        }
        this.longCount = maxSize;
    }

    public void xor(BitSet bs) {
        int minSize = Math.min(this.longCount, bs.longCount);
        int maxSize = Math.max(this.longCount, bs.longCount);
        this.ensureCapacity(maxSize);
        for (int i = 0; i < minSize; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ bs.bits[i];
        }
        if (bs.longCount > minSize) {
            System.arraycopy((Object)bs.bits, minSize, (Object)this.bits, minSize, maxSize - minSize);
        }
        this.longCount = maxSize;
        this.shrinkSize();
    }

    public int size() {
        return this.bits.length * 64;
    }

    public int length() {
        if (this.longCount == 0) {
            return 0;
        }
        return 64 * (this.longCount - 1) + (64 - Long.numberOfLeadingZeros(this.bits[this.longCount - 1]));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.longCount / 2);
        sb.append('{');
        boolean comma = false;
        for (int i = 0; i < this.longCount; ++i) {
            if (this.bits[i] == 0L) continue;
            for (int j = 0; j < 64; ++j) {
                if ((this.bits[i] & 1L << j) == 0L) continue;
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(64 * i + j);
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public int nextSetBit(int index) {
        this.checkIndex(index);
        int arrayIndex = index / 64;
        if (arrayIndex >= this.longCount) {
            return -1;
        }
        long mask = -1L << index;
        if ((this.bits[arrayIndex] & mask) != 0L) {
            return 64 * arrayIndex + Long.numberOfTrailingZeros(this.bits[arrayIndex] & mask);
        }
        while (++arrayIndex < this.longCount && this.bits[arrayIndex] == 0L) {
        }
        if (arrayIndex == this.longCount) {
            return -1;
        }
        return 64 * arrayIndex + Long.numberOfTrailingZeros(this.bits[arrayIndex]);
    }

    public int nextClearBit(int index) {
        this.checkIndex(index);
        int arrayIndex = index / 64;
        if (arrayIndex >= this.longCount) {
            return index;
        }
        long mask = -1L << index;
        if (((this.bits[arrayIndex] ^ 0xFFFFFFFFFFFFFFFFL) & mask) != 0L) {
            return 64 * arrayIndex + Long.numberOfTrailingZeros((this.bits[arrayIndex] ^ 0xFFFFFFFFFFFFFFFFL) & mask);
        }
        while (++arrayIndex < this.longCount && this.bits[arrayIndex] == -1L) {
        }
        if (arrayIndex == this.longCount) {
            return 64 * this.longCount;
        }
        return 64 * arrayIndex + Long.numberOfTrailingZeros(this.bits[arrayIndex] ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int previousSetBit(int index) {
        if (index == -1) {
            return -1;
        }
        this.checkIndex(index);
        for (int i = index; i >= 0; --i) {
            if (!this.get(i)) continue;
            return i;
        }
        return -1;
    }

    public int previousClearBit(int index) {
        if (index == -1) {
            return -1;
        }
        this.checkIndex(index);
        for (int i = index; i >= 0; --i) {
            if (this.get(i)) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.longCount == 0;
    }

    public int cardinality() {
        int result = 0;
        for (int i = 0; i < this.longCount; ++i) {
            result += Long.bitCount(this.bits[i]);
        }
        return result;
    }

    public static BitSet valueOf(long[] longs) {
        return new BitSet((long[])longs.clone());
    }

    public static BitSet valueOf(LongBuffer longBuffer) {
        long[] longs = new long[longBuffer.remaining()];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = longBuffer.get(longBuffer.position() + i);
        }
        return BitSet.valueOf(longs);
    }

    public static BitSet valueOf(byte[] bytes) {
        return BitSet.valueOf(ByteBuffer.wrap(bytes));
    }

    public static BitSet valueOf(ByteBuffer byteBuffer) {
        byteBuffer = byteBuffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        long[] longs = BitSet.arrayForBits(byteBuffer.remaining() * 8);
        int i = 0;
        while (byteBuffer.remaining() >= 8) {
            longs[i++] = byteBuffer.getLong();
        }
        int j = 0;
        while (byteBuffer.hasRemaining()) {
            int n = i;
            longs[n] = longs[n] | ((long)byteBuffer.get() & 0xFFL) << 8 * j;
            ++j;
        }
        return BitSet.valueOf(longs);
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.bits, this.longCount);
    }

    public byte[] toByteArray() {
        int bitCount = this.length();
        byte[] result = new byte[(bitCount + 7) / 8];
        for (int i = 0; i < result.length; ++i) {
            int lowBit = 8 * i;
            int arrayIndex = lowBit / 64;
            result[i] = (byte)(this.bits[arrayIndex] >>> lowBit);
        }
        return result;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.longCount = this.bits.length;
        this.shrinkSize();
    }
}

