/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import libcore.util.EmptyArray;

public class ArrayList<E>
extends AbstractList<E>
implements Cloneable,
Serializable,
RandomAccess {
    private static final int MIN_CAPACITY_INCREMENT = 12;
    int size;
    transient Object[] array;
    private static final long serialVersionUID = 8683452581122892189L;

    public ArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        this.array = capacity == 0 ? EmptyArray.OBJECT : new Object[capacity];
    }

    public ArrayList() {
        this.array = EmptyArray.OBJECT;
    }

    public ArrayList(Collection<? extends E> collection) {
        if (collection == null) {
            throw new NullPointerException("collection == null");
        }
        Object[] a = collection.toArray();
        if (a.getClass() != Object[].class) {
            Object[] newArray = new Object[a.length];
            System.arraycopy((Object)a, 0, (Object)newArray, 0, a.length);
            a = newArray;
        }
        this.array = a;
        this.size = a.length;
    }

    @Override
    public boolean add(E object) {
        int s = this.size;
        Object[] a = this.array;
        if (s == a.length) {
            Object[] newArray = new Object[s + (s < 6 ? 12 : s >> 1)];
            System.arraycopy((Object)a, 0, (Object)newArray, 0, s);
            a = newArray;
            this.array = newArray;
        }
        a[s] = object;
        this.size = s + 1;
        ++this.modCount;
        return true;
    }

    @Override
    public void add(int index, E object) {
        Object[] a = this.array;
        int s = this.size;
        if (index > s || index < 0) {
            ArrayList.throwIndexOutOfBoundsException(index, s);
        }
        if (s < a.length) {
            System.arraycopy((Object)a, index, (Object)a, index + 1, s - index);
        } else {
            Object[] newArray = new Object[ArrayList.newCapacity(s)];
            System.arraycopy((Object)a, 0, (Object)newArray, 0, index);
            System.arraycopy((Object)a, index, (Object)newArray, index + 1, s - index);
            a = newArray;
            this.array = newArray;
        }
        a[index] = object;
        this.size = s + 1;
        ++this.modCount;
    }

    private static int newCapacity(int currentCapacity) {
        int increment = currentCapacity < 6 ? 12 : currentCapacity >> 1;
        return currentCapacity + increment;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] newPart = collection.toArray();
        int newPartSize = newPart.length;
        if (newPartSize == 0) {
            return false;
        }
        int s = this.size;
        int newSize = s + newPartSize;
        Object[] a = this.array;
        if (newSize > a.length) {
            int newCapacity = ArrayList.newCapacity(newSize - 1);
            Object[] newArray = new Object[newCapacity];
            System.arraycopy((Object)a, 0, (Object)newArray, 0, s);
            a = newArray;
            this.array = newArray;
        }
        System.arraycopy((Object)newPart, 0, (Object)a, s, newPartSize);
        this.size = newSize;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        Object[] newPart;
        int newPartSize;
        int s = this.size;
        if (index > s || index < 0) {
            ArrayList.throwIndexOutOfBoundsException(index, s);
        }
        if ((newPartSize = (newPart = collection.toArray()).length) == 0) {
            return false;
        }
        int newSize = s + newPartSize;
        Object[] a = this.array;
        if (newSize <= a.length) {
            System.arraycopy((Object)a, index, (Object)a, index + newPartSize, s - index);
        } else {
            int newCapacity = ArrayList.newCapacity(newSize - 1);
            Object[] newArray = new Object[newCapacity];
            System.arraycopy((Object)a, 0, (Object)newArray, 0, index);
            System.arraycopy((Object)a, index, (Object)newArray, index + newPartSize, s - index);
            a = newArray;
            this.array = newArray;
        }
        System.arraycopy((Object)newPart, 0, (Object)a, index, newPartSize);
        this.size = newSize;
        ++this.modCount;
        return true;
    }

    static IndexOutOfBoundsException throwIndexOutOfBoundsException(int index, int size) {
        throw new IndexOutOfBoundsException("Invalid index " + index + ", size is " + size);
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            Arrays.fill(this.array, 0, this.size, null);
            this.size = 0;
            ++this.modCount;
        }
    }

    public Object clone() {
        try {
            ArrayList result = (ArrayList)super.clone();
            result.array = (Object[])this.array.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        Object[] a = this.array;
        if (a.length < minimumCapacity) {
            Object[] newArray = new Object[minimumCapacity];
            System.arraycopy((Object)a, 0, (Object)newArray, 0, this.size);
            this.array = newArray;
            ++this.modCount;
        }
    }

    @Override
    public E get(int index) {
        if (index >= this.size) {
            ArrayList.throwIndexOutOfBoundsException(index, this.size);
        }
        return (E)this.array[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        Object[] a = this.array;
        int s = this.size;
        if (object != null) {
            for (int i = 0; i < s; ++i) {
                if (!object.equals(a[i])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < s; ++i) {
                if (a[i] != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int indexOf(Object object) {
        Object[] a = this.array;
        int s = this.size;
        if (object != null) {
            for (int i = 0; i < s; ++i) {
                if (!object.equals(a[i])) continue;
                return i;
            }
        } else {
            for (int i = 0; i < s; ++i) {
                if (a[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        Object[] a = this.array;
        if (object != null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!object.equals(a[i])) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (a[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public E remove(int index) {
        Object[] a = this.array;
        int s = this.size;
        if (index >= s) {
            ArrayList.throwIndexOutOfBoundsException(index, s);
        }
        Object result = a[index];
        System.arraycopy((Object)a, index + 1, (Object)a, index, --s - index);
        a[s] = null;
        this.size = s;
        ++this.modCount;
        return (E)result;
    }

    @Override
    public boolean remove(Object object) {
        Object[] a = this.array;
        int s = this.size;
        if (object != null) {
            for (int i = 0; i < s; ++i) {
                if (!object.equals(a[i])) continue;
                System.arraycopy((Object)a, i + 1, (Object)a, i, --s - i);
                a[s] = null;
                this.size = s;
                ++this.modCount;
                return true;
            }
        } else {
            for (int i = 0; i < s; ++i) {
                if (a[i] != null) continue;
                System.arraycopy((Object)a, i + 1, (Object)a, i, --s - i);
                a[s] = null;
                this.size = s;
                ++this.modCount;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        Object[] a = this.array;
        int s = this.size;
        if (fromIndex >= s) {
            throw new IndexOutOfBoundsException("fromIndex " + fromIndex + " >= size " + this.size);
        }
        if (toIndex > s) {
            throw new IndexOutOfBoundsException("toIndex " + toIndex + " > size " + this.size);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex " + fromIndex + " > toIndex " + toIndex);
        }
        System.arraycopy((Object)a, toIndex, (Object)a, fromIndex, s - toIndex);
        int rangeSize = toIndex - fromIndex;
        Arrays.fill(a, s - rangeSize, s, null);
        this.size = s - rangeSize;
        ++this.modCount;
    }

    @Override
    public E set(int index, E object) {
        Object[] a = this.array;
        if (index >= this.size) {
            ArrayList.throwIndexOutOfBoundsException(index, this.size);
        }
        Object result = a[index];
        a[index] = object;
        return (E)result;
    }

    @Override
    public Object[] toArray() {
        int s = this.size;
        Object[] result = new Object[s];
        System.arraycopy((Object)this.array, 0, (Object)result, 0, s);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] contents) {
        int s = this.size;
        if (contents.length < s) {
            Object[] newArray = (Object[])Array.newInstance(contents.getClass().getComponentType(), s);
            contents = newArray;
        }
        System.arraycopy((Object)this.array, 0, contents, 0, s);
        if (contents.length > s) {
            contents[s] = null;
        }
        return contents;
    }

    public void trimToSize() {
        int s = this.size;
        if (s == this.array.length) {
            return;
        }
        if (s == 0) {
            this.array = EmptyArray.OBJECT;
        } else {
            Object[] newArray = new Object[s];
            System.arraycopy((Object)this.array, 0, (Object)newArray, 0, s);
            this.array = newArray;
        }
        ++this.modCount;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayListIterator();
    }

    @Override
    public int hashCode() {
        Object[] a = this.array;
        int hashCode = 1;
        int s = this.size;
        for (int i = 0; i < s; ++i) {
            Object e = a[i];
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List that = (List)o;
        int s = this.size;
        if (that.size() != s) {
            return false;
        }
        Object[] a = this.array;
        if (that instanceof RandomAccess) {
            for (int i = 0; i < s; ++i) {
                Object eThis = a[i];
                Object ethat = that.get(i);
                if (!(eThis == null ? ethat != null : !eThis.equals(ethat))) continue;
                return false;
            }
        } else {
            Iterator it = that.iterator();
            for (int i = 0; i < s; ++i) {
                Object eThis = a[i];
                Object eThat = it.next();
                if (!(eThis == null ? eThat != null : !eThis.equals(eThat))) continue;
                return false;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.array.length);
        for (int i = 0; i < this.size; ++i) {
            stream.writeObject(this.array[i]);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int cap = stream.readInt();
        if (cap < this.size) {
            throw new InvalidObjectException("Capacity: " + cap + " < size: " + this.size);
        }
        this.array = cap == 0 ? EmptyArray.OBJECT : new Object[cap];
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = stream.readObject();
        }
    }

    private class ArrayListIterator
    implements Iterator<E> {
        private int remaining;
        private int removalIndex;
        private int expectedModCount;

        private ArrayListIterator() {
            this.remaining = ArrayList.this.size;
            this.removalIndex = -1;
            this.expectedModCount = ArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.remaining != 0;
        }

        @Override
        public E next() {
            ArrayList ourList = ArrayList.this;
            int rem = this.remaining;
            if (ourList.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (rem == 0) {
                throw new NoSuchElementException();
            }
            this.remaining = rem - 1;
            this.removalIndex = ourList.size - rem;
            return ourList.array[this.removalIndex];
        }

        @Override
        public void remove() {
            Object[] a = ArrayList.this.array;
            int removalIdx = this.removalIndex;
            if (ArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (removalIdx < 0) {
                throw new IllegalStateException();
            }
            System.arraycopy((Object)a, removalIdx + 1, (Object)a, removalIdx, this.remaining);
            a[--ArrayList.this.size] = null;
            this.removalIndex = -1;
            this.expectedModCount = ++ArrayList.this.modCount;
        }
    }
}

