/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Queue;

public abstract class AbstractQueue<E>
extends AbstractCollection<E>
implements Queue<E> {
    protected AbstractQueue() {
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue full");
    }

    @Override
    public E remove() {
        Object x = this.poll();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E element() {
        Object x = this.peek();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException("c == null");
        }
        if (c == this) {
            throw new IllegalArgumentException("c == this");
        }
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }
}

