/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CollationKey;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import libcore.icu.ICU;
import libcore.icu.RuleBasedCollatorICU;

public abstract class Collator
implements Comparator<Object>,
Cloneable {
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    RuleBasedCollatorICU icuColl;

    Collator(RuleBasedCollatorICU icuColl) {
        this.icuColl = icuColl;
    }

    protected Collator() {
        this.icuColl = new RuleBasedCollatorICU(Locale.getDefault());
    }

    public Object clone() {
        try {
            Collator clone = (Collator)super.clone();
            clone.icuColl = (RuleBasedCollatorICU)this.icuColl.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int compare(Object object1, Object object2) {
        return this.compare((String)object1, (String)object2);
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Collator)) {
            return false;
        }
        Collator collator = (Collator)object;
        return this.icuColl == null ? collator.icuColl == null : this.icuColl.equals(collator.icuColl);
    }

    public boolean equals(String string1, String string2) {
        return this.compare(string1, string2) == 0;
    }

    public static Locale[] getAvailableLocales() {
        return ICU.getAvailableCollatorLocales();
    }

    public abstract CollationKey getCollationKey(String var1);

    public int getDecomposition() {
        return this.decompositionMode_ICU_Java(this.icuColl.getDecomposition());
    }

    public static Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static Collator getInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        return new RuleBasedCollator(new RuleBasedCollatorICU(locale));
    }

    public int getStrength() {
        return this.strength_ICU_Java(this.icuColl.getStrength());
    }

    public abstract int hashCode();

    public void setDecomposition(int value) {
        this.icuColl.setDecomposition(this.decompositionMode_Java_ICU(value));
    }

    public void setStrength(int value) {
        this.icuColl.setStrength(this.strength_Java_ICU(value));
    }

    private int decompositionMode_Java_ICU(int mode) {
        switch (mode) {
            case 1: {
                return 17;
            }
            case 0: {
                return 16;
            }
        }
        throw new IllegalArgumentException("Bad mode: " + mode);
    }

    private int decompositionMode_ICU_Java(int mode) {
        int javaMode = mode;
        switch (mode) {
            case 16: {
                javaMode = 0;
                break;
            }
            case 17: {
                javaMode = 1;
            }
        }
        return javaMode;
    }

    private int strength_Java_ICU(int value) {
        switch (value) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Bad strength: " + value);
    }

    private int strength_ICU_Java(int value) {
        int javaValue = value;
        switch (value) {
            case 0: {
                javaValue = 0;
                break;
            }
            case 1: {
                javaValue = 1;
                break;
            }
            case 2: {
                javaValue = 2;
                break;
            }
            case 15: {
                javaValue = 3;
            }
        }
        return javaValue;
    }
}

