/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509Extension;
import java.util.Arrays;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public abstract class X509CRLEntry
implements X509Extension {
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof X509CRLEntry)) {
            return false;
        }
        X509CRLEntry obj = (X509CRLEntry)other;
        try {
            return Arrays.equals(this.getEncoded(), obj.getEncoded());
        }
        catch (CRLException e) {
            return false;
        }
    }

    public int hashCode() {
        int res = 0;
        try {
            byte[] array = this.getEncoded();
            for (int i = 0; i < array.length; ++i) {
                res += array[i] & 0xFF;
            }
        }
        catch (CRLException cRLException) {
            // empty catch block
        }
        return res;
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract BigInteger getSerialNumber();

    public X500Principal getCertificateIssuer() {
        return null;
    }

    public abstract Date getRevocationDate();

    public abstract boolean hasExtensions();

    public abstract String toString();
}

