/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public abstract class SignatureSpi {
    protected SecureRandom appRandom;

    protected abstract void engineInitVerify(PublicKey var1) throws InvalidKeyException;

    protected abstract void engineInitSign(PrivateKey var1) throws InvalidKeyException;

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.appRandom = random;
        this.engineInitSign(privateKey);
    }

    protected abstract void engineUpdate(byte var1) throws SignatureException;

    protected abstract void engineUpdate(byte[] var1, int var2, int var3) throws SignatureException;

    protected void engineUpdate(ByteBuffer input) {
        if (!input.hasRemaining()) {
            return;
        }
        if (input.hasArray()) {
            byte[] tmp = input.array();
            int offset = input.arrayOffset();
            int position = input.position();
            int limit = input.limit();
            try {
                this.engineUpdate(tmp, offset + position, limit - position);
            }
            catch (SignatureException e) {
                throw new RuntimeException(e);
            }
            input.position(limit);
        } else {
            byte[] tmp = new byte[input.limit() - input.position()];
            input.get(tmp);
            try {
                this.engineUpdate(tmp, 0, tmp.length);
            }
            catch (SignatureException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected abstract byte[] engineSign() throws SignatureException;

    protected int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        byte[] tmp = this.engineSign();
        if (tmp == null) {
            return 0;
        }
        if (len < tmp.length) {
            throw new SignatureException("The value of len parameter is less than the actual signature length");
        }
        if (offset < 0) {
            throw new SignatureException("offset < 0");
        }
        if (offset + len > outbuf.length) {
            throw new SignatureException("offset + len > outbuf.length");
        }
        System.arraycopy((Object)tmp, 0, (Object)outbuf, offset, tmp.length);
        return tmp.length;
    }

    protected abstract boolean engineVerify(byte[] var1) throws SignatureException;

    protected boolean engineVerify(byte[] sigBytes, int offset, int length) throws SignatureException {
        byte[] tmp = new byte[length];
        System.arraycopy((Object)sigBytes, offset, (Object)tmp, 0, length);
        return this.engineVerify(tmp);
    }

    @Deprecated
    protected abstract void engineSetParameter(String var1, Object var2) throws InvalidParameterException;

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    protected AlgorithmParameters engineGetParameters() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected abstract Object engineGetParameter(String var1) throws InvalidParameterException;

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }
}

