/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.apache.harmony.security.fortress.Engine;

public abstract class MessageDigest
extends MessageDigestSpi {
    private static final Engine ENGINE = new Engine("MessageDigest");
    private Provider provider;
    private String algorithm;

    protected MessageDigest(String algorithm) {
        this.algorithm = algorithm;
    }

    public static MessageDigest getInstance(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        Engine.SpiAndProvider sap = ENGINE.getInstance(algorithm, null);
        Object spi = sap.spi;
        Provider provider = sap.provider;
        if (spi instanceof MessageDigest) {
            MessageDigest result = (MessageDigest)spi;
            result.algorithm = algorithm;
            result.provider = provider;
            return result;
        }
        return new MessageDigestImpl((MessageDigestSpi)sap.spi, sap.provider, algorithm);
    }

    public static MessageDigest getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return MessageDigest.getInstance(algorithm, p);
    }

    public static MessageDigest getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        Object spi = ENGINE.getInstance(algorithm, provider, null);
        if (spi instanceof MessageDigest) {
            MessageDigest result = (MessageDigest)spi;
            result.algorithm = algorithm;
            result.provider = provider;
            return result;
        }
        return new MessageDigestImpl((MessageDigestSpi)spi, provider, algorithm);
    }

    public void reset() {
        this.engineReset();
    }

    public void update(byte arg0) {
        this.engineUpdate(arg0);
    }

    public void update(byte[] input, int offset, int len) {
        if (input == null || (long)offset + (long)len > (long)input.length) {
            throw new IllegalArgumentException();
        }
        this.engineUpdate(input, offset, len);
    }

    public void update(byte[] input) {
        if (input == null) {
            throw new NullPointerException("input == null");
        }
        this.engineUpdate(input, 0, input.length);
    }

    public byte[] digest() {
        return this.engineDigest();
    }

    public int digest(byte[] buf, int offset, int len) throws DigestException {
        if (buf == null || (long)offset + (long)len > (long)buf.length) {
            throw new IllegalArgumentException();
        }
        return this.engineDigest(buf, offset, len);
    }

    public byte[] digest(byte[] input) {
        this.update(input);
        return this.digest();
    }

    public String toString() {
        return "MESSAGE DIGEST " + this.algorithm;
    }

    public static boolean isEqual(byte[] digesta, byte[] digestb) {
        if (digesta.length != digestb.length) {
            return false;
        }
        for (int i = 0; i < digesta.length; ++i) {
            if (digesta[i] == digestb[i]) continue;
            return false;
        }
        return true;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final int getDigestLength() {
        int l = this.engineGetDigestLength();
        if (l != 0) {
            return l;
        }
        if (!(this instanceof Cloneable)) {
            return 0;
        }
        try {
            MessageDigest md = (MessageDigest)this.clone();
            return md.digest().length;
        }
        catch (CloneNotSupportedException e) {
            return 0;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    public final void update(ByteBuffer input) {
        this.engineUpdate(input);
    }

    private static class MessageDigestImpl
    extends MessageDigest {
        private MessageDigestSpi spiImpl;

        private MessageDigestImpl(MessageDigestSpi messageDigestSpi, Provider provider, String algorithm) {
            super(algorithm);
            ((MessageDigest)this).provider = provider;
            this.spiImpl = messageDigestSpi;
        }

        @Override
        protected void engineReset() {
            this.spiImpl.engineReset();
        }

        @Override
        protected byte[] engineDigest() {
            return this.spiImpl.engineDigest();
        }

        @Override
        protected int engineGetDigestLength() {
            return this.spiImpl.engineGetDigestLength();
        }

        @Override
        protected void engineUpdate(byte arg0) {
            this.spiImpl.engineUpdate(arg0);
        }

        @Override
        protected void engineUpdate(byte[] arg0, int arg1, int arg2) {
            this.spiImpl.engineUpdate(arg0, arg1, arg2);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            if (this.spiImpl instanceof Cloneable) {
                MessageDigestSpi spi = (MessageDigestSpi)this.spiImpl.clone();
                return new MessageDigestImpl(spi, this.getProvider(), this.getAlgorithm());
            }
            throw new CloneNotSupportedException();
        }
    }
}

