/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.OsConstants;

public final class NetworkInterface {
    private static final boolean DARWIN;
    private final String name;
    private final int interfaceIndex;
    private final List<InterfaceAddress> interfaceAddresses;
    private final List<InetAddress> addresses;
    private final List<NetworkInterface> children = new LinkedList<NetworkInterface>();
    private NetworkInterface parent = null;

    private NetworkInterface(String name, int interfaceIndex, List<InetAddress> addresses, List<InterfaceAddress> interfaceAddresses) {
        this.name = name;
        this.interfaceIndex = interfaceIndex;
        this.addresses = addresses;
        this.interfaceAddresses = interfaceAddresses;
    }

    static NetworkInterface forUnboundMulticastSocket() {
        return new NetworkInterface(null, -1, Arrays.asList(Inet6Address.ANY), Collections.emptyList());
    }

    public int getIndex() {
        return this.interfaceIndex;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        return Collections.enumeration(this.addresses);
    }

    public String getDisplayName() {
        return this.name;
    }

    public static NetworkInterface getByName(String interfaceName) throws SocketException {
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName == null");
        }
        int interfaceIndex = NetworkInterface.getInterfaceIndex(interfaceName);
        if (interfaceIndex <= 0) {
            return null;
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        ArrayList<InterfaceAddress> interfaceAddresses = new ArrayList<InterfaceAddress>();
        NetworkInterface.collectIpv6Addresses(interfaceName, interfaceIndex, addresses, interfaceAddresses);
        NetworkInterface.collectIpv4Address(interfaceName, addresses, interfaceAddresses);
        return new NetworkInterface(interfaceName, interfaceIndex, addresses, interfaceAddresses);
    }

    private static int ipv6NetmaskToPrefixLength(byte[] netmask) {
        int b;
        int prefixLength = 0;
        int index = 0;
        while (index < netmask.length && (b = netmask[index++] & 0xFF) == 255) {
            prefixLength += 8;
        }
        if (index == netmask.length) {
            return prefixLength;
        }
        b = netmask[index];
        for (int bit = 7; bit != 0 && (b & 1 << bit) != 0; --bit) {
            ++prefixLength;
        }
        return prefixLength;
    }

    private static void collectIpv6Addresses(String interfaceName, int interfaceIndex, List<InetAddress> addresses, List<InterfaceAddress> interfaceAddresses) throws SocketException {
        byte[] bytes = NetworkInterface.getIpv6Addresses(interfaceName);
        if (bytes != null) {
            for (int i = 0; i < bytes.length; i += 32) {
                byte[] addressBytes = new byte[16];
                byte[] netmaskBytes = new byte[16];
                System.arraycopy((Object)bytes, i, (Object)addressBytes, 0, 16);
                System.arraycopy((Object)bytes, i + 16, (Object)netmaskBytes, 0, 16);
                Inet6Address inet6Address = new Inet6Address(addressBytes, null, interfaceIndex);
                addresses.add(inet6Address);
                interfaceAddresses.add(new InterfaceAddress(inet6Address, (short)NetworkInterface.ipv6NetmaskToPrefixLength(netmaskBytes)));
            }
        }
    }

    /*
     * Loose catch block
     */
    private static void collectIpv4Address(String interfaceName, List<InetAddress> addresses, List<InterfaceAddress> interfaceAddresses) throws SocketException {
        FileDescriptor fd = null;
        try {
            InetAddress broadcast;
            InetAddress address;
            block9: {
                fd = Libcore.os.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, 0);
                address = Libcore.os.ioctlInetAddress(fd, OsConstants.SIOCGIFADDR, interfaceName);
                broadcast = Inet4Address.ANY;
                try {
                    broadcast = Libcore.os.ioctlInetAddress(fd, OsConstants.SIOCGIFBRDADDR, interfaceName);
                }
                catch (ErrnoException e) {
                    if (DARWIN && e.errno == OsConstants.EINVAL) break block9;
                    throw e;
                }
            }
            InetAddress netmask = Libcore.os.ioctlInetAddress(fd, OsConstants.SIOCGIFNETMASK, interfaceName);
            if (broadcast.equals(Inet4Address.ANY)) {
                broadcast = null;
            }
            addresses.add(address);
            interfaceAddresses.add(new InterfaceAddress((Inet4Address)address, (Inet4Address)broadcast, (Inet4Address)netmask));
        }
        catch (ErrnoException errnoException) {
            block10: {
                if (errnoException.errno == OsConstants.EADDRNOTAVAIL) break block10;
                throw NetworkInterface.rethrowAsSocketException(errnoException);
            }
            IoUtils.closeQuietly(fd);
        }
        catch (Exception ex) {
            throw NetworkInterface.rethrowAsSocketException(ex);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fd);
                    throw throwable;
                }
            }
        }
        IoUtils.closeQuietly(fd);
    }

    private static SocketException rethrowAsSocketException(Exception ex) throws SocketException {
        SocketException result = new SocketException();
        result.initCause(ex);
        throw result;
    }

    public static NetworkInterface getByInetAddress(InetAddress address) throws SocketException {
        if (address == null) {
            throw new NullPointerException("address == null");
        }
        for (NetworkInterface networkInterface : NetworkInterface.getNetworkInterfacesList()) {
            if (!networkInterface.addresses.contains(address)) continue;
            return networkInterface;
        }
        return null;
    }

    public static NetworkInterface getByIndex(int index) throws SocketException {
        String name = Libcore.os.if_indextoname(index);
        if (name == null) {
            return null;
        }
        return NetworkInterface.getByName(name);
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        return Collections.enumeration(NetworkInterface.getNetworkInterfacesList());
    }

    private static native String[] getInterfaceNames();

    private static native int getInterfaceIndex(String var0);

    private static native byte[] getIpv6Addresses(String var0);

    private static native byte[] getHardwareAddress(String var0);

    private static native int getFlags(String var0);

    private static native int getMTU(String var0);

    @FindBugsSuppressWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static List<NetworkInterface> getNetworkInterfacesList() throws SocketException {
        String[] interfaceNames = NetworkInterface.getInterfaceNames();
        NetworkInterface[] interfaces = new NetworkInterface[interfaceNames.length];
        boolean[] done = new boolean[interfaces.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaces[i] = NetworkInterface.getByName(interfaceNames[i]);
            if (interfaces[i] != null) continue;
            done[i] = true;
        }
        ArrayList<NetworkInterface> result = new ArrayList<NetworkInterface>();
        for (int counter = 0; counter < interfaces.length; ++counter) {
            if (done[counter]) continue;
            for (int counter2 = counter; counter2 < interfaces.length; ++counter2) {
                if (done[counter2] || !interfaces[counter2].name.startsWith(interfaces[counter].name + ":")) continue;
                interfaces[counter].children.add(interfaces[counter2]);
                interfaces[counter2].parent = interfaces[counter];
                interfaces[counter].addresses.addAll(interfaces[counter2].addresses);
                done[counter2] = true;
            }
            result.add(interfaces[counter]);
            done[counter] = true;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface rhs = (NetworkInterface)obj;
        return this.interfaceIndex == rhs.interfaceIndex && this.name.equals(rhs.name) && this.addresses.equals(rhs.addresses);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(25);
        sb.append("[");
        sb.append(this.name);
        sb.append("][");
        sb.append(this.interfaceIndex);
        sb.append("]");
        for (InetAddress address : this.addresses) {
            sb.append("[");
            sb.append(address.toString());
            sb.append("]");
        }
        return sb.toString();
    }

    public List<InterfaceAddress> getInterfaceAddresses() {
        return Collections.unmodifiableList(this.interfaceAddresses);
    }

    public Enumeration<NetworkInterface> getSubInterfaces() {
        return Collections.enumeration(this.children);
    }

    public NetworkInterface getParent() {
        return this.parent;
    }

    public boolean isUp() throws SocketException {
        return this.hasFlag(OsConstants.IFF_UP);
    }

    public boolean isLoopback() throws SocketException {
        return this.hasFlag(OsConstants.IFF_LOOPBACK);
    }

    public boolean isPointToPoint() throws SocketException {
        return this.hasFlag(OsConstants.IFF_POINTOPOINT);
    }

    public boolean supportsMulticast() throws SocketException {
        return this.hasFlag(OsConstants.IFF_MULTICAST);
    }

    private boolean hasFlag(int mask) throws SocketException {
        int flags = NetworkInterface.getFlags(this.name);
        return (flags & mask) != 0;
    }

    public byte[] getHardwareAddress() throws SocketException {
        return NetworkInterface.getHardwareAddress(this.name);
    }

    public int getMTU() throws SocketException {
        return NetworkInterface.getMTU(this.name);
    }

    public boolean isVirtual() {
        return this.parent != null;
    }

    static {
        String osName = System.getProperty("os.name");
        DARWIN = osName.contains("iOS") || osName.contains("Mac");
    }
}

