/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> loaderCache = new WeakHashMap();
    private static final Map<Class<?>, String> proxyCache = new WeakHashMap();
    private static int NextClassNameIndex = 0;
    protected InvocationHandler h;

    private Proxy() {
    }

    protected Proxy(InvocationHandler h) {
        this.h = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) throws IllegalArgumentException {
        if (interfaces == null) {
            throw new NullPointerException("interfaces == null");
        }
        String commonPackageName = null;
        int length = interfaces.length;
        for (int i = 0; i < length; ++i) {
            String p;
            Class<?> next = interfaces[i];
            if (next == null) {
                throw new NullPointerException("interfaces[" + i + "] == null");
            }
            String name = next.getName();
            if (!next.isInterface()) {
                throw new IllegalArgumentException(name + " is not an interface");
            }
            if (loader != next.getClassLoader()) {
                try {
                    if (next != Class.forName(name, false, loader)) {
                        throw new IllegalArgumentException(name + " is not visible from class loader");
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalArgumentException(name + " is not visible from class loader");
                }
            }
            for (int j = i + 1; j < length; ++j) {
                if (next != interfaces[j]) continue;
                throw new IllegalArgumentException(name + " appears more than once");
            }
            if (Modifier.isPublic(next.getModifiers())) continue;
            int last = name.lastIndexOf(46);
            String string = p = last == -1 ? "" : name.substring(0, last);
            if (commonPackageName == null) {
                commonPackageName = p;
                continue;
            }
            if (commonPackageName.equals(p)) continue;
            throw new IllegalArgumentException("non-public interfaces must be in the same package");
        }
        Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map = loaderCache;
        synchronized (map) {
            Class newClass;
            Map<String, WeakReference<Class<?>>> interfaceCache = loaderCache.get(loader);
            if (interfaceCache == null) {
                interfaceCache = new HashMap();
                loaderCache.put(loader, interfaceCache);
            }
            String interfaceKey = "";
            if (interfaces.length == 1) {
                interfaceKey = interfaces[0].getName();
            } else {
                StringBuilder names = new StringBuilder();
                int length2 = interfaces.length;
                for (int i = 0; i < length2; ++i) {
                    names.append(interfaces[i].getName());
                    names.append(' ');
                }
                interfaceKey = names.toString();
            }
            WeakReference<Class<?>> ref = interfaceCache.get(interfaceKey);
            if (ref == null) {
                String nextClassName = "$Proxy" + NextClassNameIndex++;
                if (commonPackageName != null && commonPackageName.length() > 0) {
                    nextClassName = commonPackageName + "." + nextClassName;
                }
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                newClass = Proxy.generateProxy(nextClassName.replace('.', '/'), interfaces, loader);
                interfaceCache.put(interfaceKey, new WeakReference<Class>(newClass));
                Map<Class<?>, String> map2 = proxyCache;
                synchronized (map2) {
                    proxyCache.put(newClass, "");
                }
            } else {
                newClass = (Class)ref.get();
                assert (newClass != null) : "\ninterfaceKey=\"" + interfaceKey + "\"" + "\nloaderCache=\"" + loaderCache + "\"" + "\nintfCache=\"" + interfaceCache + "\"" + "\nproxyCache=\"" + proxyCache + "\"";
            }
            return newClass;
        }
    }

    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        if (h == null) {
            throw new NullPointerException("h == null");
        }
        try {
            return Proxy.getProxyClass(loader, interfaces).getConstructor(InvocationHandler.class).newInstance(h);
        }
        catch (NoSuchMethodException ex) {
            throw (InternalError)new InternalError(ex.toString()).initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (InternalError)new InternalError(ex.toString()).initCause(ex);
        }
        catch (InstantiationException ex) {
            throw (InternalError)new InternalError(ex.toString()).initCause(ex);
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            throw (InternalError)new InternalError(target.toString()).initCause(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isProxyClass(Class<?> cl) {
        if (cl == null) {
            throw new NullPointerException("cl == null");
        }
        Map<Class<?>, String> map = proxyCache;
        synchronized (map) {
            return proxyCache.containsKey(cl);
        }
    }

    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        if (Proxy.isProxyClass(proxy.getClass())) {
            return ((Proxy)proxy).h;
        }
        throw new IllegalArgumentException("not a proxy instance");
    }

    private static native Class generateProxy(String var0, Class[] var1, ClassLoader var2);

    private static native void constructorPrototype(InvocationHandler var0);
}

