/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;

public abstract class Reference<T> {
    volatile T referent;
    volatile ReferenceQueue<? super T> queue;
    volatile Reference queueNext;
    public volatile Reference<?> pendingNext;

    Reference() {
        this.register(null);
    }

    Reference(T r, ReferenceQueue<? super T> q) {
        this.referent = r;
        this.queue = q;
        this.register(r);
    }

    private native void register(T var1);

    public void clear() {
        this.referent = null;
    }

    public final synchronized boolean enqueueInternal() {
        if (this.queue != null && this.queueNext == null) {
            this.queue.enqueue(this);
            this.queue = null;
            return true;
        }
        return false;
    }

    public boolean enqueue() {
        return this.enqueueInternal();
    }

    public T get() {
        return this.referent;
    }

    public boolean isEnqueued() {
        return this.queueNext != null;
    }
}

