/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.NioUtils;
import java.nio.channels.FileChannel;
import java.nio.charset.ModifiedUtf8;
import java.util.Arrays;
import libcore.io.ErrnoException;
import libcore.io.IoBridge;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.Memory;
import libcore.io.OsConstants;

public class RandomAccessFile
implements DataInput,
DataOutput,
Closeable {
    private FileDescriptor fd;
    private boolean syncMetadata = false;
    private FileChannel channel;
    private int mode;
    private final CloseGuard guard = CloseGuard.get();
    private final byte[] scratch = new byte[8];

    public RandomAccessFile(File file, String mode) throws FileNotFoundException {
        int flags;
        if (mode.equals("r")) {
            flags = OsConstants.O_RDONLY;
        } else if (mode.equals("rw") || mode.equals("rws") || mode.equals("rwd")) {
            flags = OsConstants.O_RDWR | OsConstants.O_CREAT;
            if (mode.equals("rws")) {
                this.syncMetadata = true;
            } else if (mode.equals("rwd")) {
                flags |= OsConstants.O_SYNC;
            }
        } else {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
        this.mode = flags;
        this.fd = IoBridge.open(file.getAbsolutePath(), flags);
        if (this.syncMetadata) {
            try {
                this.fd.sync();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.guard.open("close");
    }

    public RandomAccessFile(String fileName, String mode) throws FileNotFoundException {
        this(new File(fileName), mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.guard.close();
        RandomAccessFile randomAccessFile = this;
        synchronized (randomAccessFile) {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
                this.channel = null;
            }
            IoUtils.close(this.fd);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public final synchronized FileChannel getChannel() {
        if (this.channel == null) {
            this.channel = NioUtils.newFileChannel(this, this.fd, this.mode);
        }
        return this.channel;
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    public long getFilePointer() throws IOException {
        try {
            return Libcore.os.lseek(this.fd, 0L, OsConstants.SEEK_CUR);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public long length() throws IOException {
        try {
            return Libcore.os.fstat((FileDescriptor)this.fd).st_size;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public int read() throws IOException {
        return this.read(this.scratch, 0, 1) != -1 ? this.scratch[0] & 0xFF : -1;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return IoBridge.read(this.fd, buffer, byteOffset, byteCount);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] dst) throws IOException {
        this.readFully(dst, 0, dst.length);
    }

    @Override
    public final void readFully(byte[] dst, int offset, int byteCount) throws IOException {
        Arrays.checkOffsetAndCount(dst.length, offset, byteCount);
        while (byteCount > 0) {
            int result = this.read(dst, offset, byteCount);
            if (result < 0) {
                throw new EOFException();
            }
            offset += result;
            byteCount -= result;
        }
    }

    @Override
    public final int readInt() throws IOException {
        this.readFully(this.scratch, 0, 4);
        return Memory.peekInt(this.scratch, 0, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public final String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean foundTerminator = false;
        long unreadPosition = 0L;
        block5: while (true) {
            int nextByte = this.read();
            switch (nextByte) {
                case -1: {
                    return line.length() != 0 ? line.toString() : null;
                }
                case 13: {
                    if (foundTerminator) {
                        this.seek(unreadPosition);
                        return line.toString();
                    }
                    foundTerminator = true;
                    unreadPosition = this.getFilePointer();
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                this.seek(unreadPosition);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    @Override
    public final long readLong() throws IOException {
        this.readFully(this.scratch, 0, 8);
        return Memory.peekLong(this.scratch, 0, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public final short readShort() throws IOException {
        this.readFully(this.scratch, 0, 2);
        return Memory.peekShort(this.scratch, 0, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final String readUTF() throws IOException {
        int utfSize = this.readUnsignedShort();
        if (utfSize == 0) {
            return "";
        }
        byte[] buf = new byte[utfSize];
        if (this.read(buf, 0, buf.length) != buf.length) {
            throw new EOFException();
        }
        return ModifiedUtf8.decode(buf, new char[utfSize], 0, utfSize);
    }

    public void seek(long offset) throws IOException {
        if (offset < 0L) {
            throw new IOException("offset < 0: " + offset);
        }
        try {
            Libcore.os.lseek(this.fd, offset, OsConstants.SEEK_SET);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public void setLength(long newLength) throws IOException {
        if (newLength < 0L) {
            throw new IllegalArgumentException("newLength < 0");
        }
        try {
            Libcore.os.ftruncate(this.fd, newLength);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
        long filePointer = this.getFilePointer();
        if (filePointer > newLength) {
            this.seek(newLength);
        }
        if (this.syncMetadata) {
            this.fd.sync();
        }
    }

    @Override
    public int skipBytes(int count) throws IOException {
        if (count > 0) {
            long eof;
            long currentPos = this.getFilePointer();
            int newCount = (int)(currentPos + (long)count > (eof = this.length()) ? eof - currentPos : (long)count);
            this.seek(currentPos + (long)newCount);
            return newCount;
        }
        return 0;
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        IoBridge.write(this.fd, buffer, byteOffset, byteCount);
        if (this.syncMetadata) {
            this.fd.sync();
        }
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.scratch[0] = (byte)(oneByte & 0xFF);
        this.write(this.scratch, 0, 1);
    }

    @Override
    public final void writeBoolean(boolean val) throws IOException {
        this.write(val ? 1 : 0);
    }

    @Override
    public final void writeByte(int val) throws IOException {
        this.write(val & 0xFF);
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        byte[] bytes = new byte[str.length()];
        for (int index = 0; index < str.length(); ++index) {
            bytes[index] = (byte)(str.charAt(index) & 0xFF);
        }
        this.write(bytes);
    }

    @Override
    public final void writeChar(int val) throws IOException {
        this.writeShort(val);
    }

    @Override
    public final void writeChars(String str) throws IOException {
        this.write(str.getBytes("UTF-16BE"));
    }

    @Override
    public final void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }

    @Override
    public final void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    @Override
    public final void writeInt(int val) throws IOException {
        Memory.pokeInt(this.scratch, 0, val, ByteOrder.BIG_ENDIAN);
        this.write(this.scratch, 0, 4);
    }

    @Override
    public final void writeLong(long val) throws IOException {
        Memory.pokeLong(this.scratch, 0, val, ByteOrder.BIG_ENDIAN);
        this.write(this.scratch, 0, 8);
    }

    @Override
    public final void writeShort(int val) throws IOException {
        Memory.pokeShort(this.scratch, 0, (short)val, ByteOrder.BIG_ENDIAN);
        this.write(this.scratch, 0, 2);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.write(ModifiedUtf8.encode(str));
    }
}

