/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;

    public ByteArrayInputStream(byte[] buf) {
        this.mark = 0;
        this.buf = buf;
        this.count = buf.length;
    }

    public ByteArrayInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.mark = offset;
        this.count = offset + length > buf.length ? buf.length : offset + length;
    }

    @Override
    public synchronized int available() {
        return this.count - this.pos;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public synchronized int read(byte[] buffer, int byteOffset, int byteCount) {
        Arrays.checkOffsetAndCount(buffer.length, byteOffset, byteCount);
        if (this.pos >= this.count) {
            return -1;
        }
        if (byteCount == 0) {
            return 0;
        }
        int copylen = this.count - this.pos < byteCount ? this.count - this.pos : byteCount;
        System.arraycopy((Object)this.buf, this.pos, (Object)buffer, byteOffset, copylen);
        this.pos += copylen;
        return copylen;
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
    }

    @Override
    public synchronized long skip(long byteCount) {
        if (byteCount <= 0L) {
            return 0L;
        }
        int temp = this.pos;
        this.pos = (long)(this.count - this.pos) < byteCount ? this.count : (int)((long)this.pos + byteCount);
        return this.pos - temp;
    }
}

