/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.CipherSuite;
import com.android.org.conscrypt.ProtocolVersion;
import com.android.org.conscrypt.util.EmptyArray;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public final class SSLSessionImpl
implements SSLSession,
Cloneable {
    private long creationTime;
    private boolean isValid = true;
    private final Map<String, Object> values = new HashMap<String, Object>();
    byte[] id;
    long lastAccessedTime = this.creationTime = System.currentTimeMillis();
    ProtocolVersion protocol;
    CipherSuite cipherSuite;
    SSLSessionContext context;
    java.security.cert.X509Certificate[] localCertificates;
    java.security.cert.X509Certificate[] peerCertificates;
    private String peerHost;
    private int peerPort = -1;
    byte[] master_secret;
    byte[] clientRandom;
    byte[] serverRandom;
    final boolean isServer;

    public static SSLSessionImpl getNullSession() {
        return DefaultHolder.NULL_SESSION;
    }

    public SSLSessionImpl(CipherSuite cipher_suite, SecureRandom secureRandom) {
        if (cipher_suite == null) {
            this.cipherSuite = CipherSuite.SSL_NULL_WITH_NULL_NULL;
            this.id = EmptyArray.BYTE;
            this.isServer = false;
            this.isValid = false;
        } else {
            this.cipherSuite = cipher_suite;
            this.id = new byte[32];
            secureRandom.nextBytes(this.id);
            long time = this.creationTime / 1000L;
            this.id[28] = (byte)((time & 0xFFFFFFFFFF000000L) >>> 24);
            this.id[29] = (byte)((time & 0xFF0000L) >>> 16);
            this.id[30] = (byte)((time & 0xFF00L) >>> 8);
            this.id[31] = (byte)(time & 0xFFL);
            this.isServer = true;
        }
    }

    public SSLSessionImpl(SecureRandom secureRandom) {
        this(null, secureRandom);
    }

    @Override
    public int getApplicationBufferSize() {
        return 16384;
    }

    @Override
    public String getCipherSuite() {
        return this.cipherSuite.getName();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public byte[] getId() {
        return this.id;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    @Override
    public Principal getLocalPrincipal() {
        if (this.localCertificates != null && this.localCertificates.length > 0) {
            return this.localCertificates[0].getSubjectX500Principal();
        }
        return null;
    }

    @Override
    public int getPacketBufferSize() {
        return 18437;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null) {
            throw new SSLPeerUnverifiedException("No peer certificate");
        }
        X509Certificate[] certs = new X509Certificate[this.peerCertificates.length];
        for (int i = 0; i < certs.length; ++i) {
            try {
                certs[i] = X509Certificate.getInstance(this.peerCertificates[i].getEncoded());
                continue;
            }
            catch (CertificateException ignored) {
                continue;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        return certs;
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null) {
            throw new SSLPeerUnverifiedException("No peer certificate");
        }
        return this.peerCertificates;
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null) {
            throw new SSLPeerUnverifiedException("No peer certificate");
        }
        return this.peerCertificates[0].getSubjectX500Principal();
    }

    @Override
    public String getProtocol() {
        return this.protocol == null ? "NONE" : this.protocol.name;
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.context;
    }

    @Override
    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        return this.values.get(name);
    }

    @Override
    public String[] getValueNames() {
        return this.values.keySet().toArray(new String[this.values.size()]);
    }

    @Override
    public void invalidate() {
        this.isValid = false;
        this.context = null;
    }

    @Override
    public boolean isValid() {
        if (this.isValid && this.context != null && this.context.getSessionTimeout() != 0 && this.lastAccessedTime + (long)this.context.getSessionTimeout() > System.currentTimeMillis()) {
            this.isValid = false;
        }
        return this.isValid;
    }

    @Override
    public void putValue(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name == null || value == null");
        }
        Object old = this.values.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
        if (old instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)old).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    @Override
    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        Object old = this.values.remove(name);
        if (old instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener listener = (SSLSessionBindingListener)old;
            listener.valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    void setPeer(String peerHost, int peerPort) {
        this.peerHost = peerHost;
        this.peerPort = peerPort;
    }

    private static class DefaultHolder {
        public static final SSLSessionImpl NULL_SESSION = new SSLSessionImpl(null);

        private DefaultHolder() {
        }
    }
}

