/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal.http;

import com.android.okhttp.ResponseSource;
import com.android.okhttp.internal.Platform;
import com.android.okhttp.internal.Util;
import com.android.okhttp.internal.http.HeaderParser;
import com.android.okhttp.internal.http.HttpDate;
import com.android.okhttp.internal.http.RawHeaders;
import com.android.okhttp.internal.http.RequestHeaders;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public final class ResponseHeaders {
    private static final String SENT_MILLIS = Platform.get().getPrefix() + "-Sent-Millis";
    private static final String RECEIVED_MILLIS = Platform.get().getPrefix() + "-Received-Millis";
    static final String RESPONSE_SOURCE = Platform.get().getPrefix() + "-Response-Source";
    static final String SELECTED_TRANSPORT = Platform.get().getPrefix() + "-Selected-Transport";
    private final URI uri;
    private final RawHeaders headers;
    private Date servedDate;
    private Date lastModified;
    private Date expires;
    private long sentRequestMillis;
    private long receivedResponseMillis;
    private boolean noCache;
    private boolean noStore;
    private int maxAgeSeconds = -1;
    private int sMaxAgeSeconds = -1;
    private boolean isPublic;
    private boolean mustRevalidate;
    private String etag;
    private int ageSeconds = -1;
    private Set<String> varyFields = Collections.emptySet();
    private String contentEncoding;
    private String transferEncoding;
    private int contentLength = -1;
    private String connection;

    public ResponseHeaders(URI uri, RawHeaders headers) {
        this.uri = uri;
        this.headers = headers;
        HeaderParser.CacheControlHandler handler = new HeaderParser.CacheControlHandler(){

            @Override
            public void handle(String directive, String parameter) {
                if ("no-cache".equalsIgnoreCase(directive)) {
                    ResponseHeaders.this.noCache = true;
                } else if ("no-store".equalsIgnoreCase(directive)) {
                    ResponseHeaders.this.noStore = true;
                } else if ("max-age".equalsIgnoreCase(directive)) {
                    ResponseHeaders.this.maxAgeSeconds = HeaderParser.parseSeconds(parameter);
                } else if ("s-maxage".equalsIgnoreCase(directive)) {
                    ResponseHeaders.this.sMaxAgeSeconds = HeaderParser.parseSeconds(parameter);
                } else if ("public".equalsIgnoreCase(directive)) {
                    ResponseHeaders.this.isPublic = true;
                } else if ("must-revalidate".equalsIgnoreCase(directive)) {
                    ResponseHeaders.this.mustRevalidate = true;
                }
            }
        };
        for (int i = 0; i < headers.length(); ++i) {
            String fieldName = headers.getFieldName(i);
            String value = headers.getValue(i);
            if ("Cache-Control".equalsIgnoreCase(fieldName)) {
                HeaderParser.parseCacheControl(value, handler);
                continue;
            }
            if ("Date".equalsIgnoreCase(fieldName)) {
                this.servedDate = HttpDate.parse(value);
                continue;
            }
            if ("Expires".equalsIgnoreCase(fieldName)) {
                this.expires = HttpDate.parse(value);
                continue;
            }
            if ("Last-Modified".equalsIgnoreCase(fieldName)) {
                this.lastModified = HttpDate.parse(value);
                continue;
            }
            if ("ETag".equalsIgnoreCase(fieldName)) {
                this.etag = value;
                continue;
            }
            if ("Pragma".equalsIgnoreCase(fieldName)) {
                if (!"no-cache".equalsIgnoreCase(value)) continue;
                this.noCache = true;
                continue;
            }
            if ("Age".equalsIgnoreCase(fieldName)) {
                this.ageSeconds = HeaderParser.parseSeconds(value);
                continue;
            }
            if ("Vary".equalsIgnoreCase(fieldName)) {
                if (this.varyFields.isEmpty()) {
                    this.varyFields = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                }
                for (String varyField : value.split(",")) {
                    this.varyFields.add(varyField.trim());
                }
                continue;
            }
            if ("Content-Encoding".equalsIgnoreCase(fieldName)) {
                this.contentEncoding = value;
                continue;
            }
            if ("Transfer-Encoding".equalsIgnoreCase(fieldName)) {
                this.transferEncoding = value;
                continue;
            }
            if ("Content-Length".equalsIgnoreCase(fieldName)) {
                try {
                    this.contentLength = Integer.parseInt(value);
                }
                catch (NumberFormatException ignored) {}
                continue;
            }
            if ("Connection".equalsIgnoreCase(fieldName)) {
                this.connection = value;
                continue;
            }
            if (SENT_MILLIS.equalsIgnoreCase(fieldName)) {
                this.sentRequestMillis = Long.parseLong(value);
                continue;
            }
            if (!RECEIVED_MILLIS.equalsIgnoreCase(fieldName)) continue;
            this.receivedResponseMillis = Long.parseLong(value);
        }
    }

    public boolean isContentEncodingGzip() {
        return "gzip".equalsIgnoreCase(this.contentEncoding);
    }

    public void stripContentEncoding() {
        this.contentEncoding = null;
        this.headers.removeAll("Content-Encoding");
    }

    public void stripContentLength() {
        this.contentLength = -1;
        this.headers.removeAll("Content-Length");
    }

    public boolean isChunked() {
        return "chunked".equalsIgnoreCase(this.transferEncoding);
    }

    public boolean hasConnectionClose() {
        return "close".equalsIgnoreCase(this.connection);
    }

    public URI getUri() {
        return this.uri;
    }

    public RawHeaders getHeaders() {
        return this.headers;
    }

    public Date getServedDate() {
        return this.servedDate;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public Date getExpires() {
        return this.expires;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public boolean isNoStore() {
        return this.noStore;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public int getSMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isMustRevalidate() {
        return this.mustRevalidate;
    }

    public String getEtag() {
        return this.etag;
    }

    public Set<String> getVaryFields() {
        return this.varyFields;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setLocalTimestamps(long sentRequestMillis, long receivedResponseMillis) {
        this.sentRequestMillis = sentRequestMillis;
        this.headers.add(SENT_MILLIS, Long.toString(sentRequestMillis));
        this.receivedResponseMillis = receivedResponseMillis;
        this.headers.add(RECEIVED_MILLIS, Long.toString(receivedResponseMillis));
    }

    public void setResponseSource(ResponseSource responseSource) {
        this.headers.set(RESPONSE_SOURCE, responseSource.toString() + " " + this.headers.getResponseCode());
    }

    public void setTransport(String transport) {
        this.headers.set(SELECTED_TRANSPORT, transport);
    }

    private long computeAge(long nowMillis) {
        long apparentReceivedAge = this.servedDate != null ? Math.max(0L, this.receivedResponseMillis - this.servedDate.getTime()) : 0L;
        long receivedAge = this.ageSeconds != -1 ? Math.max(apparentReceivedAge, TimeUnit.SECONDS.toMillis(this.ageSeconds)) : apparentReceivedAge;
        long responseDuration = this.receivedResponseMillis - this.sentRequestMillis;
        long residentDuration = nowMillis - this.receivedResponseMillis;
        return receivedAge + responseDuration + residentDuration;
    }

    private long computeFreshnessLifetime() {
        if (this.maxAgeSeconds != -1) {
            return TimeUnit.SECONDS.toMillis(this.maxAgeSeconds);
        }
        if (this.expires != null) {
            long servedMillis = this.servedDate != null ? this.servedDate.getTime() : this.receivedResponseMillis;
            long delta = this.expires.getTime() - servedMillis;
            return delta > 0L ? delta : 0L;
        }
        if (this.lastModified != null && this.uri.getRawQuery() == null) {
            long servedMillis = this.servedDate != null ? this.servedDate.getTime() : this.sentRequestMillis;
            long delta = servedMillis - this.lastModified.getTime();
            return delta > 0L ? delta / 10L : 0L;
        }
        return 0L;
    }

    private boolean isFreshnessLifetimeHeuristic() {
        return this.maxAgeSeconds == -1 && this.expires == null;
    }

    public boolean isCacheable(RequestHeaders request) {
        int responseCode = this.headers.getResponseCode();
        if (responseCode != 200 && responseCode != 203 && responseCode != 300 && responseCode != 301 && responseCode != 410) {
            return false;
        }
        if (request.hasAuthorization() && !this.isPublic && !this.mustRevalidate && this.sMaxAgeSeconds == -1) {
            return false;
        }
        return !this.noStore;
    }

    public boolean hasVaryAll() {
        return this.varyFields.contains("*");
    }

    public boolean varyMatches(Map<String, List<String>> cachedRequest, Map<String, List<String>> newRequest) {
        for (String field : this.varyFields) {
            if (Util.equal(cachedRequest.get(field), newRequest.get(field))) continue;
            return false;
        }
        return true;
    }

    public ResponseSource chooseResponseSource(long nowMillis, RequestHeaders request) {
        if (!this.isCacheable(request)) {
            return ResponseSource.NETWORK;
        }
        if (request.isNoCache() || request.hasConditions()) {
            return ResponseSource.NETWORK;
        }
        long ageMillis = this.computeAge(nowMillis);
        long freshMillis = this.computeFreshnessLifetime();
        if (request.getMaxAgeSeconds() != -1) {
            freshMillis = Math.min(freshMillis, TimeUnit.SECONDS.toMillis(request.getMaxAgeSeconds()));
        }
        long minFreshMillis = 0L;
        if (request.getMinFreshSeconds() != -1) {
            minFreshMillis = TimeUnit.SECONDS.toMillis(request.getMinFreshSeconds());
        }
        long maxStaleMillis = 0L;
        if (!this.mustRevalidate && request.getMaxStaleSeconds() != -1) {
            maxStaleMillis = TimeUnit.SECONDS.toMillis(request.getMaxStaleSeconds());
        }
        if (!this.noCache && ageMillis + minFreshMillis < freshMillis + maxStaleMillis) {
            long oneDayMillis;
            if (ageMillis + minFreshMillis >= freshMillis) {
                this.headers.add("Warning", "110 HttpURLConnection \"Response is stale\"");
            }
            if (ageMillis > (oneDayMillis = 86400000L) && this.isFreshnessLifetimeHeuristic()) {
                this.headers.add("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
            }
            return ResponseSource.CACHE;
        }
        if (this.lastModified != null) {
            request.setIfModifiedSince(this.lastModified);
        } else if (this.servedDate != null) {
            request.setIfModifiedSince(this.servedDate);
        }
        if (this.etag != null) {
            request.setIfNoneMatch(this.etag);
        }
        return request.hasConditions() ? ResponseSource.CONDITIONAL_CACHE : ResponseSource.NETWORK;
    }

    public boolean validate(ResponseHeaders networkResponse) {
        if (networkResponse.headers.getResponseCode() == 304) {
            return true;
        }
        return this.lastModified != null && networkResponse.lastModified != null && networkResponse.lastModified.getTime() < this.lastModified.getTime();
    }

    public ResponseHeaders combine(ResponseHeaders network) throws IOException {
        String fieldName;
        int i;
        RawHeaders result = new RawHeaders();
        result.setStatusLine(this.headers.getStatusLine());
        for (i = 0; i < this.headers.length(); ++i) {
            fieldName = this.headers.getFieldName(i);
            String value = this.headers.getValue(i);
            if ("Warning".equals(fieldName) && value.startsWith("1") || ResponseHeaders.isEndToEnd(fieldName) && network.headers.get(fieldName) != null) continue;
            result.add(fieldName, value);
        }
        for (i = 0; i < network.headers.length(); ++i) {
            fieldName = network.headers.getFieldName(i);
            if (!ResponseHeaders.isEndToEnd(fieldName)) continue;
            result.add(fieldName, network.headers.getValue(i));
        }
        return new ResponseHeaders(this.uri, result);
    }

    private static boolean isEndToEnd(String fieldName) {
        return !"Connection".equalsIgnoreCase(fieldName) && !"Keep-Alive".equalsIgnoreCase(fieldName) && !"Proxy-Authenticate".equalsIgnoreCase(fieldName) && !"Proxy-Authorization".equalsIgnoreCase(fieldName) && !"TE".equalsIgnoreCase(fieldName) && !"Trailers".equalsIgnoreCase(fieldName) && !"Transfer-Encoding".equalsIgnoreCase(fieldName) && !"Upgrade".equalsIgnoreCase(fieldName);
    }
}

