/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2z;

import SQLite.BusyHandler;
import SQLite.Database;
import SQLite.Exception;
import SQLite.JDBC2z.DatabaseX;
import SQLite.JDBC2z.JDBCDatabaseMetaData;
import SQLite.JDBC2z.JDBCPreparedStatement;
import SQLite.JDBC2z.JDBCStatement;
import SQLite.JDBCDriver;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public class JDBCConnection
implements Connection,
BusyHandler {
    protected DatabaseX db;
    protected String url;
    protected String enc;
    protected String vfs;
    protected boolean autocommit = true;
    protected boolean intrans = false;
    protected int timeout = 1000000;
    protected boolean useJulian = false;
    private String dbfile = null;
    private JDBCDatabaseMetaData meta = null;
    private long t0;
    private boolean readonly = false;
    private int trmode = 8;

    private boolean busy0(DatabaseX db, int count) {
        if (count <= 1) {
            this.t0 = System.currentTimeMillis();
        }
        if (db != null) {
            long t1 = System.currentTimeMillis();
            if (t1 - this.t0 > (long)this.timeout) {
                return false;
            }
            db.wait(100);
            return true;
        }
        return false;
    }

    @Override
    public boolean busy(String table, int count) {
        return this.busy0(this.db, count);
    }

    protected boolean busy3(DatabaseX db, int count) {
        if (count <= 1) {
            this.t0 = System.currentTimeMillis();
        }
        if (db != null) {
            long t1 = System.currentTimeMillis();
            return t1 - this.t0 <= (long)this.timeout;
        }
        return false;
    }

    private DatabaseX open(boolean readonly) throws SQLException {
        DatabaseX dbx = null;
        try {
            dbx = new DatabaseX();
            dbx.open(this.dbfile, readonly ? 1 : 6, this.vfs);
            dbx.set_encoding(this.enc);
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        int loop = 0;
        while (true) {
            try {
                dbx.exec("PRAGMA short_column_names = off;", null);
                dbx.exec("PRAGMA full_column_names = on;", null);
                dbx.exec("PRAGMA empty_result_callbacks = on;", null);
                if (Database.version().compareTo("2.6.0") < 0) break;
                dbx.exec("PRAGMA show_datatypes = on;", null);
            }
            catch (Exception e) {
                if (dbx.last_error() == 5 && this.busy0(dbx, ++loop)) continue;
                try {
                    dbx.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw new SQLException(e.toString());
            }
            break;
        }
        return dbx;
    }

    public JDBCConnection(String url, String enc, String pwd, String drep, String vfs) throws SQLException {
        if (url.startsWith("sqlite:/")) {
            this.dbfile = url.substring(8);
        } else if (url.startsWith("jdbc:sqlite:/")) {
            this.dbfile = url.substring(13);
        } else {
            throw new SQLException("unsupported url");
        }
        this.url = url;
        this.enc = enc;
        this.vfs = vfs;
        try {
            this.db = this.open(this.readonly);
            try {
                if (pwd != null && pwd.length() > 0) {
                    this.db.key(pwd);
                }
            }
            catch (Exception se) {
                throw new SQLException("error while setting key");
            }
            this.db.busy_handler(this);
        }
        catch (SQLException e) {
            if (this.db != null) {
                try {
                    this.db.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            throw e;
        }
        this.useJulian = drep != null && (drep.startsWith("j") || drep.startsWith("J"));
    }

    public Database getSQLiteDatabase() {
        return this.db;
    }

    @Override
    public Statement createStatement() {
        JDBCStatement s = new JDBCStatement(this);
        return s;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new SQLFeatureNotSupportedException("unsupported result set type");
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new SQLFeatureNotSupportedException("unsupported result set concurrency");
        }
        JDBCStatement s = new JDBCStatement(this);
        return s;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.meta == null) {
            this.meta = new JDBCDatabaseMetaData(this);
        }
        return this.meta;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.rollback();
        }
        catch (SQLException e) {
            // empty catch block
        }
        this.intrans = false;
        if (this.db != null) {
            try {
                this.db.close();
                this.db = null;
            }
            catch (Exception e) {
                throw new SQLException(e.toString());
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.db == null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readonly;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void commit() throws SQLException {
        if (this.db == null) {
            throw new SQLException("stale connection");
        }
        if (!this.intrans) {
            return;
        }
        try {
            this.db.exec("COMMIT", null);
            this.intrans = false;
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autocommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.trmode;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int x, int y) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        JDBCPreparedStatement s = new JDBCPreparedStatement(this, sql);
        return s;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new SQLFeatureNotSupportedException("unsupported result set type");
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new SQLFeatureNotSupportedException("unsupported result set concurrency");
        }
        JDBCPreparedStatement s = new JDBCPreparedStatement(this, sql);
        return s;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.db == null) {
            throw new SQLException("stale connection");
        }
        if (!this.intrans) {
            return;
        }
        try {
            this.db.exec("ROLLBACK", null);
            this.intrans = false;
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    @Override
    public void setAutoCommit(boolean ac) throws SQLException {
        if (ac && this.intrans && this.db != null) {
            try {
                this.db.exec("ROLLBACK", null);
            }
            catch (Exception e) {
                throw new SQLException(e.toString());
            }
            finally {
                this.intrans = false;
            }
        }
        this.autocommit = ac;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean ro) throws SQLException {
        if (this.intrans) {
            throw new SQLException("incomplete transaction");
        }
        if (ro != this.readonly) {
            DatabaseX dbx = null;
            try {
                dbx = this.open(ro);
                this.db.close();
                this.db = dbx;
                dbx = null;
                this.readonly = ro;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception ee) {
                if (dbx != null) {
                    try {
                        dbx.close();
                    }
                    catch (Exception eee) {
                        // empty catch block
                    }
                }
                throw new SQLException(ee.toString());
            }
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.db.is3() && JDBCDriver.sharedCache) {
            String flag = null;
            if (level == 1 && this.trmode != 1) {
                flag = "on";
            } else if (level == 8 && this.trmode != 8) {
                flag = "off";
            }
            if (flag != null) {
                try {
                    this.db.exec("PRAGMA read_uncommitted = " + flag + ";", null);
                    this.trmode = level;
                }
                catch (java.lang.Exception exception) {
                    // empty catch block
                }
            }
        }
        if (level != this.trmode) {
            throw new SQLException("not supported");
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability == 1) {
            return;
        }
        throw new SQLFeatureNotSupportedException("unsupported holdability");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("unsupported holdability");
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("unsupported holdability");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int x, int y, int z) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autokeys) throws SQLException {
        if (autokeys != 2) {
            throw new SQLFeatureNotSupportedException("generated keys not supported");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] colIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columns) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties prop) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("unsupported");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties();
    }

    @Override
    public Array createArrayOf(String type, Object[] elems) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String type, Object[] attrs) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("unsupported");
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }
}

