/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="UIKit")
public class UIRemoteNotification {
    private static final NSString ALERT = new NSString("alert");
    private static final NSString BODY = new NSString("body");
    private static final NSString SHOW_VIEW = new NSString("show-view");
    private static final NSString BADGE = new NSString("badge");
    private static final NSString SOUND = new NSString("sound");
    private NSDictionary<NSString, NSObject> data;

    protected UIRemoteNotification(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public String getAlert() {
        if (this.data.containsKey(ALERT)) {
            NSDictionary alert;
            Object val = this.data.get(ALERT);
            if (val instanceof NSString) {
                return ((NSObject)val).toString();
            }
            if (val instanceof NSDictionary && (alert = (NSDictionary)val).containsKey(BODY)) {
                NSString body = (NSString)alert.get(BODY);
                return body.toString();
            }
        }
        return null;
    }

    public boolean isViewButtonShown() {
        NSDictionary alert;
        Object val;
        if (this.data.containsKey(ALERT) && (val = this.data.get(ALERT)) instanceof NSDictionary && (alert = (NSDictionary)val).containsKey(SHOW_VIEW)) {
            NSNumber showView = (NSNumber)alert.get(SHOW_VIEW);
            return showView.booleanValue();
        }
        return true;
    }

    public long getBadgeNumber() {
        if (this.data.containsKey(BADGE)) {
            NSString val = (NSString)this.data.get(BADGE);
            return Long.valueOf(val.toString());
        }
        return -1L;
    }

    public String getSound() {
        if (this.data.containsKey(SOUND)) {
            NSString val = (NSString)this.data.get(SOUND);
            return val.toString();
        }
        return null;
    }

    public NSObject get(String key) {
        return this.data.get(new NSString(key));
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(UIRemoteNotification.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static UIRemoteNotification toObject(Class<UIRemoteNotification> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new UIRemoteNotification(o);
        }

        @MarshalsPointer
        public static long toNative(UIRemoteNotification o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

