/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSIndexSet;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.uikit.UIColor;
import org.robovm.apple.uikit.UIImage;
import org.robovm.apple.uikit.UIPasteboardChangedNotificationInfo;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIPasteboard
extends NSObject {
    public UIPasteboard() {
    }

    protected UIPasteboard(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public List<Map<String, NSObject>> getItems() {
        NSArray<NSDictionary<NSString, NSObject>> items = this.getItems0();
        ArrayList<Map<String, NSObject>> itemList = new ArrayList<Map<String, NSObject>>();
        for (NSDictionary<NSString, NSObject> item : items) {
            itemList.add(item.asStringMap());
        }
        return itemList;
    }

    public void setItems(List<Map<String, NSObject>> items) {
        NSMutableArray<NSDictionary<NSString, NSObject>> itemArray = new NSMutableArray<NSDictionary<NSString, NSObject>>();
        for (Map<String, NSObject> item : items) {
            itemArray.add(NSDictionary.fromStringMap(item));
        }
        this.setItems0(itemArray);
    }

    @Property(selector="name")
    public native String getName();

    @Property(selector="isPersistent")
    public native boolean isPersistent();

    @Property(selector="setPersistent:")
    public native void setPersistent(boolean var1);

    @Property(selector="changeCount")
    @MachineSizedSInt
    public native long getChangeCount();

    @Property(selector="numberOfItems")
    @MachineSizedSInt
    public native long getNumberOfItems();

    @Property(selector="items")
    private native NSArray<NSDictionary<NSString, NSObject>> getItems0();

    @Property(selector="setItems:")
    private native void setItems0(NSArray<NSDictionary<NSString, NSObject>> var1);

    @Property(selector="string")
    public native String getString();

    @Property(selector="setString:")
    public native void setString(String var1);

    @Property(selector="strings")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getStrings();

    @Property(selector="setStrings:")
    public native void setStrings(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Property(selector="URL")
    public native NSURL getURL();

    @Property(selector="setURL:")
    public native void setURL(NSURL var1);

    @Property(selector="URLs")
    public native NSArray<NSURL> getURLs();

    @Property(selector="setURLs:")
    public native void setURLs(NSArray<NSURL> var1);

    @Property(selector="image")
    public native UIImage getImage();

    @Property(selector="setImage:")
    public native void setImage(UIImage var1);

    @Property(selector="images")
    public native NSArray<UIImage> getImages();

    @Property(selector="setImages:")
    public native void setImages(NSArray<UIImage> var1);

    @Property(selector="color")
    public native UIColor getColor();

    @Property(selector="setColor:")
    public native void setColor(UIColor var1);

    @Property(selector="colors")
    public native NSArray<UIColor> getColors();

    @Property(selector="setColors:")
    public native void setColors(NSArray<UIColor> var1);

    public static UIPasteboard getFindPasteboard() {
        return UIPasteboard.getPasteboard(UIPasteboard.PasteboardNameFind(), true);
    }

    public List<List<String>> getTypes(NSIndexSet itemSet) {
        NSArray<NSArray<NSString>> types = this.getTypes0(itemSet);
        ArrayList<List<String>> typeList = new ArrayList<List<String>>();
        for (NSArray<NSString> type : types) {
            typeList.add(type.asStringList());
        }
        return typeList;
    }

    public void addItems(List<Map<String, NSObject>> items) {
        NSMutableArray<NSDictionary<NSString, NSObject>> itemArray = new NSMutableArray<NSDictionary<NSString, NSObject>>();
        for (Map<String, NSObject> item : items) {
            itemArray.add(NSDictionary.fromStringMap(item));
        }
        this.addItems((NSArray<NSDictionary<NSString, NSObject>>)itemArray);
    }

    @GlobalValue(symbol="UIPasteboardNameFind", optional=true)
    private static native String PasteboardNameFind();

    @GlobalValue(symbol="UIPasteboardChangedNotification", optional=true)
    public static native NSString ChangedNotification();

    @GlobalValue(symbol="UIPasteboardRemovedNotification", optional=true)
    public static native NSString RemovedNotification();

    @GlobalValue(symbol="UIPasteboardTypeListString", optional=true)
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getStringTypeList();

    @GlobalValue(symbol="UIPasteboardTypeListURL", optional=true)
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getURLTypeList();

    @GlobalValue(symbol="UIPasteboardTypeListImage", optional=true)
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getImageTypeList();

    @GlobalValue(symbol="UIPasteboardTypeListColor", optional=true)
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getColorTypeList();

    @Method(selector="pasteboardTypes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getTypes();

    @Method(selector="containsPasteboardTypes:")
    public native boolean contains(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Method(selector="dataForPasteboardType:")
    public native NSData getData(String var1);

    @Method(selector="valueForPasteboardType:")
    public native NSObject getValue(String var1);

    @Method(selector="setValue:forPasteboardType:")
    public native void setValue(NSObject var1, String var2);

    @Method(selector="setData:forPasteboardType:")
    public native void setData(NSData var1, String var2);

    @Method(selector="pasteboardTypesForItemSet:")
    private native NSArray<NSArray<NSString>> getTypes0(NSIndexSet var1);

    @Method(selector="containsPasteboardTypes:inItemSet:")
    public native boolean contains(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1, NSIndexSet var2);

    @Method(selector="itemSetWithPasteboardTypes:")
    public native NSIndexSet getItemsWithTypes(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Method(selector="valuesForPasteboardType:inItemSet:")
    public native NSArray<?> getValues(String var1, NSIndexSet var2);

    @Method(selector="dataForPasteboardType:inItemSet:")
    public native NSArray<NSData> getData(String var1, NSIndexSet var2);

    @Method(selector="addItems:")
    private native void addItems(NSArray<NSDictionary<NSString, NSObject>> var1);

    @Method(selector="generalPasteboard")
    public static native UIPasteboard getGeneralPasteboard();

    @Method(selector="pasteboardWithName:create:")
    public static native UIPasteboard getPasteboard(String var0, boolean var1);

    @Method(selector="pasteboardWithUniqueName")
    public static native UIPasteboard getUniquePasteboard();

    @Method(selector="removePasteboardWithName:")
    public static native void removePasteboard(String var0);

    static {
        ObjCRuntime.bind(UIPasteboard.class);
    }

    public static class UIPasteboardPtr
    extends Ptr<UIPasteboard, UIPasteboardPtr> {
    }

    public static class Notifications {
        public static NSObject observeChanged(UIPasteboard object, final VoidBlock2<UIPasteboard, UIPasteboardChangedNotificationInfo> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIPasteboard.ChangedNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((UIPasteboard)a.getObject()), (Object)new UIPasteboardChangedNotificationInfo(a.getUserInfo()));
                }
            });
        }

        public static NSObject observeRemoved(UIPasteboard object, final VoidBlock1<UIPasteboard> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIPasteboard.RemovedNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((UIPasteboard)a.getObject()));
                }
            });
        }
    }
}

