/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.uikit.UIMenuController;
import org.robovm.objc.LongMap;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIMenuItem
extends NSObject {
    static final LongMap<UIMenuItem> items;
    private OnActionListener actionListener;

    public UIMenuItem(String title) {
        this.setTitle(title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIMenuItem(String title, OnActionListener action) {
        super(null);
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.actionListener = action;
        Selector sel = this.getUniqueSelector();
        this.initObject(this.init(title, sel));
        LongMap<UIMenuItem> longMap = items;
        synchronized (longMap) {
            items.put(sel.getHandle(), (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActionListener(OnActionListener action) {
        this.actionListener = action;
        Selector sel = null;
        if (action != null) {
            sel = this.getUniqueSelector();
        }
        this.setAction(sel);
        LongMap<UIMenuItem> longMap = items;
        synchronized (longMap) {
            if (action != null) {
                items.put(sel.getHandle(), (Object)this);
            } else {
                items.remove(sel.getHandle());
            }
        }
    }

    public OnActionListener getActionListener() {
        return this.actionListener;
    }

    private Selector getUniqueSelector() {
        String name = "__menuitem_" + this.getHandle();
        return Selector.register((String)name);
    }

    public UIMenuItem() {
    }

    protected UIMenuItem(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public UIMenuItem(String title, Selector action) {
        super(null);
        this.initObject(this.init(title, action));
    }

    @Property(selector="title")
    public native String getTitle();

    @Property(selector="setTitle:")
    public native void setTitle(String var1);

    @Property(selector="action")
    public native Selector getAction();

    @Property(selector="setAction:")
    public native void setAction(Selector var1);

    @Method(selector="initWithTitle:action:")
    @Pointer
    protected native long init(String var1, Selector var2);

    static {
        ObjCRuntime.bind(UIMenuItem.class);
        items = new LongMap();
    }

    public static class UIMenuItemPtr
    extends Ptr<UIMenuItem, UIMenuItemPtr> {
    }

    public static interface OnActionListener {
        public void onAction(UIMenuController var1, UIMenuItem var2);
    }
}

