/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSValue;
import org.robovm.apple.uikit.NSValueExtensions;
import org.robovm.apple.uikit.UIViewAnimationCurve;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="UIKit")
public class UIKeyboardAnimation
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected UIKeyboardAnimation(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    @ByVal
    public CGRect getStartFrame() {
        if (this.data.containsKey(UIKeyboardAnimation.FrameBeginKey())) {
            NSValue val = (NSValue)this.data.get(UIKeyboardAnimation.FrameBeginKey());
            return NSValueExtensions.getRectValue(val);
        }
        return null;
    }

    @ByVal
    public CGRect getEndFrame() {
        if (this.data.containsKey(UIKeyboardAnimation.FrameEndKey())) {
            NSValue val = (NSValue)this.data.get(UIKeyboardAnimation.FrameEndKey());
            return NSValueExtensions.getRectValue(val);
        }
        return null;
    }

    public double getAnimationDuration() {
        if (this.data.containsKey(UIKeyboardAnimation.AnimationDurationKey())) {
            NSNumber val = (NSNumber)this.data.get(UIKeyboardAnimation.AnimationDurationKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public UIViewAnimationCurve getAnimationCurve() {
        if (this.data.containsKey(UIKeyboardAnimation.AnimationCurveKey())) {
            NSNumber val = (NSNumber)this.data.get(UIKeyboardAnimation.AnimationCurveKey());
            return UIViewAnimationCurve.valueOf(val.intValue());
        }
        return null;
    }

    @GlobalValue(symbol="UIKeyboardFrameBeginUserInfoKey", optional=true)
    protected static native NSString FrameBeginKey();

    @GlobalValue(symbol="UIKeyboardFrameEndUserInfoKey", optional=true)
    protected static native NSString FrameEndKey();

    @GlobalValue(symbol="UIKeyboardAnimationDurationUserInfoKey", optional=true)
    protected static native NSString AnimationDurationKey();

    @GlobalValue(symbol="UIKeyboardAnimationCurveUserInfoKey", optional=true)
    protected static native NSString AnimationCurveKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(UIKeyboardAnimation.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static UIKeyboardAnimation toObject(Class<UIKeyboardAnimation> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new UIKeyboardAnimation(o);
        }

        @MarshalsPointer
        public static long toNative(UIKeyboardAnimation o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

