/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.coregraphics.CGBlendMode;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coreimage.CIImage;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSBundle;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.uikit.UIAccessibility;
import org.robovm.apple.uikit.UIAccessibilityIdentification;
import org.robovm.apple.uikit.UIAccessibilityNavigationStyle;
import org.robovm.apple.uikit.UIAccessibilityTraits;
import org.robovm.apple.uikit.UIBezierPath;
import org.robovm.apple.uikit.UIEdgeInsets;
import org.robovm.apple.uikit.UIImageAsset;
import org.robovm.apple.uikit.UIImageOrientation;
import org.robovm.apple.uikit.UIImageRenderingMode;
import org.robovm.apple.uikit.UIImageResizingMode;
import org.robovm.apple.uikit.UITraitCollection;
import org.robovm.objc.LongMap;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.annotation.TypeEncoding;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIImage
extends NSObject
implements UIAccessibility,
UIAccessibilityIdentification {
    private static AtomicLong id = new AtomicLong();
    private static final Selector didFinishSaving = Selector.register((String)"image:didFinishSavingWithError:contextInfo:");
    private static final LongMap<CallbackWrapper> callbacks = new LongMap();

    public UIImage() {
    }

    protected UIImage(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public UIImage(NSData data) {
        super(null);
        this.initObject(this.init(data));
    }

    public UIImage(NSData data, @MachineSizedFloat double scale) {
        super(null);
        this.initObject(this.init(data, scale));
    }

    public UIImage(CGImage cgImage) {
        super(null);
        this.initObject(this.init(cgImage));
    }

    public UIImage(CGImage cgImage, @MachineSizedFloat double scale, UIImageOrientation orientation) {
        super(null);
        this.initObject(this.init(cgImage, scale, orientation));
    }

    public UIImage(CIImage ciImage) {
        super(null);
        this.initObject(this.init(ciImage));
    }

    public UIImage(CIImage ciImage, @MachineSizedFloat double scale, UIImageOrientation orientation) {
        super(null);
        this.initObject(this.init(ciImage, scale, orientation));
    }

    public UIImage(File file) {
        super(null);
        this.initObject(this.initWithFile(file.getAbsolutePath()));
    }

    @Property(selector="size")
    @ByVal
    public native CGSize getSize();

    @Property(selector="CGImage")
    public native CGImage getCGImage();

    @Property(selector="CIImage")
    public native CIImage getCIImage();

    @Property(selector="imageOrientation")
    public native UIImageOrientation getOrientation();

    @Property(selector="scale")
    @MachineSizedFloat
    public native double getScale();

    @Property(selector="images")
    public native NSArray<UIImage> getImages();

    @Property(selector="duration")
    public native double getDuration();

    @Property(selector="capInsets")
    @ByVal
    public native UIEdgeInsets getCapInsets();

    @Property(selector="resizingMode")
    public native UIImageResizingMode getResizingMode();

    @Property(selector="alignmentRectInsets")
    @ByVal
    public native UIEdgeInsets getAlignmentRectInsets();

    @Property(selector="renderingMode")
    public native UIImageRenderingMode getRenderingMode();

    @Property(selector="traitCollection")
    public native UITraitCollection getTraitCollection();

    @Property(selector="imageAsset")
    public native UIImageAsset getImageAsset();

    @Property(selector="leftCapWidth")
    @MachineSizedSInt
    public native long getLeftCapWidth();

    @Property(selector="topCapHeight")
    @MachineSizedSInt
    public native long getTopCapHeight();

    @Override
    @Property(selector="isAccessibilityElement")
    public native boolean isAccessibilityElement();

    @Override
    @Property(selector="setIsAccessibilityElement:")
    public native void setAccessibilityElement(boolean var1);

    @Override
    @Property(selector="accessibilityLabel")
    public native String getAccessibilityLabel();

    @Override
    @Property(selector="setAccessibilityLabel:")
    public native void setAccessibilityLabel(String var1);

    @Override
    @Property(selector="accessibilityHint")
    public native String getAccessibilityHint();

    @Override
    @Property(selector="setAccessibilityHint:")
    public native void setAccessibilityHint(String var1);

    @Override
    @Property(selector="accessibilityValue")
    public native String getAccessibilityValue();

    @Override
    @Property(selector="setAccessibilityValue:")
    public native void setAccessibilityValue(String var1);

    @Override
    @Property(selector="accessibilityTraits")
    public native UIAccessibilityTraits getAccessibilityTraits();

    @Override
    @Property(selector="setAccessibilityTraits:")
    public native void setAccessibilityTraits(UIAccessibilityTraits var1);

    @Override
    @Property(selector="accessibilityFrame")
    @ByVal
    public native CGRect getAccessibilityFrame();

    @Override
    @Property(selector="setAccessibilityFrame:")
    public native void setAccessibilityFrame(@ByVal CGRect var1);

    @Override
    @Property(selector="accessibilityPath")
    public native UIBezierPath getAccessibilityPath();

    @Override
    @Property(selector="setAccessibilityPath:")
    public native void setAccessibilityPath(UIBezierPath var1);

    @Override
    @Property(selector="accessibilityActivationPoint")
    @ByVal
    public native CGPoint getAccessibilityActivationPoint();

    @Override
    @Property(selector="setAccessibilityActivationPoint:")
    public native void setAccessibilityActivationPoint(@ByVal CGPoint var1);

    @Override
    @Property(selector="accessibilityLanguage")
    public native String getAccessibilityLanguage();

    @Override
    @Property(selector="setAccessibilityLanguage:")
    public native void setAccessibilityLanguage(String var1);

    @Override
    @Property(selector="accessibilityElementsHidden")
    public native boolean areAccessibilityElementsHidden();

    @Override
    @Property(selector="setAccessibilityElementsHidden:")
    public native void setAccessibilityElementsHidden(boolean var1);

    @Override
    @Property(selector="accessibilityViewIsModal")
    public native boolean isAccessibilityViewModal();

    @Override
    @Property(selector="setAccessibilityViewIsModal:")
    public native void setAccessibilityViewModal(boolean var1);

    @Override
    @Property(selector="shouldGroupAccessibilityChildren")
    public native boolean shouldGroupAccessibilityChildren();

    @Override
    @Property(selector="setShouldGroupAccessibilityChildren:")
    public native void setShouldGroupAccessibilityChildren(boolean var1);

    @Override
    @Property(selector="accessibilityNavigationStyle")
    public native UIAccessibilityNavigationStyle getAccessibilityNavigationStyle();

    @Override
    @Property(selector="setAccessibilityNavigationStyle:")
    public native void setAccessibilityNavigationStyle(UIAccessibilityNavigationStyle var1);

    @Override
    @Property(selector="accessibilityIdentifier")
    public native String getAccessibilityIdentifier();

    @Override
    @Property(selector="setAccessibilityIdentifier:")
    public native void setAccessibilityIdentifier(String var1);

    public static UIImage create(File file) {
        return UIImage.createFromFile(file.getAbsolutePath());
    }

    public void saveToPhotosAlbum(VoidBlock2<UIImage, NSError> callback) {
        if (callback != null) {
            long context = id.getAndIncrement();
            CallbackWrapper l = new CallbackWrapper(callback, context);
            this.saveToPhotosAlbum(l, didFinishSaving, context);
        } else {
            this.saveToPhotosAlbum(null, null, 0L);
        }
    }

    @Bridge(symbol="UIImagePNGRepresentation", optional=true)
    public native NSData toPNGData();

    @Bridge(symbol="UIImageJPEGRepresentation", optional=true)
    public native NSData toJPEGData(@MachineSizedFloat double var1);

    @Bridge(symbol="UIImageWriteToSavedPhotosAlbum", optional=true)
    public native void saveToPhotosAlbum(NSObject var1, Selector var2, @Pointer long var3);

    @Method(selector="initWithContentsOfFile:")
    @Pointer
    protected native long initWithFile(String var1);

    @Method(selector="initWithData:")
    @Pointer
    protected native long init(NSData var1);

    @Method(selector="initWithData:scale:")
    @Pointer
    protected native long init(NSData var1, @MachineSizedFloat double var2);

    @Method(selector="initWithCGImage:")
    @Pointer
    protected native long init(CGImage var1);

    @Method(selector="initWithCGImage:scale:orientation:")
    @Pointer
    protected native long init(CGImage var1, @MachineSizedFloat double var2, UIImageOrientation var4);

    @Method(selector="initWithCIImage:")
    @Pointer
    protected native long init(CIImage var1);

    @Method(selector="initWithCIImage:scale:orientation:")
    @Pointer
    protected native long init(CIImage var1, @MachineSizedFloat double var2, UIImageOrientation var4);

    @Method(selector="drawAtPoint:")
    public native void draw(@ByVal CGPoint var1);

    @Method(selector="drawAtPoint:blendMode:alpha:")
    public native void draw(@ByVal CGPoint var1, CGBlendMode var2, @MachineSizedFloat double var3);

    @Method(selector="drawInRect:")
    public native void draw(@ByVal CGRect var1);

    @Method(selector="drawInRect:blendMode:alpha:")
    public native void draw(@ByVal CGRect var1, CGBlendMode var2, @MachineSizedFloat double var3);

    @Method(selector="drawAsPatternInRect:")
    public native void drawAsPattern(@ByVal CGRect var1);

    @Method(selector="resizableImageWithCapInsets:")
    public native UIImage createResizable(@ByVal UIEdgeInsets var1);

    @Method(selector="resizableImageWithCapInsets:resizingMode:")
    public native UIImage createResizable(@ByVal UIEdgeInsets var1, UIImageResizingMode var2);

    @Method(selector="imageWithAlignmentRectInsets:")
    public native UIImage create(@ByVal UIEdgeInsets var1);

    @Method(selector="imageWithRenderingMode:")
    public native UIImage create(UIImageRenderingMode var1);

    @Method(selector="imageNamed:")
    public static native UIImage create(String var0);

    @Method(selector="imageNamed:inBundle:compatibleWithTraitCollection:")
    public static native UIImage create(String var0, NSBundle var1, UITraitCollection var2);

    @Method(selector="imageWithContentsOfFile:")
    protected static native UIImage createFromFile(String var0);

    @Method(selector="imageWithData:")
    public static native UIImage create(NSData var0);

    @Method(selector="imageWithData:scale:")
    public static native UIImage create(NSData var0, @MachineSizedFloat double var1);

    @Method(selector="imageWithCGImage:")
    public static native UIImage create(CGImage var0);

    @Method(selector="imageWithCGImage:scale:orientation:")
    public static native UIImage create(CGImage var0, @MachineSizedFloat double var1, UIImageOrientation var3);

    @Method(selector="imageWithCIImage:")
    public static native UIImage create(CIImage var0);

    @Method(selector="imageWithCIImage:scale:orientation:")
    public static native UIImage create(CIImage var0, @MachineSizedFloat double var1, UIImageOrientation var3);

    @Method(selector="animatedImageNamed:duration:")
    public static native UIImage createAnimated(String var0, double var1);

    @Method(selector="animatedResizableImageNamed:capInsets:duration:")
    public static native UIImage createAnimatedResizable(String var0, @ByVal UIEdgeInsets var1, double var2);

    @Method(selector="animatedResizableImageNamed:capInsets:resizingMode:duration:")
    public static native UIImage createAnimatedResizable(String var0, @ByVal UIEdgeInsets var1, UIImageResizingMode var2, double var3);

    @Method(selector="animatedImageWithImages:duration:")
    public static native UIImage createAnimated(NSArray<UIImage> var0, double var1);

    @Method(selector="stretchableImageWithLeftCapWidth:topCapHeight:")
    public native UIImage createStretchable(@MachineSizedSInt long var1, @MachineSizedSInt long var3);

    static {
        ObjCRuntime.bind(UIImage.class);
    }

    private static class CallbackWrapper
    extends NSObject {
        private final VoidBlock2<UIImage, NSError> callback;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CallbackWrapper(VoidBlock2<UIImage, NSError> callback, long contextInfo) {
            this.callback = callback;
            LongMap longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(contextInfo, (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TypeEncoding(value="v@:@:^v")
        @Method(selector="image:didFinishSavingWithError:contextInfo:")
        private void didFinishSaving(UIImage image, NSError error, @Pointer long contextInfo) {
            this.callback.invoke((Object)image, (Object)error);
            LongMap longMap = callbacks;
            synchronized (longMap) {
                callbacks.remove(contextInfo);
            }
        }
    }

    public static class UIImagePtr
    extends Ptr<UIImage, UIImagePtr> {
    }
}

