/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSUUID;
import org.robovm.apple.uikit.UIDeviceBatteryState;
import org.robovm.apple.uikit.UIDeviceOrientation;
import org.robovm.apple.uikit.UIUserInterfaceIdiom;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIDevice
extends NSObject {
    public UIDevice() {
    }

    protected UIDevice(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="name")
    public native String getName();

    @Property(selector="model")
    public native String getModel();

    @Property(selector="localizedModel")
    public native String getLocalizedModel();

    @Property(selector="systemName")
    public native String getSystemName();

    @Property(selector="systemVersion")
    public native String getSystemVersion();

    @Property(selector="orientation")
    public native UIDeviceOrientation getOrientation();

    @Property(selector="identifierForVendor")
    public native NSUUID getIdentifierForVendor();

    @Property(selector="isGeneratingDeviceOrientationNotifications")
    public native boolean generatesDeviceOrientationNotifications();

    @Property(selector="isBatteryMonitoringEnabled")
    public native boolean isBatteryMonitoringEnabled();

    @Property(selector="setBatteryMonitoringEnabled:")
    public native void setBatteryMonitoringEnabled(boolean var1);

    @Property(selector="batteryState")
    public native UIDeviceBatteryState getBatteryState();

    @Property(selector="batteryLevel")
    public native float getBatteryLevel();

    @Property(selector="isProximityMonitoringEnabled")
    public native boolean isProximityMonitoringEnabled();

    @Property(selector="setProximityMonitoringEnabled:")
    public native void setProximityMonitoringEnabled(boolean var1);

    @Property(selector="proximityState")
    public native boolean isProximityState();

    @Property(selector="isMultitaskingSupported")
    public native boolean isMultitaskingSupported();

    @Property(selector="userInterfaceIdiom")
    public native UIUserInterfaceIdiom getUserInterfaceIdiom();

    @GlobalValue(symbol="UIDeviceOrientationDidChangeNotification", optional=true)
    public static native NSString OrientationDidChangeNotification();

    @GlobalValue(symbol="UIDeviceBatteryStateDidChangeNotification", optional=true)
    public static native NSString BatteryStateDidChangeNotification();

    @GlobalValue(symbol="UIDeviceBatteryLevelDidChangeNotification", optional=true)
    public static native NSString BatteryLevelDidChangeNotification();

    @GlobalValue(symbol="UIDeviceProximityStateDidChangeNotification", optional=true)
    public static native NSString ProximityStateDidChangeNotification();

    @Method(selector="beginGeneratingDeviceOrientationNotifications")
    public native void beginGeneratingDeviceOrientationNotifications();

    @Method(selector="endGeneratingDeviceOrientationNotifications")
    public native void endGeneratingDeviceOrientationNotifications();

    @Method(selector="playInputClick")
    public native void playInputClick();

    @Method(selector="currentDevice")
    public static native UIDevice getCurrentDevice();

    static {
        ObjCRuntime.bind(UIDevice.class);
    }

    public static class UIDevicePtr
    extends Ptr<UIDevice, UIDevicePtr> {
    }

    public static class Notifications {
        public static NSObject observeOrientationDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIDevice.OrientationDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeBatteryStateDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIDevice.BatteryStateDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeBatteryLevelDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIDevice.BatteryLevelDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeProximityStateDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIDevice.ProximityStateDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

