/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.coregraphics.CGColor;
import org.robovm.apple.coreimage.CIColor;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.uikit.UIImage;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIColor
extends NSObject {
    public UIColor() {
    }

    protected UIColor(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public UIColor(@MachineSizedFloat double red, @MachineSizedFloat double green, @MachineSizedFloat double blue, @MachineSizedFloat double alpha) {
        super(null);
        this.initObject(this.init(red, green, blue, alpha));
    }

    public UIColor(CGColor cgColor) {
        super(null);
        this.initObject(this.init(cgColor));
    }

    public UIColor(CIColor ciColor) {
        super(null);
        this.initObject(this.init(ciColor));
    }

    @Property(selector="CGColor")
    public native CGColor getCGColor();

    @Property(selector="CIColor")
    public native CIColor getCIColor();

    public double[] getWhiteAlpha() {
        MachineSizedFloatPtr white = new MachineSizedFloatPtr();
        MachineSizedFloatPtr alpha = new MachineSizedFloatPtr();
        boolean ret = this.getWhiteAlpha(white, alpha);
        if (ret) {
            double[] whiteAlpha = new double[]{white.get(), alpha.get()};
            return whiteAlpha;
        }
        return null;
    }

    public double[] getHSBA() {
        MachineSizedFloatPtr hue = new MachineSizedFloatPtr();
        MachineSizedFloatPtr saturation = new MachineSizedFloatPtr();
        MachineSizedFloatPtr brightness = new MachineSizedFloatPtr();
        MachineSizedFloatPtr alpha = new MachineSizedFloatPtr();
        boolean ret = this.getHSBA(hue, saturation, brightness, alpha);
        if (ret) {
            double[] hsba = new double[]{hue.get(), saturation.get(), brightness.get(), alpha.get()};
            return hsba;
        }
        return null;
    }

    public double[] getRGBA() {
        MachineSizedFloatPtr red = new MachineSizedFloatPtr();
        MachineSizedFloatPtr green = new MachineSizedFloatPtr();
        MachineSizedFloatPtr blue = new MachineSizedFloatPtr();
        MachineSizedFloatPtr alpha = new MachineSizedFloatPtr();
        boolean ret = this.getRGBA(red, green, blue, alpha);
        if (ret) {
            double[] rgba = new double[]{red.get(), green.get(), blue.get(), alpha.get()};
            return rgba;
        }
        return null;
    }

    @Method(selector="initWithRed:green:blue:alpha:")
    @Pointer
    protected native long init(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, @MachineSizedFloat double var7);

    @Method(selector="initWithCGColor:")
    @Pointer
    protected native long init(CGColor var1);

    @Method(selector="initWithCIColor:")
    @Pointer
    protected native long init(CIColor var1);

    @Method(selector="set")
    public native void setFillAndStroke();

    @Method(selector="setFill")
    public native void setFill();

    @Method(selector="setStroke")
    public native void setStroke();

    @Method(selector="getWhite:alpha:")
    protected native boolean getWhiteAlpha(MachineSizedFloatPtr var1, MachineSizedFloatPtr var2);

    @Method(selector="getHue:saturation:brightness:alpha:")
    protected native boolean getHSBA(MachineSizedFloatPtr var1, MachineSizedFloatPtr var2, MachineSizedFloatPtr var3, MachineSizedFloatPtr var4);

    @Method(selector="getRed:green:blue:alpha:")
    protected native boolean getRGBA(MachineSizedFloatPtr var1, MachineSizedFloatPtr var2, MachineSizedFloatPtr var3, MachineSizedFloatPtr var4);

    @Method(selector="colorWithAlphaComponent:")
    public native UIColor addAlpha(@MachineSizedFloat double var1);

    @Method(selector="colorWithWhite:alpha:")
    public static native UIColor fromWhiteAlpha(@MachineSizedFloat double var0, @MachineSizedFloat double var2);

    @Method(selector="colorWithHue:saturation:brightness:alpha:")
    public static native UIColor fromHSBA(@MachineSizedFloat double var0, @MachineSizedFloat double var2, @MachineSizedFloat double var4, @MachineSizedFloat double var6);

    @Method(selector="colorWithRed:green:blue:alpha:")
    public static native UIColor fromRGBA(@MachineSizedFloat double var0, @MachineSizedFloat double var2, @MachineSizedFloat double var4, @MachineSizedFloat double var6);

    @Method(selector="colorWithCGColor:")
    public static native UIColor fromCGColor(CGColor var0);

    @Method(selector="colorWithPatternImage:")
    public static native UIColor fromPatternImage(UIImage var0);

    @Method(selector="colorWithCIColor:")
    public static native UIColor fromCIColor(CIColor var0);

    @Method(selector="blackColor")
    public static native UIColor black();

    @Method(selector="darkGrayColor")
    public static native UIColor darkGray();

    @Method(selector="lightGrayColor")
    public static native UIColor lightGray();

    @Method(selector="whiteColor")
    public static native UIColor white();

    @Method(selector="grayColor")
    public static native UIColor gray();

    @Method(selector="redColor")
    public static native UIColor red();

    @Method(selector="greenColor")
    public static native UIColor green();

    @Method(selector="blueColor")
    public static native UIColor blue();

    @Method(selector="cyanColor")
    public static native UIColor cyan();

    @Method(selector="yellowColor")
    public static native UIColor yellow();

    @Method(selector="magentaColor")
    public static native UIColor magenta();

    @Method(selector="orangeColor")
    public static native UIColor orange();

    @Method(selector="purpleColor")
    public static native UIColor purple();

    @Method(selector="brownColor")
    public static native UIColor brown();

    @Method(selector="clearColor")
    public static native UIColor clear();

    @Method(selector="lightTextColor")
    public static native UIColor lightText();

    @Method(selector="darkTextColor")
    public static native UIColor darkText();

    @Method(selector="groupTableViewBackgroundColor")
    public static native UIColor groupTableViewBackground();

    @Deprecated
    @Method(selector="viewFlipsideBackgroundColor")
    public static native UIColor viewFlipsideBackground();

    @Deprecated
    @Method(selector="scrollViewTexturedBackgroundColor")
    public static native UIColor scrollViewTexturedBackground();

    @Deprecated
    @Method(selector="underPageBackgroundColor")
    public static native UIColor underPageBackground();

    static {
        ObjCRuntime.bind(UIColor.class);
    }

    public static class UIColorPtr
    extends Ptr<UIColor, UIColorPtr> {
    }
}

